/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.collector.db.DeviceTimeRepository;
import com.hs.atic.collector.entity.DevFlagEntity;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public final class DevDontWorkBuffer {
    private static DevDontWorkBuffer instance = new DevDontWorkBuffer();
    private static final int TIMEOUT = 600;
    private static final Logger LOG = LogManager.getInstance().getMonitorLog();
    private Map<DevFlagEntity, Long> cacheMap = Collections.synchronizedMap(new HashMap());

    private DevDontWorkBuffer() {
    }

    public static DevDontWorkBuffer getInstance() {
        return instance;
    }

    public synchronized void checkCache() {
        ArrayList<DevFlagEntity> result = new ArrayList<DevFlagEntity>();
        long nowTime = System.currentTimeMillis() / 1000L;
        Iterator<Map.Entry<DevFlagEntity, Long>> iter = this.cacheMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<DevFlagEntity, Long> entry = iter.next();
            DevFlagEntity key = entry.getKey();
            Long lastTime = entry.getValue();
            if (nowTime - lastTime <= 600L) continue;
            key.setStopWorkTime(lastTime);
            key.setStartWorkTime(0L);
            result.add(key);
            iter.remove();
        }
        if (!result.isEmpty()) {
            DeviceTimeRepository repository = new DeviceTimeRepository();
            repository.addInBatch(result);
        }
    }

    public synchronized void refresh(DevFlagEntity entity) {
        int devType;
        String devIp;
        DeviceTimeRepository repostitory;
        if (!this.cacheMap.containsKey(entity) && (repostitory = new DeviceTimeRepository()).isExist(devIp = entity.getDevIp(), devType = entity.getDevType())) {
            LOG.info((Object)("update DeviceTimeRepository " + entity));
            repostitory.update(entity);
        }
        this.cacheMap.put(entity, entity.getStopWorkTime());
    }
}

