/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipThread
extends Thread {
    private static final int BUFFEREDSIZE = 1024;
    private static final int SLEEP_TIME = 86400000;
    private static final Logger LOGGER = LogManager.getInstance().getZipBackLog();
    private String target;
    private String logBackDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: while (true) {
            FileOutputStream fout = null;
            try {
                try {
                    Thread.sleep(86400000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)" create zip error ", (Throwable)e);
                }
                File file = new File(this.target);
                if (!file.exists()) {
                    LOGGER.error((Object)"get logs target directory failed.");
                    continue;
                }
                LOGGER.debug((Object)"begin logs depress ");
                if (!file.isDirectory()) {
                    LOGGER.error((Object)"target is not a directory");
                    continue;
                }
                SimpleDateFormat formate = new SimpleDateFormat("yyyyMMddHHmmss");
                Date d = new Date();
                String timeStr = formate.format(d);
                File backDir = new File(AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + this.logBackDir + File.separator + timeStr);
                if (null == file.list()) {
                    LOGGER.error((Object)"file.list() is null");
                    continue;
                }
                String[] stringArray = file.list();
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block28;
                    String f = stringArray[n2];
                    File fi = new File(this.target + File.separator + f);
                    String fileName = fi.getName();
                    if (!fileName.contains(".log.") || fileName.contains("zip")) {
                        LOGGER.debug((Object)(fileName + " is droped !!"));
                    } else {
                        if (!backDir.exists() && !backDir.mkdirs()) {
                            LOGGER.error((Object)"mkdirs() error");
                        }
                        LOGGER.debug((Object)(fileName + " will be depress!!"));
                        String zipName = backDir.getPath() + File.separator + fileName + ".zip";
                        LOGGER.debug((Object)(fileName + " will be zip to " + fileName + ".zip"));
                        File zipFile = new File(zipName);
                        if (!zipFile.exists()) {
                            try {
                                if (zipFile.createNewFile()) {
                                    LOGGER.debug((Object)"createNewFile success");
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error((Object)"createNewFile call failed.", (Throwable)e);
                            }
                        }
                        fout = new FileOutputStream(zipFile);
                        this.writeToZip(fout, fi);
                    }
                    ++n2;
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("do zip back error" + e));
                continue;
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"do zip back error");
                continue;
            }
            finally {
                if (null == fout) continue;
                try {
                    fout.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("fout.close() error" + e));
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeToZip(FileOutputStream fout, File sourceFile) {
        if (fout == null) {
            return;
        }
        if (!sourceFile.exists()) {
            return;
        }
        ZipOutputStream zos = new ZipOutputStream(fout);
        FileInputStream in = null;
        try {
            int c;
            zos = new ZipOutputStream(fout);
            zos.putNextEntry(new ZipEntry(sourceFile.getName()));
            in = new FileInputStream(sourceFile);
            byte[] by = new byte[1024];
            while ((c = in.read(by)) != -1) {
                zos.write(by, 0, c);
            }
            zos.flush();
            ZipThread.freeDbResource(zos, fout, in);
            if (sourceFile.delete()) return;
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"new FileOutputStream  call failed.");
            return;
        }
        catch (IOException e2) {
            LOGGER.error((Object)"putNextEntry(new ZipEntry()) call failed.", (Throwable)e2);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ZipThread.freeDbResource(zos, fout, in);
            if (!sourceFile.delete()) {
                LOGGER.error((Object)"file.delete() call failed");
            }
        }
        LOGGER.error((Object)"file.delete() call failed");
        return;
    }

    public static void freeDbResource(ZipOutputStream zos, FileOutputStream fout, FileInputStream in) {
        try {
            zos.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"zos.close() call failed.", (Throwable)e);
        }
        try {
            fout.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"fout.close() call failed.", (Throwable)e);
        }
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"in.close() call failed.", (Throwable)e);
        }
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getLogBackDir() {
        return this.logBackDir;
    }

    public void setLogBackDir(String logBackDir) {
        this.logBackDir = logBackDir;
    }
}

