/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.alarm;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ZoneNotifyAlarmService;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DivertAlarmThread
extends Thread {
    public static final int ALARM_TYPE_DIVERT = 1;
    public static final int ALARM_TYPE_BLACKHOLE = 2;
    private static final String SERVICE_NAME = "ZoneNotifyAlarmService";
    private final Object lock = new Object();
    private Logger logger = LogManager.getInstance().getAlarmLog();
    private int alarmType;
    private Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = new ConcurrentHashMap<IpInfoKey, IpAlarmEntity>();
    private ZoneNotifyAlarmService zoneNotifyAlarmService;
    private long sleepTime = 20L;
    private long failureSleepTime = 5000L;
    private int loopCount = 5;

    public DivertAlarmThread(int alarmType1) {
        this.alarmType = alarmType1;
    }

    public void addWaitNotifyAlarm(IpInfoKey ipInfoKey, IpAlarmEntity ipAlarmEntity) {
        if (this.ipAlarmMap.size() <= AlarmThread.getAlarmSizeLimit()) {
            this.ipAlarmMap.put(ipInfoKey, ipAlarmEntity);
        } else {
            this.logger.error((Object)("drop a alarm for ipAlarmMap.size:" + this.ipAlarmMap.size() + " > limit:" + AlarmThread.getAlarmSizeLimit() + ". The drop ipAlarmEntity= " + ipAlarmEntity.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWaitNotifyAlarm(IpInfoKey ipInfoKey, IpAlarmEntity ipAlarmEntity) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ipAlarmMap.containsKey(ipInfoKey)) {
                this.ipAlarmMap.remove(ipInfoKey);
                this.logger.warn((Object)("drop a alarm for severity and action changed. ipAlarmEntity=" + ipAlarmEntity.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info((Object)"alarm thread start");
        Map<IpInfoKey, IpAlarmEntity> ipAlarmMapTemp = null;
        while (true) {
            try {
                while (true) {
                    if (null != this.getZoneAlarmService() && !this.ipAlarmMap.isEmpty()) {
                        Object object = this.lock;
                        synchronized (object) {
                            ipAlarmMapTemp = this.ipAlarmMap;
                            this.ipAlarmMap = new ConcurrentHashMap<IpInfoKey, IpAlarmEntity>();
                        }
                        ArrayList<IpAlarmEntity> alarmList = new ArrayList<IpAlarmEntity>();
                        alarmList.addAll(ipAlarmMapTemp.values());
                        this.logger.warn((Object)("Start notify alert, alarmList size=" + alarmList.size()));
                        for (IpAlarmEntity alarm : alarmList) {
                            this.logger.warn((Object)("notify alert, alarm=" + alarm.toString()));
                        }
                        if (2 == this.alarmType) {
                            this.zoneNotifyAlarmService.notifyBlackholeAlert(alarmList);
                        } else if (1 == this.alarmType) {
                            this.zoneNotifyAlarmService.notifyDivertAlert(alarmList);
                        }
                        ipAlarmMapTemp.clear();
                    }
                    this.threadSleep(this.sleepTime);
                }
            }
            catch (Exception e) {
                this.zoneNotifyAlarmService = null;
                if (null != ipAlarmMapTemp) {
                    this.ipAlarmMap.putAll(ipAlarmMapTemp);
                    ipAlarmMapTemp.clear();
                }
                this.logger.error((Object)"catch exception when run BlackholeAlarmThread", (Throwable)e);
                this.threadSleep(this.sleepTime);
                continue;
            }
            break;
        }
    }

    private ZoneNotifyAlarmService getZoneAlarmService() {
        if (null == this.zoneNotifyAlarmService) {
            for (int i = 0; i < this.loopCount; ++i) {
                block5: {
                    try {
                        this.zoneNotifyAlarmService = (ZoneNotifyAlarmService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
                        if (this.zoneNotifyAlarmService != null) {
                            this.logger.info((Object)"getZoneAlarmService success");
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (this.loopCount - 1 != i) break block5;
                        this.logger.error((Object)("get getZoneAlarmService failed for " + this.loopCount + " times."), (Throwable)e);
                    }
                }
                this.threadSleep(this.failureSleepTime);
            }
        }
        return this.zoneNotifyAlarmService;
    }

    private void threadSleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("get InterruptedException when sleep time=" + time), (Throwable)e);
        }
    }
}

