/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.DefaultConsumerFactory;
import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.CleanAttackEventThread;
import com.hs.atic.collector.biz.event.CleanIpAttackExactLogThread;
import com.hs.atic.collector.biz.event.process.EventPacketFilter;
import com.hs.atic.collector.biz.event.process.EventTypeProcessor;
import com.hs.atic.collector.biz.event.process.NotifyZoneHandler;
import com.hs.atic.collector.biz.event.process.PacketsDispatchConsumer;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.DbImportTool;
import com.hs.atic.collector.entity.Collector;
import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.DynBlistAlarmEntity;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.init.ModelInterface;
import com.hs.atic.collector.init.UdpManagerThread;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ZoneConfService;
import com.hs.atic.rmi.ZoneState;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class EventModel
implements ModelInterface {
    private static EventTypeProcessor typeProcessor = new EventTypeProcessor();
    private static UdpManagerThread eventManagerThread;
    private static final Logger LOGGER;
    private static EventModel eventModelInstance;
    private static final String IP_CLEAN_ATTACK_TABLE = "ATIC_IP_ATTACK_LOG";
    private static final String ONLY_ATTACK_TABLE = "ATIC_ATTACK_LOG";
    private static final String ZONE_CLEAN_ATTACK_TABLE = "ATIC_ZONE_ATTACK_LOG";
    private static final String BIZ_ATTACK_TABLE = "ATIC_BIZ_ATTACK_LOG";
    private static final String ZONE_BLACKLIST_TABLE = "ATIC_ZONE_BLACKLIST";
    private static final String SERVICE_NAME = "ZoneConfService";
    Buffer<TimeDatagramPacket> parseBuffer = new Buffer();
    PacketsDispatchConsumer packetsDispatchConsumer = DefaultConsumerFactory.getInstance().getEventConsumer();

    private EventModel() {
        this.packetsDispatchConsumer.setBuffer(this.parseBuffer);
        typeProcessor.setFilter(new EventPacketFilter());
        typeProcessor.setBuffer(this.parseBuffer);
    }

    public static EventModel getInstance() {
        return eventModelInstance;
    }

    @Override
    public void start() {
        this.createDirectory(EventUtil.XML_DIRECTORY);
        this.createDirectory(EventUtil.EVENT_FILE_DIRECTORY);
        this.createDirectory(EventUtil.ERROR_EVENT_FILE_DIRECTORY);
        Thread thread = new Thread(DbImportTool.getInstance());
        thread.setName("DB Import Thread");
        CrashThreadHandler crashThreadHandler = CrashThreadHandler.getInstance();
        thread.setUncaughtExceptionHandler(crashThreadHandler);
        thread.start();
        Collector.getInstance();
        this.cleanUp();
        this.packetsDispatchConsumer.setUncaughtExceptionHandler(crashThreadHandler);
        this.packetsDispatchConsumer.start();
        this.startUdpManagers(crashThreadHandler);
    }

    @Override
    public EventTypeProcessor getProcessor() {
        return typeProcessor;
    }

    private void createDirectory(String dir) {
        File file = new File(dir);
        if (!file.exists() && !file.mkdir()) {
            LOGGER.error((Object)"when create xml directory,fail.");
        }
    }

    @Override
    public void stop() {
    }

    protected static void freeDbResource(ResultSet rs, Connection con, PreparedStatement stmt) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rs.close() error SQLException", (Throwable)e);
            }
        }
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBlackList() {
        String querySql = "SELECT DEVICE_IP,ZONE_ID,BLACK_IP,STATUS,BLACK_TYPE,PROTOCOL,PORT,ZONE_IP FROM ATIC_ZONE_BLACKLIST";
        String deleteSql = "DELETE FROM ATIC_ZONE_BLACKLIST";
        Connection con = null;
        PreparedStatement query = null;
        PreparedStatement delete = null;
        ResultSet rs = null;
        ArrayList<DynBlistAlarmEntity> resume = new ArrayList<DynBlistAlarmEntity>();
        try {
            con = DBConnPool.getConnection();
            if (null != con) {
                query = con.prepareStatement(querySql);
                delete = con.prepareStatement(deleteSql);
                rs = query.executeQuery();
                while (rs.next()) {
                    DynBlistAlarmEntity alarm = new DynBlistAlarmEntity(rs.getString(1), rs.getLong(2), "", rs.getString(3), rs.getInt(4));
                    alarm.setBlackListType(rs.getInt(5));
                    alarm.setProtocol(rs.getInt(6));
                    alarm.setPort(rs.getInt(7));
                    alarm.setIsAlarm(false);
                    alarm.setAlertTime(System.currentTimeMillis());
                    alarm.setZoneIp(rs.getString(8));
                    resume.add(alarm);
                }
                delete.executeUpdate();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"cleanBlackList error!!");
        }
        finally {
            EventModel.freeDbResource(null, null, delete);
            EventModel.freeDbResource(rs, con, query);
        }
        AlarmThread.getInstance().addDynBlistAlarm(resume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long cleanExceptionEvents() {
        String querySql = " SELECT PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,ZONE_IP,ATTACK_TYPE,PROTOCOL,PORT,ATTACK_STATUS,START_TIME_ALERT,END_TIME, LIMIT_VALUE,CURRENT_VALUE,PPS_OR_KBPS,LIMIT_VALUE_1,CURRENT_VALUE_1,PPS_OR_KBPS_1,DROP_PACKETS, IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS FROM ATIC_ATTACK_LOG";
        String deleteSql = "DELETE FROM ATIC_ATTACK_LOG";
        Connection con = null;
        PreparedStatement query = null;
        PreparedStatement delete = null;
        ResultSet rs = null;
        ArrayList<AbnormalAlarmEntity> resume = new ArrayList<AbnormalAlarmEntity>();
        long minStartTime = Long.MAX_VALUE;
        try {
            con = DBConnPool.getConnection();
            if (null != con) {
                query = con.prepareStatement(querySql);
                delete = con.prepareStatement(deleteSql);
                rs = query.executeQuery();
                while (rs.next()) {
                    minStartTime = minStartTime < rs.getLong(10) ? minStartTime : rs.getLong(10);
                    AbnormalAlarmEntity alarm = new AbnormalAlarmEntity();
                    alarm.setPkId(rs.getLong(1));
                    alarm.setDeviceIp(rs.getString(2));
                    alarm.setDirection(rs.getInt(3));
                    alarm.setDeviceType(rs.getInt(4));
                    alarm.setZoneId(rs.getLong(5));
                    if (CommonUtil.isNull(rs.getString(6))) {
                        alarm.setZoneIp("-");
                    } else {
                        alarm.setZoneIp(rs.getString(6));
                    }
                    alarm.setAlertTypeValue(rs.getInt(7));
                    alarm.setProtocol(rs.getInt(8));
                    alarm.setPort(rs.getInt(9));
                    if (rs.getLong(12) == 0L) {
                        alarm.setStartTime(System.currentTimeMillis());
                    } else {
                        alarm.setStartTime(rs.getLong(12) * 1000L);
                    }
                    alarm.setEndTime(System.currentTimeMillis());
                    alarm.setLimitValue(rs.getLong(13));
                    alarm.setCurrentValue(rs.getLong(14));
                    alarm.setPpsOrKbps(rs.getInt(15));
                    alarm.setLimitValue1(rs.getLong(16));
                    alarm.setCurrentValue1(rs.getLong(17));
                    alarm.setPpsOrKbps1(rs.getInt(18));
                    alarm.setDropPacket(rs.getLong(19));
                    alarm.setIpAttackPeakPps(rs.getLong(20));
                    alarm.setIpAttackPeakKbps(rs.getLong(21));
                    alarm.setIpInPeakPps(rs.getLong(22));
                    alarm.setIpInPeakKbps(rs.getLong(23));
                    alarm.setTcpNewConnNum(rs.getLong(24));
                    alarm.setTcpCurConnNum(rs.getLong(25));
                    alarm.setPorts(rs.getString(26));
                    alarm.setMultiCurrent(AttackTypeFactory.getInstance().isConnectionFlood(new AttackType(alarm.getAlertTypeValue(), alarm.getProtocol(), alarm.getPort())));
                    alarm.setAlarm(false);
                    resume.add(alarm);
                }
                delete.executeUpdate();
                LOGGER.error((Object)"clean atic_attack_log ok");
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"clean event error!!");
        }
        finally {
            EventModel.freeDbResource(null, null, delete);
            EventModel.freeDbResource(rs, con, query);
        }
        try {
            AlarmThread.getInstance().addAbnormalAlarm(resume);
        }
        catch (Exception e) {
            LOGGER.error((Object)"init alarm events error!!", (Throwable)e);
        }
        return minStartTime;
    }

    private void cleanIpAttackEvents(Long maxEndTime) {
        CleanAttackEventThread ipAttackEvent = new CleanAttackEventThread();
        ipAttackEvent.setTableName(IP_CLEAN_ATTACK_TABLE);
        ipAttackEvent.setMaxEndTime(maxEndTime);
        Thread cleanIpAttackEventThread = new Thread(ipAttackEvent);
        cleanIpAttackEventThread.setName("cleanIpAttackEventThread");
        cleanIpAttackEventThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        cleanIpAttackEventThread.start();
    }

    private void cleanBizAttackEvents(Long maxEndTime) {
        CleanAttackEventThread bizAttackEvent = new CleanAttackEventThread();
        bizAttackEvent.setTableName(BIZ_ATTACK_TABLE);
        bizAttackEvent.setMaxEndTime(maxEndTime);
        Thread cleanBizAttackEventThread = new Thread(bizAttackEvent);
        cleanBizAttackEventThread.setName("cleanBizAttackEventThread");
        cleanBizAttackEventThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        cleanBizAttackEventThread.start();
    }

    private void cleanUp() {
        this.cleanBlackList();
        this.sendZoneStateStatus();
        Long minStartTime = this.cleanExceptionEvents();
        Long maxEndTime = System.currentTimeMillis() / 1000L;
        this.cleanIpAttackExactLog(minStartTime, maxEndTime);
        this.cleanIpAttackEvents(maxEndTime);
        this.cleanBizAttackEvents(maxEndTime);
        this.cleanZoneAttackEvents(maxEndTime);
    }

    private void cleanIpAttackExactLog(Long minStartTime, Long maxEndTime) {
        CleanIpAttackExactLogThread cleanAttackEventThread = CleanIpAttackExactLogThread.getInstance();
        cleanAttackEventThread.setMinStartTime(minStartTime);
        cleanAttackEventThread.setMaxEndTime(maxEndTime);
        Thread cleanIpAttackExactLogThread = new Thread(cleanAttackEventThread);
        cleanIpAttackExactLogThread.setName("cleanIpAttackExactLogThread");
        cleanIpAttackExactLogThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        cleanIpAttackExactLogThread.start();
    }

    private void cleanZoneAttackEvents(Long maxEndTime) {
        CleanAttackEventThread zoneAttackEvent = new CleanAttackEventThread();
        zoneAttackEvent.setTableName(ZONE_CLEAN_ATTACK_TABLE);
        zoneAttackEvent.setMaxEndTime(maxEndTime);
        Thread cleanZoneAttackEventThread = new Thread(zoneAttackEvent);
        cleanZoneAttackEventThread.setName("cleanZoneAttackEventThread");
        cleanZoneAttackEventThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        cleanZoneAttackEventThread.start();
    }

    private void sendZoneStateStatus() {
        try {
            ZoneConfService listener = (ZoneConfService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
            List<ZoneState> list = this.getAbnormalZoneState();
            if (null == listener) {
                NotifyZoneHandler zonehandler = NotifyZoneHandler.getInstance();
                LOGGER.info((Object)"add initZoneState to NotifyZoneHandler");
                zonehandler.notifyInitZoneStateStatus(list);
                return;
            }
            String collectorIp = System.getProperty("java.rmi.server.hostname");
            listener.notifyZoneStateInList(list, collectorIp);
        }
        catch (Exception e) {
            LOGGER.error((Object)"GET ZONESTATESTATUS SERVICE ERROR!!!! sendZoneStateStatus failure!!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZoneState> getAbnormalZoneState() {
        ArrayList<ZoneState> list;
        ResultSet rs;
        PreparedStatement statement;
        Connection con;
        block6: {
            String sql = "SELECT device_ip,device_type,zone_id,MAX(ATTACK_STATUS) FROM ATIC_ZONE_ATTACK_LOG WHERE ATTACK_STATUS<>0 GROUP BY device_ip,device_type,zone_id";
            con = null;
            statement = null;
            rs = null;
            list = new ArrayList<ZoneState>();
            try {
                con = DBConnPool.getConnection();
                if (null != con) {
                    statement = con.prepareStatement(sql);
                    rs = statement.executeQuery();
                }
                if (null == rs) break block6;
                while (rs.next()) {
                    ZoneState zoneState = new ZoneState();
                    zoneState.setDeviceIp(rs.getString(1));
                    zoneState.setZoneId(rs.getLong(3));
                    zoneState.setState(1);
                    list.add(zoneState);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)("clean event error, and sql is: " + sql + "; ERROR IS  " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    EventModel.freeDbResource(rs, con, statement);
                    throw throwable;
                }
                EventModel.freeDbResource(rs, con, statement);
            }
        }
        EventModel.freeDbResource(rs, con, statement);
        return list;
    }

    private void startUdpManagers(CrashThreadHandler crashThreadHandler) {
        int enevtPort = 9110;
        try {
            enevtPort = Integer.parseInt(EventUtil.getEventConfigProperty("Port"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"NumberFormatException error ");
        }
        EventModel.setEventManagerThread(new UdpManagerThread(enevtPort));
        eventManagerThread.addTypeProcessor(typeProcessor);
        eventManagerThread.setUncaughtExceptionHandler(crashThreadHandler);
        eventManagerThread.start();
    }

    @Override
    public Buffer<TimeDatagramPacket> getBuffer() {
        return this.parseBuffer;
    }

    public static UdpManagerThread getEventManagerThread() {
        return eventManagerThread;
    }

    public static void setEventManagerThread(UdpManagerThread eventManagerThread) {
        EventModel.eventManagerThread = eventManagerThread;
    }

    static {
        LOGGER = LogManager.getInstance().getReceiveLog();
        eventModelInstance = new EventModel();
    }
}

