/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.DefaultConsumerFactory;
import com.hs.atic.collector.biz.event.nfa.NfaPacketFilter;
import com.hs.atic.collector.biz.event.process.EventTypeProcessor;
import com.hs.atic.collector.biz.event.process.PacketsDispatchConsumer;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.init.ModelInterface;
import com.hs.atic.collector.init.UdpManagerThread;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import org.apache.log4j.Logger;

public final class NfaModel
implements ModelInterface {
    private static EventTypeProcessor typeProcessor = new EventTypeProcessor();
    private static Buffer<TimeDatagramPacket> parseBuffer = new Buffer();
    private static PacketsDispatchConsumer consumer = DefaultConsumerFactory.getInstance().getNfaEventConsumer();
    private static UdpManagerThread nfaManagerThread;
    private static NfaModel instance;
    private static final Logger LOGGER;

    private NfaModel() {
        if (null == consumer.getBuffer()) {
            consumer.setBuffer(parseBuffer);
            typeProcessor.setBuffer(parseBuffer);
        } else {
            typeProcessor.setBuffer(consumer.getBuffer());
        }
        typeProcessor.setFilter(new NfaPacketFilter());
        boolean isNeedDecrypt = true;
        try {
            isNeedDecrypt = Boolean.valueOf(EventUtil.getEventConfigProperty("isNeedDecrypt"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Get isNeedDecrypt error");
        }
        typeProcessor.setNeedDecrypt(isNeedDecrypt);
    }

    public static synchronized NfaModel getInstance() {
        if (instance == null) {
            instance = new NfaModel();
        }
        return instance;
    }

    @Override
    public Buffer getBuffer() {
        return parseBuffer;
    }

    @Override
    public EventTypeProcessor getProcessor() {
        return typeProcessor;
    }

    @Override
    public void start() {
        if (!consumer.isAlive()) {
            consumer.start();
        }
        this.startUdpManagers();
    }

    private void startUdpManagers() {
        int nfaPort = 9114;
        try {
            nfaPort = Integer.parseInt(EventUtil.getEventConfigProperty("NfaPort"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Get NfaPort error");
        }
        NfaModel.setNfaManagerThread(new UdpManagerThread(nfaPort));
        nfaManagerThread.addTypeProcessor(typeProcessor);
        CrashThreadHandler crashThreadHandler = CrashThreadHandler.getInstance();
        nfaManagerThread.setUncaughtExceptionHandler(crashThreadHandler);
        nfaManagerThread.start();
    }

    @Override
    public void stop() {
    }

    public static UdpManagerThread getNfaManagerThread() {
        return nfaManagerThread;
    }

    public static void setNfaManagerThread(UdpManagerThread nfaManagerThread) {
        NfaModel.nfaManagerThread = nfaManagerThread;
    }

    static {
        instance = null;
        LOGGER = LogManager.getInstance().getReceiveLog();
    }
}

