/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.PacketParser;
import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.biz.event.process.EventPacketParserFactory;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.entity.DefaultBizMappingEntity;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class NfaPacketParser
implements PacketParser<Event> {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final long DEFAULT_ZONE_ID = 1L;
    private static final long DEFAULT_BIZ_ID = 0L;
    private String deviceIp;
    private long logTime;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Event> parsePacket(TimeDatagramPacket packet) {
        ArrayList<Event> entitys = new ArrayList<Event>();
        this.deviceIp = IpTransformer.formatIpAddress(packet.getAddress());
        this.logTime = packet.getTime();
        byte[] allData = packet.getData();
        UnsignedDataInputStream stream = new UnsignedDataInputStream(new ByteArrayInputStream(allData));
        try {
            int temp = stream.readUnsignedByte();
            this.version = temp >> 4 & 0xF;
            int logType = temp & 0xF;
            int extLogNum = stream.readUnsignedByte();
            stream.readUnsignedShort();
            LOGGER.debug((Object)("This nfa packet from deviceIp=" + this.deviceIp + ", data is " + CommonUtil.getByteArrayStr(allData)));
            List<NfaEventDataParser> typeParsers = EventPacketParserFactory.getInstance().getNfaEventParsers(this.version);
            for (int i = 0; i < extLogNum; ++i) {
                long bizId;
                long zoneId = stream.readUnsignedInt();
                int ipType = stream.readUnsignedByte();
                int direction = stream.readUnsignedByte();
                LOGGER.debug((Object)("Nfa packet direction : " + direction));
                int thirdLogNum = stream.readUnsignedByte();
                stream.readUnsignedByte();
                String zoneIp = "";
                boolean isZoneEvent = false;
                if (4 == ipType) {
                    zoneIp = IpTransformer.long2StringFormat(stream.readUnsignedInt());
                } else if (6 == ipType) {
                    byte[] b = new byte[16];
                    if (stream.read(b) != 16) {
                        LOGGER.debug((Object)"stream read error");
                    }
                    zoneIp = IpTransformer.byte2String(b, 6);
                } else if (0 == ipType) {
                    isZoneEvent = true;
                    long b = stream.readUnsignedInt();
                } else {
                    LOGGER.error((Object)("Drop a log of error ipType=" + ipType + ", deviceIp=" + this.deviceIp + ", zoneId=" + zoneId));
                    ArrayList<Event> b = entitys;
                    return b;
                }
                if (1L == zoneId) {
                    try {
                        zoneId = FoundIDUtil.getInstance().getDefaultZoneIdByDevIp(this.deviceIp);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("i drop a packet for get default zone id error! The ATIC has not default zone of deviceIp=" + this.deviceIp), (Throwable)e);
                        ArrayList<Event> arrayList = entitys;
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)"Close stream error.", (Throwable)e2);
                        }
                        return arrayList;
                    }
                }
                if (0L == (bizId = this.getDefBizId(zoneId, direction))) {
                    LOGGER.error((Object)("i drop a packet for get biz id error! The ATIC has not zone of zoneId=" + zoneId + ", deviceIp=" + this.deviceIp));
                    ArrayList<Event> e2 = entitys;
                    return e2;
                }
                EventIdentifier identifer = new EventIdentifier();
                identifer.setLogTime(this.logTime);
                identifer.setDeviceIp(this.deviceIp);
                identifer.setZoneId(zoneId);
                identifer.setZoneIp(zoneIp);
                identifer.setBizId(bizId);
                identifer.setDeviceType(1);
                identifer.setDeviceTypeName("NFA");
                identifer.setDirection(direction);
                if (isZoneEvent) {
                    identifer.setZoneType();
                } else {
                    identifer.setZoneIpType();
                }
                IpSuitEvent ipEvent = new IpSuitEvent(identifer);
                for (NfaEventDataParser parser : typeParsers) {
                    parser.parseData(ipEvent, stream, logType, thirdLogNum);
                }
                entitys.addAll(ipEvent.getEntitys());
            }
            LOGGER.debug((Object)("The receive packtes is: " + this.getcleanedMessage(((Object)entitys).toString())));
            ArrayList<Event> arrayList = entitys;
            return arrayList;
        }
        catch (IOException e) {
            LOGGER.error((Object)("When parse packet, error happens and packet is " + CommonUtil.getByteArrayStr(allData)), (Throwable)e);
            ArrayList<Event> arrayList = new ArrayList<Event>();
            return arrayList;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close stream error.", (Throwable)e);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private long getDefBizId(long zoneId, int direction) {
        long bizId = 0L;
        try {
            bizId = FoundIDUtil.getInstance().getBizIDByDevIP(new DefaultBizMappingEntity(this.deviceIp, zoneId, direction));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get default biz id error", (Throwable)e);
        }
        return bizId;
    }
}

