/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class NfaParserAttackSrcEventV1
implements NfaEventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    @Override
    public void parseData(IpSuitEvent suitEvent, UnsignedDataInputStream stream, int logType, int logNum) throws IOException {
        if (2 == logType) {
            for (int i = 0; i < logNum; ++i) {
                this.parseAttackSrcData(suitEvent, stream);
            }
        }
    }

    private void parseAttackSrcData(IpSuitEvent suitEvent, UnsignedDataInputStream stream) throws IOException {
        OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
        event.setAttackSrcEvent(true);
        event.setCurrentState(1);
        int iAtckType = stream.readUnsignedByte();
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(iAtckType, 0, 0);
        event.setAttackType(attackType);
        int tlvNum = stream.readUnsignedByte();
        stream.readUnsignedShort();
        for (int i = 0; i < tlvNum; ++i) {
            int j;
            int ipType = stream.readUnsignedByte();
            stream.readUnsignedByte();
            int length = stream.readUnsignedShort();
            int ipNum = 0;
            if (41 == ipType) {
                ipNum = length / 4;
                for (j = 0; j < ipNum; ++j) {
                    String srcIp = IpTransformer.long2StringFormat(stream.readUnsignedInt());
                    event.addAttacker(srcIp);
                }
                continue;
            }
            if (42 == ipType) {
                ipNum = length / 16;
                for (j = 0; j < ipNum; ++j) {
                    byte[] b = new byte[16];
                    if (stream.read(b) != 16) {
                        LOGGER.debug((Object)"stream read error");
                    }
                    String srcIp = IpTransformer.byte2String(b, 6);
                    event.addAttacker(srcIp);
                }
                continue;
            }
            LOGGER.error((Object)("error ipType=" + ipType + " from device " + event.getDeviceIp()));
        }
        suitEvent.addOriginalExceptionEvent(event);
    }
}

