/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.biz.event.nfa.NfaPayloadConstants;
import com.hs.atic.collector.biz.event.nfa.NfaUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.AttackEventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class NfaParserExceptionEventV1
implements NfaEventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void parseData(IpSuitEvent suitEvent, UnsignedDataInputStream stream, int logType, int logNum) throws IOException {
        if (1 == logType) {
            for (int i = 0; i < logNum; ++i) {
                OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                int iAtckType = stream.readUnsignedByte();
                int attackStatus = stream.readUnsignedByte();
                int tlvNum = stream.readUnsignedByte();
                stream.readUnsignedByte();
                Map<Integer, Object> payloadMap = NfaUtil.getInstance().parsePayloadMap(stream, tlvNum);
                NfaUtil.getInstance().transPayload2Params(event, payloadMap, NfaPayloadConstants.getAbnomalParamsKeyMap());
                if (62 == iAtckType) {
                    LOGGER.debug((Object)"get a filter attack log");
                    Long filterId = (Long)payloadMap.get(5);
                    if (null != filterId) {
                        iAtckType = filterId.intValue() + 2000;
                        LOGGER.debug((Object)("filter id=" + filterId));
                    }
                }
                AttackType attackType = AttackTypeFactory.getInstance().getAttackType(iAtckType, 0, 0);
                event.setAttackType(attackType);
                AttackEventUtil.setExceptionEventType(event, attackStatus);
                if (event.getRealValue() > 0L && event.getNormalValue() > 0L && event.getRealValue() >= event.getNormalValue()) {
                    event.setPpsOrKbps(1);
                    event.setPpsOrKbps1(0);
                } else if (event.getRealValue1() > 0L && event.getNormalValue1() > 0L && event.getRealValue1() >= event.getNormalValue1()) {
                    long kbpsLimit = event.getNormalValue();
                    long kbpsCurr = event.getRealValue();
                    event.setNormalValue(event.getNormalValue1());
                    event.setRealValue(event.getRealValue1());
                    event.setPpsOrKbps(0);
                    event.setNormalValue1(kbpsLimit);
                    event.setRealValue1(kbpsCurr);
                    event.setPpsOrKbps1(1);
                } else if (attackStatus == 2) {
                    event.setPpsOrKbps(1);
                    event.setPpsOrKbps1(0);
                } else {
                    LOGGER.error((Object)("Drop a excetion log of current and realValue error: " + this.getcleanedMessage(event.toString())));
                    continue;
                }
                event.setAlertStartTime(event.getLogTime());
                event.setAlertEndTime(event.getLogTime());
                suitEvent.addOriginalExceptionEvent(event);
            }
        }
    }
}

