/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AbnormalEventParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    public int parse(UnsignedDataInputStream stream, OriginalExceptionEvent event) throws IOException {
        int type = stream.readUnsignedByte();
        if (type < 10) {
            type = 0;
        }
        if (event.getIdentifier().getVersion() == 1) {
            switch (type) {
                case 18: {
                    type = 35;
                    break;
                }
                case 22: {
                    type = 37;
                    break;
                }
                case 23: {
                    type = 38;
                    break;
                }
                case 24: {
                    type = 39;
                    break;
                }
            }
        }
        int protocol = 0;
        int port = 0;
        int state = stream.readUnsignedByte();
        int ipCount = stream.readUnsignedShort() / 4 - 4;
        if (type >= 10) {
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            stream.readUnsignedShort();
        } else {
            protocol = stream.readUnsignedByte();
            stream.readUnsignedByte();
            port = stream.readUnsignedShort();
        }
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            String deviceIp = event.getIdentifierCopy().getDeviceIp();
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifierCopy().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, deviceIp);
            LOGGER.info((Object)("AbnormalEventParser user defined biz id is :" + bizId));
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        event.setDropKbits(stream.readUnsignedInt());
        event.setDropPkgs(stream.readUnsignedInt());
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        for (int i = 0; i < ipCount; ++i) {
            long ip = stream.readUnsignedInt();
            String ipStr = IpTransformer.long2StringFormat(ip);
            if (!IPUtil.isIpv4(ipStr)) continue;
            event.addAttacker(ipStr);
        }
        return state;
    }
}

