/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;

public class AbnormalEventParserV2 {
    public int parse(UnsignedDataInputStream stream, OriginalExceptionEvent event) throws IOException {
        int type = stream.readUnsignedByte();
        if (type < 10) {
            type = 0;
        }
        int protocol = 0;
        int port = 0;
        int state = stream.readUnsignedByte();
        int length = stream.readUnsignedShort();
        int ipCount = length / 4 - 6;
        if (type >= 10) {
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            stream.readUnsignedShort();
        } else {
            protocol = stream.readUnsignedByte();
            stream.readUnsignedByte();
            port = length;
        }
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, event.getIdentifier().getDeviceIp());
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        stream.readUnsignedInt();
        event.setDropPkgs(stream.readUnsignedInt());
        event.setRealValue(stream.readUnsignedInt());
        event.setNormalValue(stream.readUnsignedInt());
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        for (int i = 0; i < ipCount; ++i) {
            long ip = stream.readUnsignedInt();
            String ipStr = IpTransformer.long2StringFormat(ip);
            if (!IPUtil.isIpv4(ipStr)) continue;
            event.addAttacker(ipStr);
        }
        return state;
    }
}

