/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.Cpu5minEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllCpu5minSumHandler<T extends Event>
extends EventHandler<T, T> {
    protected Map<Type, Cpu5minEvent<T>> ipEventMaps = new HashMap<Type, Cpu5minEvent<T>>();
    private final int period;
    private long lastTime;

    public AllCpu5minSumHandler(int period) {
        this.period = period;
        this.refreshLastTime();
    }

    protected void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(this.period);
    }

    protected void sumEvents(List<T> events) {
        for (Event t : events) {
            IpType type = new IpType(t.getEventTypeString(), t.getIdentifier(), false);
            if (this.ipEventMaps.containsKey(type)) {
                this.ipEventMaps.get(type).addEvent(t);
                continue;
            }
            this.ipEventMaps.put(type, new Cpu5minEvent<Event>(t));
        }
    }

    protected void refreshLogTime(List<T> eventsAfterMergeByIp) {
        long time = EventUtil.getIntegralTime(this.period);
        time -= (long)this.period;
        for (Event event : eventsAfterMergeByIp) {
            event.setLogTime(time);
        }
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    @Override
    public void handel(List<T> events) {
        try {
            this.handelEvents(events);
            if (this.isTimeToMerge()) {
                this.logger.info((Object)("Time to AllCpu5minSum, event size=" + this.ipEventMaps.size() + "; MBeanResourceFactory.flowMessage5min=" + MBeanResourceFactory.FLOW_MESSAGE_5MIN));
                ArrayList<T> list = new ArrayList<T>();
                for (Map.Entry<Type, Cpu5minEvent<T>> entry : this.ipEventMaps.entrySet()) {
                    list.addAll(entry.getValue().average());
                }
                this.ipEventMaps.clear();
                MBeanResourceFactory.FLOW_MESSAGE_5MIN.clearCounter();
                this.refreshLastTime();
                this.refreshLogTime(list);
                this.notifyFollowHandlers(list);
            }
        }
        catch (OutOfMemoryError error) {
            this.ipEventMaps.clear();
            this.logger.error((Object)"out of memory ,then I clear the  data", (Throwable)error);
        }
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        this.sumEvents(events);
        for (Event t : events) {
            if (!t.isDeviceEvent()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("revice a packet to AllCpuMinSumHandler:" + t.toString()));
                continue;
            }
            if (!t.isDeviceEvent()) continue;
            this.logger.warn((Object)("5minhandelEvents isDeviceEvent maxType = " + t.isIsMaxEvent() + " dropType = " + t.isIsDropFlow() + t.toString()));
        }
        return new ArrayList();
    }
}

