/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.CpuCycleEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllCpuCycleSumHandler<T extends Event>
extends EventHandler<T, T> {
    protected Map<Type, CpuCycleEvent<T>> ipEventMaps = new HashMap<Type, CpuCycleEvent<T>>();
    private final int period;
    private long lastTime;

    public AllCpuCycleSumHandler(int period) {
        this.period = period;
        this.refreshLastTime();
    }

    protected void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(this.period);
    }

    protected void sumEvents(List<T> events) {
        for (Event t : events) {
            IpType type = new IpType(t.getEventTypeString(), t.getIdentifier(), false);
            if (this.ipEventMaps.containsKey(type)) {
                this.ipEventMaps.get(type).addEvent(t);
                continue;
            }
            this.ipEventMaps.put(type, new CpuCycleEvent<Event>(t));
        }
    }

    protected void refreshLogTime(List<T> eventsAfterMergeByIp) {
        long time = EventUtil.getIntegralTime(this.period);
        time -= (long)this.period;
        for (Event event : eventsAfterMergeByIp) {
            event.setLogTime(time);
        }
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    @Override
    public void handel(List<T> events) {
        try {
            this.handelEvents(events);
            if (this.isTimeToMerge()) {
                ArrayList<T> list = new ArrayList<T>();
                for (Map.Entry<Type, CpuCycleEvent<T>> entry : this.ipEventMaps.entrySet()) {
                    list.addAll(entry.getValue().average());
                }
                this.ipEventMaps.clear();
                this.refreshLastTime();
                this.refreshLogTime(list);
                this.notifyFollowHandlers(list);
            }
        }
        catch (OutOfMemoryError error) {
            this.ipEventMaps.clear();
            this.logger.error((Object)"out of memory ,then I clear the  data", (Throwable)error);
        }
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        this.sumEvents(events);
        return new ArrayList();
    }
}

