/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AttackEventParserV2
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int ATTACK = 1;
    private static final long DEFAULT_BIZ_ID = 0L;

    private int parse(UnsignedDataInputStream stream, OriginalExceptionEvent event) throws IOException {
        int type = stream.readUnsignedByte();
        if (type < 10) {
            type = 0;
        }
        int protocol = 0;
        int port = 0;
        int state = stream.readUnsignedByte();
        int length = stream.readUnsignedShort();
        int ipCount = length / 4 - 6;
        if (type >= 10) {
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            stream.readUnsignedShort();
        } else {
            protocol = stream.readUnsignedByte();
            stream.readUnsignedByte();
            port = stream.readUnsignedShort();
        }
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            String deviceIp = event.getIdentifier().getDeviceIp();
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, deviceIp);
            LOGGER.info((Object)("AttackEventParserV2 deviceIp is: " + deviceIp + ";protocol is : " + EventUtil.getCustomProtocolStr(attackType.getProtocol()) + ";port is : " + port + ";bizId is : " + bizId));
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        event.setDropKbits(stream.readUnsignedInt());
        event.setDropPkgs(stream.readUnsignedInt());
        event.setRealValue(stream.readUnsignedInt());
        event.setNormalValue(stream.readUnsignedInt());
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        for (int i = 0; i < ipCount; ++i) {
            long ip = stream.readUnsignedInt();
            String ipStr = IpTransformer.long2StringFormat(ip);
            if (!IPUtil.isIpv4(ipStr)) continue;
            event.addAttacker(ipStr);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (type == 1) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    int abnormalType = this.parse((UnsignedDataInputStream)stream, event);
                    if (abnormalType != 3) continue;
                    event.setCurrentState(2);
                    long currentTimeMillis = event.getLogTime();
                    event.setAttackStartTime(currentTimeMillis);
                    event.setAttackEndTime(currentTimeMillis);
                    if (event.getIdentifier().getBizId() == 0L && !event.getIdentifier().isDesZone() && CollectorVersionRepository.getInstance().isNeedDrop()) continue;
                    suitEvent.addOriginalExceptionEvent(event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }
}

