/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AttackEventParserV3
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final long DEFAULT_BIZ_ID = 0L;
    private static final int ATTACK = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (type == 1) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    int abnormalType = this.parse((UnsignedDataInputStream)stream, event);
                    if (abnormalType == 3) {
                        event.setCurrentState(2);
                        long currentTimeMillis = event.getLogTime();
                        event.setAttackStartTime(currentTimeMillis);
                        event.setAttackEndTime(currentTimeMillis);
                        if (event.getIdentifier().getBizId() != 0L || event.getIdentifier().isDesZone() || !CollectorVersionRepository.getInstance().isNeedDrop()) {
                            suitEvent.addOriginalExceptionEvent(event);
                        }
                    }
                    if (abnormalType != 1) continue;
                    event.setCurrentState(1);
                    if (event.getIdentifier().getBizId() == 0L && !event.getIdentifier().isDesZone() && CollectorVersionRepository.getInstance().isNeedDrop()) continue;
                    suitEvent.addOriginalExceptionEvent(event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private int parse(UnsignedDataInputStream stream, OriginalExceptionEvent event) throws IOException {
        int type = stream.readUnsignedByte();
        int protocol = 0;
        int port = 0;
        int state = stream.readUnsignedByte();
        stream.readUnsignedShort();
        if (type >= 10) {
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            stream.readUnsignedShort();
            protocol = event.getIdentifier().getProtocol();
            port = event.getIdentifier().getPort();
        } else {
            protocol = stream.readUnsignedByte();
            stream.readUnsignedByte();
            port = stream.readUnsignedShort();
        }
        if (state == 1) {
            this.parseAlert(stream, event, type, protocol, port);
        }
        if (state == 3) {
            this.parseAttack(stream, event, type, protocol, port);
        }
        return state;
    }

    private void parseAlert(UnsignedDataInputStream stream, OriginalExceptionEvent event, int type, int protocol, int port) throws IOException {
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, event.getIdentifier().getDeviceIp());
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        long realKbps = stream.readUnsignedInt();
        stream.readUnsignedInt();
        long normalKbps = stream.readUnsignedInt();
        long normalPps = stream.readUnsignedInt();
        event.setRealValue(0L);
        event.setNormalValue(normalKbps > 0L ? normalKbps : normalPps);
        event.setPpsOrKbps(realKbps > 0L || normalKbps > 0L ? 1 : 0);
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedShort();
    }

    private void parseAttack(UnsignedDataInputStream stream, OriginalExceptionEvent event, int type, int protocol, int port) throws IOException {
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            String deviceIp = event.getIdentifier().getDeviceIp();
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, deviceIp);
            LOGGER.info((Object)("AttackEventParserV2 deviceIp is: " + deviceIp + ";protocol is : " + EventUtil.getCustomProtocolStr(attackType.getProtocol()) + ";port is : " + port + ";bizId is : " + bizId));
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        long realKbps = stream.readUnsignedInt();
        long realPps = stream.readUnsignedInt();
        long normalKbps = stream.readUnsignedInt();
        long normalPps = stream.readUnsignedInt();
        event.setDropKbits(realKbps);
        event.setDropPkgs(realPps);
        event.setNormalValue(normalKbps > 0L ? normalKbps : normalPps);
        event.setPpsOrKbps(realKbps > 0L || normalKbps > 0L ? 1 : 0);
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        stream.readShort();
        int sixHeadLogNum = stream.readShort();
        for (int size = 0; size < sixHeadLogNum; ++size) {
            int ucExtInfoType = stream.readUnsignedByte();
            stream.readUnsignedByte();
            int ucLength = stream.readUnsignedShort();
            if (ucExtInfoType == 0 || ucExtInfoType == 1) {
                long ipv4Count = stream.readUnsignedInt();
                int i = 0;
                while ((long)i < ipv4Count) {
                    long ip = stream.readUnsignedInt();
                    String ipStr = IpTransformer.long2StringFormat(ip);
                    if (IPUtil.isIpv4(ipStr)) {
                        event.addAttacker(ipStr);
                    }
                    ++i;
                }
                long ipv6Count = stream.readUnsignedInt();
                int i2 = 0;
                while ((long)i2 < ipv6Count) {
                    byte[] b = new byte[16];
                    if (stream.read(b) != 16) {
                        LOGGER.error((Object)"stream read error");
                    }
                    event.addAttacker(IpTransformer.byte2String(b, 6));
                    ++i2;
                }
                continue;
            }
            byte[] dnsByte = new byte[ucLength];
            if (stream.read(dnsByte) == ucLength) continue;
            LOGGER.error((Object)"stream read error");
        }
    }
}

