/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.AttackEventUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.SevenEventPaserUtil;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AttackEventParserV6
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final long DEFAULT_BIZ_ID = 0L;
    private static final int ATTACK = 1;
    private static final int ATTACK_TYPE_IP_LOCATION = 67;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (type == 1) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
                    int abnormalType = this.parse((UnsignedDataInputStream)stream, event, subAttackEventList);
                    if (event.getIdentifier().getBizId() != 0L || event.getIdentifier().isDesZone() || !CollectorVersionRepository.getInstance().isNeedDrop()) {
                        this.addOriginalExceptionEventToSuitEvent(suitEvent, event, subAttackEventList, abnormalType);
                        continue;
                    }
                    LOGGER.info((Object)("Drop a attack log by bidId=0 or isDesZone or isNeedDrop: " + event.toString()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void addOriginalExceptionEventToSuitEvent(IpSuitEvent suitEvent, OriginalExceptionEvent event, List<OriginalExceptionEvent> subAttackEventList, int abnormalType) {
        if (null == subAttackEventList || subAttackEventList.isEmpty()) {
            this.processAbnormalType(event, abnormalType);
            suitEvent.addOriginalExceptionEvent(event);
        } else {
            for (OriginalExceptionEvent subAttackEvent : subAttackEventList) {
                this.processAbnormalType(subAttackEvent, abnormalType);
                suitEvent.addOriginalExceptionEvent(subAttackEvent);
            }
        }
    }

    private void processAbnormalType(OriginalExceptionEvent event, int abnormalType) {
        if (abnormalType == 3) {
            event.setCurrentState(2);
            long currentTimeMillis = event.getLogTime();
            event.setAttackStartTime(currentTimeMillis);
            event.setAttackEndTime(currentTimeMillis);
        }
        if (abnormalType == 1) {
            event.setCurrentState(1);
        }
        if (abnormalType == 2) {
            event.setCurrentState(0);
        }
    }

    private int parse(UnsignedDataInputStream stream, OriginalExceptionEvent event, List<OriginalExceptionEvent> subAttackEventList) throws IOException {
        int type = stream.readUnsignedByte();
        int protocol = 0;
        int port = 0;
        int state = stream.readUnsignedByte();
        stream.readUnsignedShort();
        if (type >= 10) {
            stream.readUnsignedByte();
            event.setPpsOrKbps(stream.readUnsignedByte());
            stream.readUnsignedShort();
            protocol = event.getIdentifier().getProtocol();
            port = event.getIdentifier().getPort();
        } else {
            protocol = stream.readUnsignedByte();
            event.setPpsOrKbps(stream.readUnsignedByte());
            port = stream.readUnsignedShort();
        }
        if (state == 1 || state == 2) {
            int[] params = new int[]{type, protocol, port, state};
            subAttackEventList.addAll(this.parseAlert(stream, event, params));
        }
        if (state == 3) {
            subAttackEventList.addAll(this.parseAttack(stream, event, type, protocol, port));
        }
        return state;
    }

    private List<OriginalExceptionEvent> parseAlert(UnsignedDataInputStream stream, OriginalExceptionEvent event, int[] params) throws IOException {
        int type = params[0];
        int protocol = params[1];
        int port = params[2];
        int state = params[3];
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, event.getIdentifier().getDeviceIp());
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        long normalKbps = stream.readUnsignedLong();
        long normalPps = stream.readUnsignedLong();
        long currentKbps = stream.readUnsignedLong();
        long currentPps = stream.readUnsignedLong();
        if (event.isConnectionFlood()) {
            event.setNormalValue(normalKbps);
            event.setRealValue(currentKbps);
            event.setPpsOrKbps(3);
            event.setNormalValue1(normalPps);
            event.setRealValue1(currentPps);
            event.setPpsOrKbps1(4);
        } else if (27 == type) {
            event.setNormalValue(normalKbps);
            event.setRealValue(currentKbps);
            event.setPpsOrKbps(0);
            event.setNormalValue1(normalPps);
            event.setRealValue1(currentPps);
            event.setPpsOrKbps1(2);
        } else if (event.getPpsOrKbps() == 1) {
            event.setNormalValue(normalKbps);
            event.setRealValue(currentKbps);
        } else {
            event.setNormalValue(normalPps);
            event.setRealValue(currentPps);
        }
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        long expandLen = stream.readUnsignedShort();
        stream.readUnsignedInt();
        if (expandLen > 0L && stream.skip(expandLen) != expandLen) {
            LOGGER.error((Object)"stream read error");
        }
        List<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
        if (SevenEventPaserUtil.getInstance().needPaserSevenPacket(event)) {
            subAttackEventList = SevenEventPaserUtil.getInstance().processAbnormalOrEndSubAttackEvent(event, state);
        }
        return subAttackEventList;
    }

    private List<OriginalExceptionEvent> parseAttack(UnsignedDataInputStream stream, OriginalExceptionEvent event, int type, int protocol, int port) throws IOException {
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            String deviceIp = event.getIdentifier().getDeviceIp();
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, deviceIp);
            LOGGER.info((Object)("AttackEventParserV2 deviceIp is: " + deviceIp + ";protocol is : " + EventUtil.getCustomProtocolStr(attackType.getProtocol()) + ";port is : " + port + ";bizId is : " + bizId));
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        long dropKbps = stream.readUnsignedLong();
        long dropPps = stream.readUnsignedLong();
        long normalKbps = stream.readUnsignedLong();
        long normalPps = stream.readUnsignedLong();
        long currentKbps = stream.readUnsignedLong();
        long currentPps = stream.readUnsignedLong();
        event.setDropKbits(dropKbps);
        event.setDropPkgs(dropPps);
        if (event.isConnectionFlood()) {
            event.setNormalValue(normalKbps);
            event.setRealValue(currentKbps);
            event.setPpsOrKbps(3);
            event.setNormalValue1(normalPps);
            event.setRealValue1(currentPps);
            event.setPpsOrKbps1(4);
        } else if (27 == type) {
            event.setNormalValue(normalKbps);
            event.setRealValue(currentKbps);
            event.setPpsOrKbps(0);
            event.setNormalValue1(normalPps);
            event.setRealValue1(currentPps);
            event.setPpsOrKbps1(2);
        } else if (event.getPpsOrKbps() == 1) {
            event.setNormalValue(normalKbps);
            event.setRealValue(currentKbps);
        } else {
            event.setNormalValue(normalPps);
            event.setRealValue(currentPps);
        }
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        stream.readShort();
        ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
        int sixHeadLogNum = stream.readShort();
        stream.readUnsignedInt();
        for (int size = 0; size < sixHeadLogNum; ++size) {
            List<OriginalExceptionEvent> tempSubAttackEventList;
            long ipv6Count;
            int ucExtInfoType = stream.readUnsignedByte();
            int sevenHeadLogNum = stream.readUnsignedByte();
            int ucLength = stream.readUnsignedShort();
            if (ucExtInfoType == 0 || ucExtInfoType == 1) {
                List<OriginalExceptionEvent> tempSubAttackEventList2;
                long ipv4Count = stream.readUnsignedInt();
                int i = 0;
                while ((long)i < ipv4Count) {
                    long ip = stream.readUnsignedInt();
                    if (67 == attackType.getTypeValue()) {
                        event.addAttacker(String.valueOf(ip));
                    } else {
                        String ipStr = IpTransformer.long2StringFormat(ip);
                        if (IPUtil.isIpv4(ipStr)) {
                            event.addAttacker(ipStr);
                        }
                    }
                    ++i;
                }
                ipv6Count = stream.readUnsignedInt();
                int i2 = 0;
                while ((long)i2 < ipv6Count) {
                    byte[] b = new byte[16];
                    if (stream.read(b) != 16) {
                        LOGGER.error((Object)"stream read error");
                    }
                    event.addAttacker(IpTransformer.byte2String(b, 6));
                    ++i2;
                }
                if (!SevenEventPaserUtil.getInstance().needPaserSevenPacket(event) || (tempSubAttackEventList2 = SevenEventPaserUtil.getInstance().parseSevenPacket(stream, event, sevenHeadLogNum, true)).isEmpty()) continue;
                subAttackEventList.addAll(tempSubAttackEventList2);
                continue;
            }
            if (ucExtInfoType == 3 || ucExtInfoType == 4) {
                List<OriginalExceptionEvent> tempSubAttackEventList3;
                long ipv4Count = stream.readUnsignedInt();
                if (ipv4Count != 0L) {
                    AttackEventUtil.readIpv4AddrAndPort(stream, event, ipv4Count);
                }
                if ((ipv6Count = stream.readUnsignedInt()) != 0L) {
                    AttackEventUtil.readIpv6AddrAndPort(stream, event, ipv6Count);
                }
                if (!SevenEventPaserUtil.getInstance().needPaserSevenPacket(event) || (tempSubAttackEventList3 = SevenEventPaserUtil.getInstance().parseSevenPacket(stream, event, sevenHeadLogNum, true)).isEmpty()) continue;
                subAttackEventList.addAll(tempSubAttackEventList3);
                continue;
            }
            byte[] dnsByte = new byte[ucLength];
            if (stream.read(dnsByte) != ucLength) {
                LOGGER.debug((Object)"stream read error");
            }
            if (!SevenEventPaserUtil.getInstance().needPaserSevenPacket(event) || (tempSubAttackEventList = SevenEventPaserUtil.getInstance().parseSevenPacket(stream, event, sevenHeadLogNum, true)).isEmpty()) continue;
            subAttackEventList.addAll(tempSubAttackEventList);
        }
        return subAttackEventList;
    }
}

