/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.entity.event.BaseLineEvent;
import com.hs.atic.collector.entity.event.BaseLineNfaEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;

public class BaselineRepositoryHandlerThread<T extends Event>
extends EventHandler<T, T>
implements Runnable {
    private static final long SLEEPING_TIME = 5000L;
    private Repository<BaseLineEvent> repository;
    private Repository<BaseLineNfaEvent> nfaRepository;
    private List<BaseLineEvent> mainData = new ArrayList<BaseLineEvent>();
    private List<BaseLineEvent> detailData = new ArrayList<BaseLineEvent>();
    private List<BaseLineNfaEvent> nfaMainData = new ArrayList<BaseLineNfaEvent>();
    private List<BaseLineNfaEvent> nfaDetailData = new ArrayList<BaseLineNfaEvent>();

    public BaselineRepositoryHandlerThread() {
        super.setLogger(LogManager.getInstance().getDBLog());
        this.repository = RepositoryFactory.getInstance().getRepository(BaseLineEvent.class.getName());
        this.nfaRepository = RepositoryFactory.getInstance().getRepository(BaseLineNfaEvent.class.getName());
    }

    @Override
    protected synchronized List<T> handelEvents(List<T> events) {
        for (Event e : events) {
            if (e instanceof BaseLineNfaEvent) {
                if (e.isIsHourEvent()) {
                    this.nfaDetailData.add((BaseLineNfaEvent)e);
                    continue;
                }
                this.nfaMainData.add((BaseLineNfaEvent)e);
                continue;
            }
            if (e.isIsHourEvent()) {
                this.detailData.add((BaseLineEvent)e);
                continue;
            }
            this.mainData.add((BaseLineEvent)e);
        }
        return new ArrayList();
    }

    protected synchronized List<BaseLineEvent> getMainData() {
        List<BaseLineEvent> events = this.mainData;
        this.mainData = new ArrayList<BaseLineEvent>();
        return events;
    }

    protected synchronized List<BaseLineEvent> getDetailData() {
        List<BaseLineEvent> events = this.detailData;
        this.detailData = new ArrayList<BaseLineEvent>();
        return events;
    }

    protected synchronized List<BaseLineNfaEvent> getNfaMainData() {
        List<BaseLineNfaEvent> events = this.nfaMainData;
        this.nfaMainData = new ArrayList<BaseLineNfaEvent>();
        return events;
    }

    protected synchronized List<BaseLineNfaEvent> getNfaDetailData() {
        List<BaseLineNfaEvent> events = this.nfaDetailData;
        this.nfaDetailData = new ArrayList<BaseLineNfaEvent>();
        return events;
    }

    protected void saveData(List<BaseLineEvent> data) {
        ArrayList<BaseLineEvent> ulist = new ArrayList<BaseLineEvent>();
        ArrayList<BaseLineEvent> clist = new ArrayList<BaseLineEvent>();
        for (BaseLineEvent e : data) {
            if (e.isSaved()) {
                ulist.add(e);
                continue;
            }
            clist.add(e);
        }
        this.repository.createObjects(clist);
        this.repository.updateObjects(ulist);
    }

    protected void saveNfaData(List<BaseLineNfaEvent> data) {
        ArrayList<BaseLineNfaEvent> ulist = new ArrayList<BaseLineNfaEvent>();
        ArrayList<BaseLineNfaEvent> clist = new ArrayList<BaseLineNfaEvent>();
        for (BaseLineNfaEvent e : data) {
            if (e.isSaved()) {
                ulist.add(e);
                continue;
            }
            clist.add(e);
        }
        this.nfaRepository.createObjects(clist);
        this.nfaRepository.updateObjects(ulist);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.saveData(this.getMainData());
                    this.saveData(this.getDetailData());
                    this.saveNfaData(this.getNfaMainData());
                    this.saveNfaData(this.getNfaDetailData());
                    Thread.sleep(5000L);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"save baseline data error: ", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)"BaselineRepositoryHandlerThread InterruptedException error: ", (Throwable)e1);
                    continue;
                }
            }
            break;
        }
    }
}

