/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.BizAttackEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BizAttackLifeHandler
extends EventHandler<ChangeEvent<IpAttackEvent>, ChangeEvent<BizAttackEvent>> {
    private Map<Type, BizAttackEvent> bizAttackRecords = new HashMap<Type, BizAttackEvent>();

    public BizAttackLifeHandler() {
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    public Map<Type, BizAttackEvent> getBizAttackRecords() {
        return this.bizAttackRecords;
    }

    public void init(List<BizAttackEvent> events) {
        for (BizAttackEvent event : events) {
            BizType type = new BizType(event.getIdentifier());
            this.bizAttackRecords.put(type, event);
        }
        this.logger.info((Object)("init ok, cache data are " + this.bizAttackRecords));
    }

    public void setZoneAttackRecords(Map<Type, BizAttackEvent> bizAttack) {
        this.bizAttackRecords = bizAttack;
    }

    private List<ChangeEvent<BizAttackEvent>> updateBizAttackCache(Map<Type, List<IpAttackEvent>> eventsAfterMergeByBiz) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" before update zoneAttack  events :cache is  " + LogManager.NEXT_LINE + this.bizAttackRecords));
        }
        this.logger.info((Object)(" before update zoneAttack events ,size is " + this.bizAttackRecords.size()));
        ArrayList<ChangeEvent<BizAttackEvent>> changedEvents = new ArrayList<ChangeEvent<BizAttackEvent>>();
        for (Map.Entry<Type, List<IpAttackEvent>> entry : eventsAfterMergeByBiz.entrySet()) {
            Type type = entry.getKey();
            List<IpAttackEvent> values = entry.getValue();
            BizAttackEvent biz = this.getIpAttackEventByType(type, values.get(0).getIdentifierCopy());
            Event changeEvent = biz.sumElement((List)values);
            ChangeEvent<Event> changed = new ChangeEvent<Event>(biz, changeEvent);
            if (biz.isNormal()) {
                this.bizAttackRecords.remove(type);
            }
            changedEvents.add(changed);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" after update zoneAttack  events :cache is  " + LogManager.NEXT_LINE + this.bizAttackRecords));
        }
        this.logger.info((Object)(" after update zoneAttack events ,size is " + this.bizAttackRecords.size()));
        return changedEvents;
    }

    @Override
    protected List<ChangeEvent<BizAttackEvent>> handelEvents(List<ChangeEvent<IpAttackEvent>> events) {
        if (!events.isEmpty()) {
            ArrayList<IpAttackEvent> ipattacks = new ArrayList<IpAttackEvent>();
            for (ChangeEvent<IpAttackEvent> each : events) {
                ipattacks.add(each.getChange());
            }
            Map<Type, List<IpAttackEvent>> groups = EventUtil.groupEventsByBiz(ipattacks);
            return this.updateBizAttackCache(groups);
        }
        return new ArrayList<ChangeEvent<BizAttackEvent>>();
    }

    private BizAttackEvent getIpAttackEventByType(Type key, EventIdentifier identifier) {
        if (this.bizAttackRecords.containsKey(key)) {
            return this.bizAttackRecords.get(key);
        }
        BizAttackEvent event = new BizAttackEvent(identifier);
        this.bizAttackRecords.put(key, event);
        return event;
    }
}

