/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BlackListEventParserV3
implements EventDataParser {
    private static final int BLACK_TYPE = 5;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 5) {
            FilterInputStream stream = null;
            ZoneBlackListEvent black = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                ArrayList<ZoneBlackListEvent> events = new ArrayList<ZoneBlackListEvent>();
                for (int i = 0; i < number; ++i) {
                    black = new ZoneBlackListEvent(event.getIdentifier());
                    this.parse(black, (UnsignedDataInputStream)stream);
                    if (null == black.getBlackIp() || black.getBlackIp().isEmpty()) {
                        LOGGER.error((Object)"Drop a log for the black IP is null.");
                        LOGGER.info((Object)("Black event=" + black.toString()));
                        continue;
                    }
                    events.add(black);
                }
                event.setZoneBlackEvents(events);
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(ZoneBlackListEvent black, UnsignedDataInputStream stream) throws IOException {
        black.setBlackListType(stream.readUnsignedByte());
        int status = stream.readUnsignedByte();
        black.setStatus(status);
        if (status == 1) {
            black.setEnable(2);
            black.setBlackListMode(0);
        } else if (status == 3) {
            black.setEnable(1);
            black.setBlackListMode(1);
        } else if (status == 6) {
            black.setEnable(2);
            black.setBlackListMode(1);
        } else if (status == 5) {
            black.setInvalid(true);
        } else if (status == 7) {
            black.setInvalid(true);
        }
        stream.readUnsignedByte();
        black.setProtocol(stream.readUnsignedByte());
        black.setPort(stream.readUnsignedShort());
        stream.readUnsignedShort();
        byte[] address = new byte[16];
        if (stream.read(address) != 16) {
            LOGGER.error((Object)"stream read error");
        }
        int ipType = stream.readUnsignedByte();
        black.setBlackIp(IpTransformer.byte2String(address, ipType));
        stream.readUnsignedByte();
        stream.readUnsignedShort();
    }
}

