/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.ContentTopnEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ContentTopnEventParserV4
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int DNS_TOPN = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 9) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit) throws IOException {
        ContentTopnEvent contentTopnEvent = new ContentTopnEvent(suit.getIdentifier());
        this.readDnsTopnEvent(stream, contentTopnEvent);
        if (!contentTopnEvent.getDomianName().trim().equals("")) {
            suit.addDnsTopnEvent(contentTopnEvent);
        } else {
            LOGGER.info((Object)("I drop a DnsTopnEvent.Domian name is empty. " + contentTopnEvent));
        }
    }

    private void readDnsTopnEvent(UnsignedDataInputStream stream, ContentTopnEvent contentTopnEvent) throws IOException {
        stream.readUnsignedShort();
        stream.readUnsignedShort();
        contentTopnEvent.setRequestPps(stream.readUnsignedInt());
        contentTopnEvent.setRequsetKbps(stream.readUnsignedInt());
        contentTopnEvent.setTopnType(stream.readUnsignedByte());
        stream.readUnsignedByte();
        int dnsLen = stream.readUnsignedShort();
        contentTopnEvent.setDnsLen(dnsLen);
        contentTopnEvent.setRequestType(0);
        byte[] name = new byte[dnsLen];
        if (stream.read(name) != dnsLen) {
            LOGGER.error((Object)"stream read error");
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : name) {
            int s0 = b & 0xFF;
            Locale defloc = Locale.getDefault();
            if (s0 > 0 && s0 < 32) {
                String up = Integer.toHexString((b & 0xF0) >> 4).toUpperCase(defloc);
                String low = Integer.toHexString(b & 0xF).toUpperCase(defloc);
                sb.append("\\x" + up + low);
                continue;
            }
            sb.append((char)b);
        }
        contentTopnEvent.setDomianName(sb.toString());
    }
}

