/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AppFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeviceFlowEventHandler<T extends Event>
extends EventHandler<T, T> {
    public DeviceFlowEventHandler() {
        super.setLogger(LogManager.getInstance().getFlowLog());
    }

    public List<T> mergeByDevice(List<T> eventsAfterMergeByIp) {
        Map<Type, List<T>> devices = EventUtil.groupEventsByDeviceIp(eventsAfterMergeByIp);
        this.logger.info((Object)("group by device completed ,group size are " + devices.size()));
        ArrayList<Event> deviceEvents = new ArrayList<Event>();
        for (Map.Entry<Type, List<T>> entry : devices.entrySet()) {
            Event first;
            List<T> events = entry.getValue();
            if (events.isEmpty() || (first = (Event)events.get(0)) instanceof AppFlowEvent) continue;
            Event deviceEvent = first.getCopyEvent();
            EventIdentifier identifer = ((Event)events.get(0)).getIdentifierCopy();
            identifer.setDeviceType();
            deviceEvent.setIdentifer(identifer);
            deviceEvent.merge(events);
            deviceEvents.add(deviceEvent);
        }
        EventUtil.createEvents(deviceEvents);
        this.logger.info((Object)"merge by device complete ");
        return deviceEvents;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        if (!events.isEmpty()) {
            return this.mergeByDevice(events);
        }
        return new ArrayList();
    }
}

