/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DnsDefendEventHourHandler
extends EventHandler<DnsDefendEvent, DnsDefendEvent> {
    List<DnsDefendEvent> eventList = new ArrayList<DnsDefendEvent>();
    private long previousTime;

    public DnsDefendEventHourHandler() {
        this.refreshTime();
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.previousTime = calendar.getTimeInMillis();
    }

    protected void refreshLogTime(List<DnsDefendEvent> sums) {
        for (DnsDefendEvent t : sums) {
            t.setHourEvent(true);
            t.setLogTime(this.previousTime);
        }
    }

    @Override
    protected List<DnsDefendEvent> handelEvents(List<DnsDefendEvent> events) {
        this.sumEvents(events);
        if (System.currentTimeMillis() - this.previousTime >= 3600000L) {
            ArrayList<DnsDefendEvent> list = new ArrayList<DnsDefendEvent>();
            list.addAll(this.eventList);
            this.eventList.clear();
            this.refreshLogTime(list);
            this.refreshTime();
            EventUtil.createEvents(list);
        }
        return null;
    }

    private void sumEvents(List<DnsDefendEvent> events) {
        if (!events.isEmpty()) {
            for (DnsDefendEvent e : events) {
                if (this.eventList.contains(e)) {
                    this.eventList.get(this.eventList.indexOf(e)).mergeWithOutIp(e);
                    continue;
                }
                this.eventList.add(e);
            }
        }
    }

    public List<DnsDefendEvent> getEventList() {
        return this.eventList;
    }
}

