/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.SrcTopnEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DnsSrcTopnEventParserV2
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int DNS_SRC_TOPN = 8;
    private static final int SRC_TOPN_TYPE = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suit, int type, int number) throws IOException {
        if (type == 8) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, suit);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit) throws IOException {
        SrcTopnEvent dnsSrcTopnEvent = new SrcTopnEvent(suit.getIdentifier());
        this.readDnsSrcTopnEvent(stream, dnsSrcTopnEvent);
        if (IpTransformer.checkIpInvaild(dnsSrcTopnEvent.getSrcIp())) {
            suit.addDnsSrcTopnEvent(dnsSrcTopnEvent);
        } else {
            LOGGER.info((Object)("I drop a DnsSrcTopnEvent .src ip is 0. " + dnsSrcTopnEvent));
        }
    }

    private void readDnsSrcTopnEvent(UnsignedDataInputStream stream, SrcTopnEvent dnsSrcTopnEvent) throws IOException {
        dnsSrcTopnEvent.setSrcIp(IpTransformer.long2StringFormat(stream.readUnsignedInt()));
        stream.readUnsignedShort();
        stream.readUnsignedShort();
        dnsSrcTopnEvent.setRequestPps(stream.readUnsignedInt());
        dnsSrcTopnEvent.setRequestKbps(stream.readUnsignedInt());
        dnsSrcTopnEvent.setTopnType(7);
    }
}

