/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.DnsStatisEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DnsStatisEventParserV2
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int DNS_STATIS = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 7) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit) throws IOException {
        DnsStatisEvent dnsStatisEvent = new DnsStatisEvent(suit.getIdentifier());
        this.readDnsStatisEvent(stream, dnsStatisEvent);
        suit.addDnsStatisEvent(dnsStatisEvent);
    }

    private void readDnsStatisEvent(UnsignedDataInputStream stream, DnsStatisEvent dnsStatisEvent) throws IOException {
        stream.readUnsignedInt();
        dnsStatisEvent.setRequestPps(stream.readUnsignedInt());
        dnsStatisEvent.setRequestKbps(stream.readUnsignedInt());
        dnsStatisEvent.setReplyPps(stream.readUnsignedInt());
        dnsStatisEvent.setReplyKbps(stream.readUnsignedInt());
        dnsStatisEvent.setRequestThresholdPps(stream.readUnsignedInt());
        dnsStatisEvent.setRequsetThresholdKbps(stream.readUnsignedInt());
        dnsStatisEvent.setReplyThresholdPps(stream.readUnsignedInt());
        dnsStatisEvent.setReplyThresholdKbps(stream.readUnsignedInt());
        int dnsNameLen = stream.readUnsignedShort();
        stream.readUnsignedShort();
        dnsStatisEvent.setRequestType(0);
        byte[] dnsName = new byte[dnsNameLen];
        if (stream.read(dnsName) != dnsNameLen) {
            LOGGER.error((Object)"stream read error");
        }
        String name = new String(dnsName, "utf-8");
        dnsStatisEvent.setDnsName(name);
    }
}

