/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.NotifyDynamicBaseLineHanlder;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.condition.DynamicBaselineField;
import com.hs.atic.collector.entity.event.AppFlowEvent;
import com.hs.atic.collector.entity.event.DynamicBaseLineTask;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.log.DynamicBaseLineData;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class DynamicBaselineHandler<T extends Event>
extends EventHandler<T, T> {
    private static final Logger LOGGER = LogManager.getInstance().getHourTaskLog();
    private static DynamicBaselineHandler instance = new DynamicBaselineHandler();
    private long previousTime;
    private Map<Type, T> cache = new HashMap<Type, T>();
    private NotifyDynamicBaseLineHanlder notify = NotifyDynamicBaseLineHanlder.getInstance();
    private Map<Long, DynamicBaseLineTask> tasksIdMap = new HashMap<Long, DynamicBaseLineTask>();
    private Repository<DynamicBaseLineTask> repository;

    private DynamicBaselineHandler() {
        this.setRepository(RepositoryFactory.getInstance().getRepository(DynamicBaseLineTask.class.getName()));
        this.loadBaseLineFromDb();
        this.refreshTime();
    }

    public static DynamicBaselineHandler getInstance() {
        return instance;
    }

    public synchronized void addDynamicBaseLineTask(DynamicBaseLineTask task) {
        long taskId = task.getTaskId();
        if (!this.tasksIdMap.containsKey(taskId)) {
            this.tasksIdMap.put(taskId, task);
            this.saveBaseLineToDb(task);
            LOGGER.info((Object)("Add base line task,and Save it to DB :" + task));
        }
    }

    public synchronized List<T> filterEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event each : events) {
            AppFlowEvent app;
            Event copy;
            if (each instanceof InFlowEvent) {
                InFlowEvent in = (InFlowEvent)each;
                if (this.containsZoneId(this.tasksIdMap.values(), in.getZoneId())) {
                    copy = each.getCopyEvent();
                    copy.max(in);
                    result.add(copy);
                }
            }
            if (!(each instanceof AppFlowEvent) || (app = (AppFlowEvent)each).isCustomFlowEvent() || !this.containsZoneId(this.tasksIdMap.values(), app.getZoneId())) continue;
            copy = each.getCopyEvent();
            copy.max(app);
            result.add(copy);
        }
        if (!result.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("after filter ,events are " + result));
        }
        return result;
    }

    public synchronized void cancelDynamicBaseLineTask(long taskId) {
        if (this.tasksIdMap.containsKey(taskId)) {
            DynamicBaseLineTask taskInMap = this.tasksIdMap.get(taskId);
            taskInMap.setCancel(true);
            this.getRepository().updateObject(taskInMap);
            this.tasksIdMap.remove(taskId);
            LOGGER.info((Object)("This task is canceled " + taskInMap));
        }
    }

    public synchronized void deleteDynamicBaseLineTask(long taskId) {
        DynamicBaselineField field = new DynamicBaselineField("taskId");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(taskId);
        clause.addValueList(clause.getValue());
        this.getRepository().deleteObject(clause);
        DynamicBaseLineTask task = this.tasksIdMap.get(taskId);
        this.tasksIdMap.remove(taskId);
        LOGGER.info((Object)("Delete base line task:" + task));
    }

    private void doHourCheckAndNotify() {
        if (System.currentTimeMillis() - this.previousTime >= 3600000L) {
            ArrayList<T> sums = new ArrayList<T>();
            sums.addAll(this.cache.values());
            this.cache.clear();
            ArrayList<DynamicBaseLineTask> tasks = new ArrayList<DynamicBaseLineTask>();
            for (DynamicBaseLineTask task : this.tasksIdMap.values()) {
                if (!task.isShowTime()) continue;
                tasks.add(task);
            }
            this.createDynamicDataAndNotify(sums, tasks);
            this.refreshTime();
        }
    }

    private void createDynamicDataAndNotify(List<T> sums, Collection<DynamicBaseLineTask> tasks) {
        Map<Type, List<T>> events = EventUtil.groupEventsByZone(sums, true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("the events to be  statistics are" + events));
        }
        List<DynamicBaseLineData> dynamicDataList = this.createDynamicData(events);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("There are dynamicDatas " + dynamicDataList));
        }
        List<DynamicBaseLineData> hourData = this.updateTask(dynamicDataList, tasks);
        this.notify.notifyDynamicBaseLineData(hourData);
    }

    @Override
    protected synchronized List<T> handelEvents(List<T> events) {
        this.filterAttackEvents(events);
        for (Event t : events) {
            ZoneType type = new ZoneType(t);
            if (this.cache.containsKey(type)) {
                ((Event)this.cache.get(type)).max(t);
                continue;
            }
            Event max = t.getCopyEvent();
            max.max(t);
            this.cache.put(type, max);
        }
        this.doCompletedTaskCheckAndNotify();
        this.doHourCheckAndNotify();
        return null;
    }

    private void filterAttackEvents(List<T> events) {
        Iterator<T> itor = events.iterator();
        while (itor.hasNext()) {
            AppFlowEvent app;
            Event event = (Event)itor.next();
            if (!(event instanceof AppFlowEvent) || !(app = (AppFlowEvent)event).isIsAttack()) continue;
            itor.remove();
        }
    }

    private void doCompletedTaskCheckAndNotify() {
        List<DynamicBaseLineTask> tasks = this.getCompletedTask();
        if (!tasks.isEmpty()) {
            ArrayList<Event> events = new ArrayList<Event>();
            Iterator<Map.Entry<Type, T>> itor = this.cache.entrySet().iterator();
            while (itor.hasNext()) {
                Event event = (Event)itor.next().getValue();
                long zoneId = event.getZoneId();
                for (DynamicBaseLineTask task : tasks) {
                    if (task.getZoneId() != zoneId) continue;
                    events.add(event);
                    itor.remove();
                }
            }
            this.createDynamicDataAndNotify(events, tasks);
        }
    }

    private List<DynamicBaseLineTask> getCompletedTask() {
        ArrayList<DynamicBaseLineTask> completedTasks = new ArrayList<DynamicBaseLineTask>();
        Iterator<Map.Entry<Long, DynamicBaseLineTask>> itor = this.tasksIdMap.entrySet().iterator();
        while (itor.hasNext()) {
            DynamicBaseLineTask task = itor.next().getValue();
            if (!task.isCompleted()) continue;
            completedTasks.add(task);
            LOGGER.info((Object)("this task is completed " + task));
            itor.remove();
        }
        return completedTasks;
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.previousTime = calendar.getTimeInMillis();
    }

    private void addAppFlowEvent(AppFlowEvent app, DynamicBaseLineData dynamic) {
        dynamic.setZoneId(app.getZoneId());
        long value = app.getInPps();
        switch (app.getSubType()) {
            case 1: {
                dynamic.setHttps(value);
                break;
            }
            case 2: {
                dynamic.setHttpGet(value);
                break;
            }
            case 3: {
                dynamic.setHttpPost(value);
                break;
            }
            case 4: {
                dynamic.setDnsQuery(value);
                break;
            }
            case 5: {
                dynamic.setDnsReply(value);
                break;
            }
            case 6: {
                dynamic.setSipInvite(value);
                break;
            }
        }
    }

    public boolean containsZoneId(Collection<DynamicBaseLineTask> tasks, long zoneId) {
        for (DynamicBaseLineTask task : tasks) {
            if (task.getZoneId() != zoneId || !task.isShowTime()) continue;
            return true;
        }
        return false;
    }

    private List<DynamicBaseLineData> createDynamicData(Map<Type, List<T>> events) {
        ArrayList<DynamicBaseLineData> dynamicList = new ArrayList<DynamicBaseLineData>();
        for (Map.Entry<Type, List<T>> entry : events.entrySet()) {
            List<T> group = entry.getValue();
            DynamicBaseLineData dynamic = new DynamicBaseLineData();
            for (Event t : group) {
                if (t instanceof InFlowEvent) {
                    this.setInFlowEvent((InFlowEvent)t, dynamic);
                    continue;
                }
                this.addAppFlowEvent((AppFlowEvent)t, dynamic);
            }
            dynamicList.add(dynamic);
        }
        return dynamicList;
    }

    private DynamicBaseLineTask getCurrentDynaBaseLineTask(long zoneId, Collection<DynamicBaseLineTask> tasks) {
        for (DynamicBaseLineTask task : tasks) {
            if (task.getZoneId() != zoneId) continue;
            return task;
        }
        return null;
    }

    private void loadBaseLineFromDb() {
        DynamicBaselineField field = new DynamicBaselineField("isCancel");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().notEqual();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(0);
        clause.addValueList(clause.getValue());
        List<DynamicBaseLineTask> baseLineTasks = this.getRepository().queryObject(clause);
        for (DynamicBaseLineTask baseLineTask : baseLineTasks) {
            this.tasksIdMap.put(baseLineTask.getTaskId(), baseLineTask);
        }
        LOGGER.info((Object)("Load dynamic task form db" + this.tasksIdMap));
    }

    private void saveBaseLineToDb(DynamicBaseLineTask task) {
        if (null != this.getRepository()) {
            if (task.isIsSaved()) {
                this.getRepository().updateObject(task);
            } else {
                this.getRepository().createObject(task);
                task.setSaved(true);
            }
        }
    }

    private void setInFlowEvent(InFlowEvent in, DynamicBaseLineData dynamic) {
        dynamic.setTcpFragMpps(in.getTcpFragPps());
        long udpFragMbps = in.getUdpFragKbps() / 1024L;
        if (in.getUdpFragKbps() % 1024L > 0L) {
            ++udpFragMbps;
        }
        dynamic.setUdpFragKbps(udpFragMbps);
        long udpMbps = in.getUdpKbps() / 1024L;
        if (in.getUdpKbps() % 1024L > 0L) {
            ++udpMbps;
        }
        dynamic.setUdpMbps(udpMbps);
        dynamic.setIcmpPps(in.getIcmpPps());
        dynamic.setOtherPps(in.getOtherPps());
        dynamic.setSynPps(in.getSynPps());
        dynamic.setSynAckPps(in.getSynAckPps());
        dynamic.setFinRstPps(in.getFinRstPps());
        dynamic.setAckPps(in.getAckPps());
        dynamic.setDstUrl(in.getUrl());
        dynamic.setCurrentConnections(in.getTcpConcurCon());
        dynamic.setIncreaseRate(in.getIncreaseRate());
        dynamic.setZoneId(in.getZoneId());
    }

    private List<DynamicBaseLineData> updateTask(List<DynamicBaseLineData> dynamicData, Collection<DynamicBaseLineTask> tasks) {
        ArrayList<DynamicBaseLineData> hourData = new ArrayList<DynamicBaseLineData>();
        Iterator<DynamicBaseLineData> itor = dynamicData.iterator();
        while (itor.hasNext()) {
            DynamicBaseLineData data = itor.next();
            long zoneId = data.getZoneId();
            DynamicBaseLineTask task = this.getCurrentDynaBaseLineTask(zoneId, tasks);
            if (task == null) {
                LOGGER.info((Object)("this task has been deleted " + data));
                itor.remove();
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("before update , task is " + task));
            }
            hourData.add(task.getMaxValue(data));
            this.saveBaseLineToDb(task);
            LOGGER.debug((Object)("after update , task is " + task));
        }
        return hourData;
    }

    public Repository<DynamicBaseLineTask> getRepository() {
        return this.repository;
    }

    public void setRepository(Repository<DynamicBaseLineTask> repository) {
        this.repository = repository;
    }
}

