/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.DevDontWorkBuffer;
import com.hs.atic.collector.biz.PacketParser;
import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.EventPacketParserFactory;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.entity.DefaultBizMappingEntity;
import com.hs.atic.collector.entity.DevFlagEntity;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.SecondFlowEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpLocationUitl;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EventPacketParser
implements PacketParser<Event> {
    private static final long DEFAULT_ZONE_ID = 1L;
    private static final long DEFAULT_BIZ_ID = 0L;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int SECOND_HEAD_ZONE = 9;
    private static final int SECOND_HEAD_FIREWALL = 10;
    private static final int SECOND_HEAD_LOCATION = 11;
    private static final int SECOND_HEAD_ZONE_SUM = 12;
    private static final int SECOND_HEAD_OUTBOUND = 13;
    private static final int SECOND_HEAD_OUTBOUND_ZONESUM = 14;
    private static final int SECOND_HEAD_DEV_SUM = 15;
    private static final int SECOND_HEAD_OUTBOND_DEVSUM = 16;
    private static final int BIZ = 4;
    private static final int DOMAIN = 5;
    private static final int TOPN = 6;
    private static long secondFlowNum = 0L;
    int version;
    private int cpu;
    private int slot;
    private int deviceType;
    private String deviceIp;
    private long logTime;
    private boolean flowOverLevel;
    private boolean flowOverThreshold;
    private boolean abnormalOverLevel;
    private boolean abnormalOverThreshold;
    private boolean bizOverThreshold;
    private boolean zoneBlackListOverLevel;
    private boolean zoneBlackListOverThreshold;
    private boolean srcAndContentOverLevel;
    private boolean srcAndContentOverThreshold;

    public static synchronized void addSecondFlowNum() {
        ++secondFlowNum;
    }

    public static synchronized long getSecondFlowNum() {
        return secondFlowNum;
    }

    public void setFlowOverThreshold(boolean flowOverThreshold) {
        this.flowOverThreshold = flowOverThreshold;
    }

    public void setAbnormalOverThreshold(boolean abnormalOverThreshold) {
        this.abnormalOverThreshold = abnormalOverThreshold;
    }

    public void setBizOverThreshold(boolean bizOverThreshold) {
        this.bizOverThreshold = bizOverThreshold;
    }

    public void setZoneBlackListOverThreshold(boolean zoneBlackListOverThreshold) {
        this.zoneBlackListOverThreshold = zoneBlackListOverThreshold;
    }

    public void setSrcAndContentOverThreshold(boolean srcAndContentOverThreshold) {
        this.srcAndContentOverThreshold = srcAndContentOverThreshold;
    }

    public boolean isFlowOverLevel() {
        return this.flowOverLevel;
    }

    public void setFlowOverLevel(boolean flowOverLevel) {
        this.flowOverLevel = flowOverLevel;
    }

    public boolean isAbnormalOverLevel() {
        return this.abnormalOverLevel;
    }

    public void setAbnormalOverLevel(boolean abnormalOverLevel) {
        this.abnormalOverLevel = abnormalOverLevel;
    }

    public boolean isZoneBlackListOverLevel() {
        return this.zoneBlackListOverLevel;
    }

    public void setZoneBlackListOverLevel(boolean zoneBlackListOverLevel) {
        this.zoneBlackListOverLevel = zoneBlackListOverLevel;
    }

    public boolean isSrcAndContentOverLevel() {
        return this.srcAndContentOverLevel;
    }

    public void setSrcAndContentOverLevel(boolean srcAndContentOverLevel) {
        this.srcAndContentOverLevel = srcAndContentOverLevel;
    }

    public boolean isOverThreshold(int type) {
        boolean value = false;
        switch (type) {
            case 0: {
                if (this.flowOverThreshold || this.flowOverLevel) {
                    value = true;
                }
                return value;
            }
            case 1: 
            case 4: {
                if (this.abnormalOverThreshold || this.abnormalOverLevel) {
                    value = true;
                }
                return value;
            }
            case 6: {
                return this.bizOverThreshold;
            }
            case 5: {
                if (this.zoneBlackListOverThreshold || this.zoneBlackListOverLevel) {
                    value = true;
                }
                return value;
            }
            case 7: 
            case 8: 
            case 9: {
                if (this.srcAndContentOverThreshold || this.srcAndContentOverLevel) {
                    value = true;
                }
                return value;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Event> parsePacket(TimeDatagramPacket packet) {
        HashMap<EventIdentifier, IpSuitEvent> result = new HashMap<EventIdentifier, IpSuitEvent>();
        byte[] allData = packet.getData();
        this.deviceIp = IpTransformer.formatIpAddress(packet.getAddress());
        this.logTime = packet.getTime();
        UnsignedDataInputStream stream = new UnsignedDataInputStream(new ByteArrayInputStream(allData));
        try {
            this.version = stream.readUnsignedByte();
            List<EventDataParser> typeParses = EventPacketParserFactory.getInstance().getEventDataParsers(this.version);
            this.slot = stream.readUnsignedByte();
            this.cpu = this.slot << 8 | stream.readUnsignedByte();
            this.deviceType = stream.readUnsignedByte();
            this.handleDevWorkTime();
            stream.readUnsignedShort();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("this packet from deviceIp=" + this.deviceIp + ", data is " + CommonUtil.getByteArrayStr(allData)));
            }
            int number = stream.readUnsignedShort();
            for (int i = 0; i < number; ++i) {
                if (1 == this.version || 2 == this.version) {
                    this.parseEventV1V2(stream, result, typeParses);
                    continue;
                }
                this.parseEventV3(stream, result, typeParses);
            }
            Collection<Event> entity = this.collectEvents(result);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(entity);
            } else {
                for (Event event : entity) {
                    if (!(event instanceof SecondFlowEvent)) continue;
                    EventPacketParser.addSecondFlowNum();
                    LOGGER.info((Object)("received second flow event number: " + EventPacketParser.getSecondFlowNum() + ". event=" + event));
                }
            }
            Collection<Event> collection = entity;
            return collection;
        }
        catch (Exception e) {
            LOGGER.error((Object)("when parse packet ,error happens and packet from deviceIp=" + this.deviceIp + " is  " + CommonUtil.getByteArrayStr(allData)), (Throwable)e);
            ArrayList<Event> arrayList = new ArrayList<Event>();
            return arrayList;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    private void parseEventV3(UnsignedDataInputStream stream, Map<EventIdentifier, IpSuitEvent> result, List<EventDataParser> typeParsers) throws IOException {
        long zoneId = stream.readUnsignedInt();
        byte[] b = new byte[16];
        if (stream.read(b) != 16) {
            LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
        }
        int ucZoneIpType = stream.readUnsignedByte();
        String zoneIp = IpTransformer.byte2String(b, ucZoneIpType);
        int ucProto = stream.readUnsignedByte();
        int usPort = stream.readUnsignedShort();
        int type = stream.readUnsignedByte();
        stream.readUnsignedByte();
        int vpnIndex = stream.readUnsignedShort();
        long temp = stream.readUnsignedInt();
        stream.readUnsignedByte();
        int logTypeNumber = stream.readUnsignedByte();
        long length = stream.readUnsignedShort();
        long bizId = -1L;
        if (type == 4 || type == 5 || type == 6) {
            bizId = temp;
        } else if (9 == type && 0L != temp || 11 == type) {
            bizId = temp;
        } else {
            if (9 == type && 0L == temp) {
                if (stream.skip(length) != length) {
                    LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
                }
                LOGGER.error((Object)("I drop a wangduan flow log, return. deviceIp=" + this.deviceIp));
                return;
            }
            bizId = 0L;
        }
        EventIdentifier identifer = new EventIdentifier();
        if (bizId == 0L) {
            identifer.setIsDefaultBiz(true);
        } else {
            identifer.setIsDefaultBiz(false);
        }
        int direction = 1;
        if (13 == type || 16 == type) {
            direction = 2;
        }
        if (type != 10 && 15 != type && 16 != type) {
            zoneId = zoneId <= 0L ? 1L : zoneId;
            if (1L == (zoneId = this.getDefaultZoneId(zoneId)) && CollectorVersionRepository.getInstance().isNeedDrop()) {
                if (stream.skip(length) != length) {
                    LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
                }
                LOGGER.error((Object)("i drop a packet for get default zone id error!, ATIC has not defalut zone of deviceIp=" + this.deviceIp));
                return;
            }
        }
        boolean isZoneSumEvent = false;
        boolean isDevSumEvent = false;
        if (10 == type) {
            zoneIp = "";
            zoneId = 0L;
        } else if (9 == type) {
            zoneIp = "";
            identifer.setIpLocation(true);
            identifer.setIpLocationId(IpLocationUitl.getInstance().getLocationCustomId(bizId, this.deviceIp));
        } else if (11 == type) {
            zoneIp = "";
            identifer.setIpLocation(true);
            identifer.setIpLocationId(IpLocationUitl.getInstance().getLocationCustomId(bizId, this.deviceIp));
        } else if (12 == type) {
            isZoneSumEvent = true;
        } else if (14 == type) {
            direction = 2;
            isZoneSumEvent = true;
        } else if (15 == type || 16 == type) {
            isDevSumEvent = true;
        } else if (0L == (bizId = this.getDefBizId(zoneId, bizId, direction)) && CollectorVersionRepository.getInstance().isNeedDrop()) {
            if (stream.skip(length) != length) {
                LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
            }
            LOGGER.error((Object)("i drop a packet for get biz id error, the atic has no zone of zoneId=" + zoneId + ", deviceIp=" + this.deviceIp));
            return;
        }
        identifer.setCpu(this.cpu);
        identifer.setZoneId(zoneId);
        identifer.setZoneIp(zoneIp);
        identifer.setDeviceIp(this.deviceIp);
        identifer.setDeviceType(this.deviceType);
        identifer.setLogTime(this.logTime);
        if (isZoneSumEvent) {
            identifer.setZoneType();
        } else if (isDevSumEvent) {
            identifer.setDeviceType();
        } else {
            identifer.setZoneIpType();
        }
        identifer.setBizId(bizId);
        identifer.setProtocol(ucProto);
        identifer.setPort(usPort);
        identifer.setVpnIndex(vpnIndex);
        identifer.setSlotId(this.slot);
        identifer.setDirection(direction);
        IpSuitEvent ipEvent = this.getIpSuitEntity(result, identifer);
        this.parseEventsOfSameIp(stream, typeParsers, logTypeNumber, ipEvent);
    }

    private void handleDevWorkTime() {
        if (this.deviceType == 1) {
            DevFlagEntity devFlag = new DevFlagEntity(this.deviceIp, this.deviceType);
            devFlag.setStopWorkTime(this.logTime / 1000L);
            devFlag.setStartWorkTime(this.logTime / 1000L);
            DevDontWorkBuffer.getInstance().refresh(devFlag);
        }
    }

    private Collection<Event> collectEvents(Map<EventIdentifier, IpSuitEvent> result) {
        ArrayList<Event> entitys = new ArrayList<Event>();
        for (IpSuitEvent suit : result.values()) {
            entitys.addAll(suit.getEntitys());
        }
        return entitys;
    }

    private IpSuitEvent getIpSuitEntity(Map<EventIdentifier, IpSuitEvent> result, EventIdentifier identifier) {
        IpSuitEvent event = result.get(identifier);
        if (null == event) {
            event = new IpSuitEvent(identifier);
            result.put(identifier, event);
        }
        return event;
    }

    private void parseEventV1V2(UnsignedDataInputStream stream, Map<EventIdentifier, IpSuitEvent> result, List<EventDataParser> typeParsers) throws IOException {
        long zoneId = stream.readUnsignedInt();
        if (zoneId <= 0L) {
            zoneId = 1L;
        }
        if (1L == (zoneId = this.getDefaultZoneId(zoneId)) && CollectorVersionRepository.getInstance().isNeedDrop()) {
            long length;
            if (stream.skip(10L) != 10L) {
                LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
            }
            if (stream.skip(length = (long)stream.readUnsignedShort()) != length) {
                LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
            }
            LOGGER.error((Object)("i drop a packet for get zone id error!, deviceIp=" + this.deviceIp));
            return;
        }
        long zoneIp = stream.readUnsignedInt();
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedShort();
        stream.readUnsignedByte();
        int logTypeNumber = stream.readUnsignedByte();
        long length = stream.readUnsignedShort();
        long bizId = 0L;
        bizId = this.getDefBizId(zoneId, bizId, 1);
        if (0L == bizId && CollectorVersionRepository.getInstance().isNeedDrop()) {
            if (stream.skip(length) != length) {
                LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
            }
            LOGGER.warn((Object)"i drop a packet for get biz id error!");
            return;
        }
        EventIdentifier identifer = new EventIdentifier();
        identifer.setCpu(this.cpu);
        identifer.setZoneId(zoneId);
        identifer.setZoneIp(IpTransformer.long2StringFormat(zoneIp));
        identifer.setDeviceIp(this.deviceIp);
        identifer.setDeviceType(this.deviceType);
        identifer.setLogTime(this.logTime);
        identifer.setCpuType();
        identifer.setBizId(bizId);
        identifer.setVersion(this.version);
        identifer.setSlotId(this.slot);
        IpSuitEvent ipEvent = this.getIpSuitEntity(result, identifer);
        this.parseEventsOfSameIp(stream, typeParsers, logTypeNumber, ipEvent);
    }

    private long getDefBizId(long zoneId, long bizId, int direction) {
        if (bizId == 0L) {
            try {
                bizId = FoundIDUtil.getInstance().getBizIDByDevIP(new DefaultBizMappingEntity(this.deviceIp, zoneId, direction));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("deviceIp is : " + this.deviceIp + ";zoneId is:" + zoneId + ";default biz id is:" + bizId));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"get default biz id error", (Throwable)e);
            }
        }
        return bizId;
    }

    private long getDefaultZoneId(long zoneId) {
        if (zoneId == 1L) {
            try {
                zoneId = FoundIDUtil.getInstance().getDefaultZoneIdByDevIp(this.deviceIp);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("deviceIp: " + this.deviceIp + ".mapping default zone id is : " + zoneId));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"get default zone id error", (Throwable)e);
            }
        }
        return zoneId;
    }

    private void parseEventsOfSameIp(UnsignedDataInputStream stream, List<EventDataParser> typeParsers, int logTypeNumber, IpSuitEvent ipEvent) throws IOException {
        for (int i = 0; i < logTypeNumber; ++i) {
            int type = stream.readUnsignedByte();
            int numberOfSameType = stream.readUnsignedByte();
            int lengthOfSameType = stream.readUnsignedShort();
            if (this.isOverThreshold(type)) {
                LOGGER.error((Object)("drop " + numberOfSameType + " events for over threshold,type is " + type));
                if (stream.skip(lengthOfSameType) == (long)lengthOfSameType) continue;
                LOGGER.debug((Object)("stream read error, deviceIp=" + this.deviceIp));
                continue;
            }
            byte[] logContent = new byte[lengthOfSameType];
            if (-1 == stream.read(logContent)) continue;
            for (EventDataParser parser : typeParsers) {
                parser.parseData(logContent, ipEvent, type, numberOfSameType);
            }
        }
    }
}

