/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.biz.event.nfa.NfaParserAttackSrcEventV1;
import com.hs.atic.collector.biz.event.nfa.NfaParserAttackSrcEventV2;
import com.hs.atic.collector.biz.event.nfa.NfaParserExceptionEventV1;
import com.hs.atic.collector.biz.event.nfa.NfaParserFlowEventV1;
import com.hs.atic.collector.biz.event.process.AttackEventParser;
import com.hs.atic.collector.biz.event.process.AttackEventParserV2;
import com.hs.atic.collector.biz.event.process.AttackEventParserV3;
import com.hs.atic.collector.biz.event.process.AttackEventParserV4;
import com.hs.atic.collector.biz.event.process.AttackEventParserV5;
import com.hs.atic.collector.biz.event.process.AttackEventParserV6;
import com.hs.atic.collector.biz.event.process.AttackEventParserV7;
import com.hs.atic.collector.biz.event.process.BizEventParserV3;
import com.hs.atic.collector.biz.event.process.BlackListEventParser;
import com.hs.atic.collector.biz.event.process.BlackListEventParserV3;
import com.hs.atic.collector.biz.event.process.CarEventParser;
import com.hs.atic.collector.biz.event.process.ContentTopnEventParserV4;
import com.hs.atic.collector.biz.event.process.DnsDefendParserV3;
import com.hs.atic.collector.biz.event.process.DnsSrcTopnEventParserV2;
import com.hs.atic.collector.biz.event.process.DnsSrcTopnEventParserV3;
import com.hs.atic.collector.biz.event.process.DnsStatisEventParserV2;
import com.hs.atic.collector.biz.event.process.DnsTopnEventParserV2;
import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.ExceptionEventParser;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV2;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV3;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV4;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV5;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV6;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV7;
import com.hs.atic.collector.biz.event.process.FlowEventParser;
import com.hs.atic.collector.biz.event.process.FlowEventParserV2;
import com.hs.atic.collector.biz.event.process.FlowEventParserV3;
import com.hs.atic.collector.biz.event.process.FlowEventParserV4;
import com.hs.atic.collector.biz.event.process.FlowEventParserV5;
import com.hs.atic.collector.biz.event.process.FlowEventParserV6;
import com.hs.atic.collector.biz.event.process.FlowEventParserV7;
import com.hs.atic.collector.biz.event.process.SecondFlowParserV1;
import com.hs.atic.collector.biz.event.process.SrcTopnEventParserV4;
import com.hs.atic.collector.biz.event.process.StaticFingerParserV3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventPacketParserFactory {
    private static EventPacketParserFactory instance = new EventPacketParserFactory();
    private static Map<Integer, List<EventDataParser>> cache = new HashMap<Integer, List<EventDataParser>>();
    private static Map<Integer, List<NfaEventDataParser>> nfaCache = new HashMap<Integer, List<NfaEventDataParser>>();

    public static EventPacketParserFactory getInstance() {
        return instance;
    }

    public List<EventDataParser> getEventDataParsers(int version) {
        if (cache.containsKey(version)) {
            return cache.get(version);
        }
        ArrayList<EventDataParser> dataParsers = new ArrayList<EventDataParser>();
        if (1 == version) {
            dataParsers.add(new FlowEventParser());
            dataParsers.add(new CarEventParser());
            dataParsers.add(new ExceptionEventParser());
            dataParsers.add(new AttackEventParser());
            cache.put(version, dataParsers);
        } else if (2 == version) {
            dataParsers.add(new FlowEventParserV2());
            dataParsers.add(new CarEventParser());
            dataParsers.add(new ExceptionEventParserV2());
            dataParsers.add(new AttackEventParserV2());
            dataParsers.add(new BlackListEventParser());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new DnsSrcTopnEventParserV2());
            dataParsers.add(new DnsTopnEventParserV2());
            cache.put(version, dataParsers);
        } else if (3 == version) {
            dataParsers.add(new FlowEventParserV3());
            dataParsers.add(new ExceptionEventParserV3());
            dataParsers.add(new AttackEventParserV3());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new DnsSrcTopnEventParserV3());
            dataParsers.add(new DnsTopnEventParserV2());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            cache.put(version, dataParsers);
        } else if (4 == version) {
            dataParsers.add(new FlowEventParserV4());
            dataParsers.add(new ExceptionEventParserV4());
            dataParsers.add(new AttackEventParserV4());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            cache.put(version, dataParsers);
        } else if (5 == version) {
            dataParsers.add(new FlowEventParserV5());
            dataParsers.add(new ExceptionEventParserV5());
            dataParsers.add(new AttackEventParserV5());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            cache.put(version, dataParsers);
        } else if (6 == version) {
            dataParsers.add(new FlowEventParserV6());
            dataParsers.add(new ExceptionEventParserV6());
            dataParsers.add(new AttackEventParserV6());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            dataParsers.add(new SecondFlowParserV1());
            cache.put(version, dataParsers);
        } else if (7 == version) {
            dataParsers.add(new FlowEventParserV7());
            dataParsers.add(new ExceptionEventParserV7());
            dataParsers.add(new AttackEventParserV7());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            dataParsers.add(new SecondFlowParserV1());
            cache.put(version, dataParsers);
        }
        return dataParsers;
    }

    public List<NfaEventDataParser> getNfaEventParsers(int version) {
        if (nfaCache.containsKey(version)) {
            return nfaCache.get(version);
        }
        ArrayList<NfaEventDataParser> parserList = new ArrayList<NfaEventDataParser>();
        if (1 == version) {
            parserList.add(new NfaParserFlowEventV1());
            parserList.add(new NfaParserExceptionEventV1());
            parserList.add(new NfaParserAttackSrcEventV1());
            nfaCache.put(version, parserList);
        }
        if (2 == version) {
            parserList.add(new NfaParserFlowEventV1());
            parserList.add(new NfaParserExceptionEventV1());
            parserList.add(new NfaParserAttackSrcEventV2());
            nfaCache.put(version, parserList);
        }
        return parserList;
    }
}

