/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.PacketTypeFilter;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.biz.pcap.AESDecryptorFactory;
import com.hs.atic.collector.entity.Collector;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.HmacUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class EventTypeProcessor {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private Buffer<TimeDatagramPacket> buffer;
    private PacketTypeFilter filter;
    private boolean needDecrypt;

    public Buffer<TimeDatagramPacket> getBuffer() {
        return this.buffer;
    }

    public PacketTypeFilter getFilter() {
        return this.filter;
    }

    public void processPacket(DatagramPacket packet) {
        String logIp = packet.getAddress().getHostAddress();
        DeviceObj deviceObj = Collector.getInstance().getDeviceByIp(logIp);
        if (null == deviceObj) {
            LOGGER.error((Object)("Drop 1 packet from not manage device:" + packet.getAddress()));
            return;
        }
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, data, 0, data.length);
        int encryptType = deviceObj.getEncryptType();
        if (0 == encryptType && this.needDecrypt) {
            LOGGER.debug((Object)("Old device log\uff0c before decrypt: " + CommonUtil.getByteArrayStr(data)));
            data = AESDecryptorFactory.getInstance().decrypt(data, logIp);
        } else if (1 == encryptType) {
            LOGGER.debug((Object)("New device log\uff0c recevied all data: " + CommonUtil.getByteArrayStr(data)));
            data = this.checkMacAndDecrypt(logIp, data);
        } else {
            LOGGER.debug((Object)("log not need encrypt, form " + logIp));
        }
        if (null == data || 0 == data.length) {
            LOGGER.error((Object)("drop a packet for decrypt error, from " + logIp));
            return;
        }
        String devServerIp = deviceObj.getDeviceIp();
        if (null != this.filter && null != this.buffer && this.filter.canProceed(data)) {
            try {
                this.buffer.addPacket(new TimeDatagramPacket(data, System.currentTimeMillis(), devServerIp));
            }
            catch (Exception e) {
                LOGGER.fatal((Object)"when proceed packets, some error happend", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] checkMacAndDecrypt(String logIp, byte[] data) {
        int macLength = 32;
        if (null == data || data.length < macLength) {
            LOGGER.error((Object)("drop a packet for lenght < " + macLength));
            return new byte[0];
        }
        int length = data.length;
        byte[] allData = ArrayUtils.subarray((byte[])data, (int)0, (int)(length - macLength));
        byte[] macData = ArrayUtils.subarray((byte[])data, (int)(length - macLength), (int)length);
        boolean macTrue = HmacUtil.getInstance().checkHmac(logIp, allData, macData);
        if (!macTrue) {
            LOGGER.error((Object)("drop a packet for mac check error from " + logIp));
            return new byte[0];
        }
        UnsignedDataInputStream stream = new UnsignedDataInputStream(new ByteArrayInputStream(allData));
        try {
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            int logLength = stream.readUnsignedShort();
            byte[] iv = new byte[16];
            if (16 != stream.read(iv)) {
                LOGGER.error((Object)("drop a packet for read iv error from " + logIp));
                byte[] byArray = new byte[]{};
                return byArray;
            }
            byte[] encryptRecord = new byte[logLength];
            if (logLength != stream.read(encryptRecord)) {
                LOGGER.error((Object)("drop a packet for read encryptRecord error from " + logIp));
                byte[] byArray = new byte[]{};
                return byArray;
            }
            LOGGER.debug((Object)("New device log\uff0c encryptRecord is: " + CommonUtil.getByteArrayStr(encryptRecord)));
            byte[] byArray = AESDecryptorFactory.getInstance().decrypt(encryptRecord, iv, logIp);
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        return new byte[0];
    }

    public void setBuffer(Buffer<TimeDatagramPacket> buffer) {
        this.buffer = buffer;
    }

    public void setFilter(PacketTypeFilter filter) {
        this.filter = filter;
    }

    public boolean isNeedDecrypt() {
        return this.needDecrypt;
    }

    public void setNeedDecrypt(boolean needDecrypt) {
        this.needDecrypt = needDecrypt;
    }
}

