/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.SortBuffer;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ExceptionAndBlackIpSortConsumer
extends Consumer {
    private static long lastExceptionPacketsNum = 0L;
    private static long lastBlackIpPacketsNum = 0L;
    private List<SortBuffer<OriginalExceptionEvent>> exceptionBufferList;
    private List<SortBuffer<ZoneBlackListEvent>> blackIpBufferList;
    private Buffer<OriginalExceptionEvent> exceptionsBuff;
    private Buffer<ZoneBlackListEvent> blackIpBuffer;

    public ExceptionAndBlackIpSortConsumer() {
        this.logger = LogManager.getInstance().getAttackLog();
        this.exceptionBufferList = new ArrayList<SortBuffer<OriginalExceptionEvent>>();
        this.blackIpBufferList = new ArrayList<SortBuffer<ZoneBlackListEvent>>();
    }

    public Buffer<OriginalExceptionEvent> getExceptionsBuff() {
        return this.exceptionsBuff;
    }

    public void setExceptionsBuff(Buffer<OriginalExceptionEvent> exceptionsBuff) {
        this.exceptionsBuff = exceptionsBuff;
    }

    public Buffer<ZoneBlackListEvent> getBlackIpBuffer() {
        return this.blackIpBuffer;
    }

    public void setBlackIpBuffer(Buffer<ZoneBlackListEvent> blackIpBuffer) {
        this.blackIpBuffer = blackIpBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExceptionBuffer(List<SortBuffer<OriginalExceptionEvent>> buffers) {
        List<SortBuffer<OriginalExceptionEvent>> list = this.exceptionBufferList;
        synchronized (list) {
            this.exceptionBufferList.addAll(buffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBlackIpBuffer(List<SortBuffer<ZoneBlackListEvent>> buffers) {
        List<SortBuffer<ZoneBlackListEvent>> list = this.blackIpBufferList;
        synchronized (list) {
            this.blackIpBufferList.addAll(buffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume() {
        ArrayList<SortBuffer<OriginalExceptionEvent>> exceptionData = new ArrayList<SortBuffer<OriginalExceptionEvent>>();
        ArrayList<SortBuffer<ZoneBlackListEvent>> blackIpData = new ArrayList<SortBuffer<ZoneBlackListEvent>>();
        int packetNumber = 0;
        try {
            List<SortBuffer<Event>> list = this.exceptionBufferList;
            synchronized (list) {
                if (!this.exceptionBufferList.isEmpty()) {
                    exceptionData.addAll(this.exceptionBufferList);
                    packetNumber += this.exceptionBufferList.size();
                    this.exceptionBufferList.clear();
                }
            }
            list = this.blackIpBufferList;
            synchronized (list) {
                if (!this.blackIpBufferList.isEmpty()) {
                    blackIpData.addAll(this.blackIpBufferList);
                    packetNumber += this.blackIpBufferList.size();
                    this.logger.info((Object)("blackIpData addAll blackIpBufferList, blackIpBufferList.size()=" + this.blackIpBufferList.size()));
                    this.blackIpBufferList.clear();
                } else {
                    this.logger.debug((Object)"blackIpBufferList is empty");
                }
            }
        }
        catch (Exception e) {
            exceptionData.clear();
            blackIpData.clear();
            this.logger.error((Object)e);
        }
        int n = this.waitTime = packetNumber > 0 ? 0 : 500;
        if (!exceptionData.isEmpty()) {
            try {
                Collections.sort(exceptionData);
                this.sortAndDispatchExceptionEvent(exceptionData);
                this.addExceptionBuffer(exceptionData);
            }
            catch (Exception e) {
                ExceptionAndBlackIpSortConsumer.setLastExceptionPacketsNum(((SortBuffer)exceptionData.get(exceptionData.size() - 1)).getTag());
                exceptionData.clear();
                this.logger.error((Object)("sort exception event error, set lastExceptionPacketsNum=" + lastExceptionPacketsNum), (Throwable)e);
            }
        }
        if (!blackIpData.isEmpty()) {
            try {
                Collections.sort(blackIpData);
                this.sortAndDispatchBlackIpEvent(blackIpData);
                this.addBlackIpBuffer(blackIpData);
            }
            catch (Exception e) {
                ExceptionAndBlackIpSortConsumer.setLastBlackIpPacketsNum(((SortBuffer)blackIpData.get(blackIpData.size() - 1)).getTag());
                blackIpData.clear();
                this.logger.error((Object)("sort black event error, set lastBlackIpPacketsNum=" + lastBlackIpPacketsNum), (Throwable)e);
            }
        }
    }

    private void sortAndDispatchExceptionEvent(List<SortBuffer<OriginalExceptionEvent>> exceptionBufferListTemp) {
        Iterator<SortBuffer<OriginalExceptionEvent>> it = exceptionBufferListTemp.iterator();
        while (it.hasNext()) {
            SortBuffer<OriginalExceptionEvent> buffer = it.next();
            if (buffer.getTag() - lastExceptionPacketsNum == 1L) {
                if (null == this.exceptionsBuff) {
                    this.exceptionsBuff = new Buffer();
                }
                this.exceptionsBuff.addBuffer(buffer);
                ++lastExceptionPacketsNum;
                this.logger.info((Object)"add a exceptionsBuff");
                it.remove();
                continue;
            }
            if (buffer.getTag() > lastExceptionPacketsNum) continue;
            this.logger.error((Object)("drop a exceptionsBuff case buffer.getTag()=" + buffer.getTag() + ", lastExceptionPacketsNum=" + lastExceptionPacketsNum));
            it.remove();
        }
    }

    private void sortAndDispatchBlackIpEvent(List<SortBuffer<ZoneBlackListEvent>> blackIpBufferListTemp) {
        Iterator<SortBuffer<ZoneBlackListEvent>> it = blackIpBufferListTemp.iterator();
        while (it.hasNext()) {
            SortBuffer<ZoneBlackListEvent> buffer = it.next();
            if (buffer.getTag() - lastBlackIpPacketsNum == 1L) {
                if (null != this.blackIpBuffer) {
                    this.blackIpBuffer.addBuffer(buffer);
                }
                ++lastBlackIpPacketsNum;
                this.logger.info((Object)"add a blackIpBuffer");
                it.remove();
                continue;
            }
            if (buffer.getTag() > lastBlackIpPacketsNum) continue;
            this.logger.error((Object)("drop a blackBUffer case buffer.getTag()=" + buffer.getTag() + ", lastBlackIpPacketsNum=" + lastBlackIpPacketsNum));
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SortBuffer<OriginalExceptionEvent>> getExceptionBufferList() {
        List<SortBuffer<OriginalExceptionEvent>> list = this.exceptionBufferList;
        synchronized (list) {
            return this.exceptionBufferList;
        }
    }

    public void setExceptionBufferList(List<SortBuffer<OriginalExceptionEvent>> exceptionBufferList) {
        this.exceptionBufferList = exceptionBufferList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SortBuffer<ZoneBlackListEvent>> getBlackIpBufferList() {
        List<SortBuffer<ZoneBlackListEvent>> list = this.blackIpBufferList;
        synchronized (list) {
            return this.blackIpBufferList;
        }
    }

    public void setBlackIpBufferList(List<SortBuffer<ZoneBlackListEvent>> blackIpBufferList) {
        this.blackIpBufferList = blackIpBufferList;
    }

    protected void proceedPacket(List packets) {
    }

    public static long getLastExceptionPacketsNum() {
        return lastExceptionPacketsNum;
    }

    public static void setLastExceptionPacketsNum(long lastExceptionPacketsNum) {
        ExceptionAndBlackIpSortConsumer.lastExceptionPacketsNum = lastExceptionPacketsNum;
    }

    public static long getLastBlackIpPacketsNum() {
        return lastBlackIpPacketsNum;
    }

    public static void setLastBlackIpPacketsNum(long lastBlackIpPacketsNum) {
        ExceptionAndBlackIpSortConsumer.lastBlackIpPacketsNum = lastBlackIpPacketsNum;
    }
}

