/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import java.util.List;

public class ExceptionEventConsumer
extends Consumer<OriginalExceptionEvent> {
    private Processor<OriginalExceptionEvent> processor;

    public ExceptionEventConsumer(Processor<OriginalExceptionEvent> processor) {
        this.processor = processor;
    }

    @Override
    protected void proceedPacket(List<OriginalExceptionEvent> packets) {
        if (packets.isEmpty()) {
            this.processor.processMetaData(packets);
            return;
        }
        int startPosition = 0;
        int endPosition = 0;
        for (OriginalExceptionEvent t : packets) {
            ++endPosition;
            if (!t.isNormal()) continue;
            this.processor.processMetaData(packets.subList(startPosition, endPosition));
            startPosition = endPosition;
        }
        if (startPosition != endPosition) {
            this.processor.processMetaData(packets.subList(startPosition, endPosition));
        }
    }
}

