/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.AbnormalEventParser;
import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ExceptionEventParser
extends AbnormalEventParser
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int ATTACK = 1;
    private static final int ALERT = 4;
    private static final long DEFAULT_BIZ_ID = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        FilterInputStream stream = null;
        try {
            int abnormalType;
            OriginalExceptionEvent event;
            int i;
            if (type == 4) {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (i = 0; i < number; ++i) {
                    event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    abnormalType = this.parse((UnsignedDataInputStream)stream, event);
                    this.setExceptionEventType(event, abnormalType);
                    if (event.getIdentifier().getBizId() == 0L && !event.getIdentifier().isDesZone() && CollectorVersionRepository.getInstance().isNeedDrop()) continue;
                    suitEvent.addOriginalExceptionEvent(event);
                }
            }
            if (type == 1) {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (i = 0; i < number; ++i) {
                    event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    abnormalType = this.parse((UnsignedDataInputStream)stream, event);
                    if (abnormalType != 1) continue;
                    event.setCurrentState(1);
                    if (event.getIdentifier().getBizId() == 0L && !event.getIdentifier().isDesZone() && CollectorVersionRepository.getInstance().isNeedDrop()) continue;
                    suitEvent.addOriginalExceptionEvent(event);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"when close stream error", (Throwable)e);
        }
        finally {
            if (null != stream) {
                stream.close();
            }
        }
    }

    private void setExceptionEventType(OriginalExceptionEvent event, int state) {
        switch (state) {
            case 1: {
                event.setCurrentState(1);
                break;
            }
            case 2: {
                event.setCurrentState(0);
                break;
            }
        }
    }
}

