/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ExceptionEventParserV3
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int ALERT = 4;
    private static final long DEFAULT_BIZ_ID = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (type == 4) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    int abnormalType = this.parseAlert((UnsignedDataInputStream)stream, event);
                    this.setExceptionEventType(event, abnormalType);
                    if (event.getIdentifier().getBizId() == 0L && !event.getIdentifier().isDesZone() && CollectorVersionRepository.getInstance().isNeedDrop()) continue;
                    suitEvent.addOriginalExceptionEvent(event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stream error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void setExceptionEventType(OriginalExceptionEvent event, int state) {
        switch (state) {
            case 1: {
                event.setCurrentState(1);
                break;
            }
            case 2: {
                event.setCurrentState(0);
                break;
            }
            default: {
                event.setCurrentState(1);
            }
        }
    }

    private int parseAlert(UnsignedDataInputStream stream, OriginalExceptionEvent event) throws IOException {
        int type = stream.readUnsignedByte();
        int protocol = 0;
        int port = 0;
        int state = stream.readUnsignedByte();
        stream.readUnsignedShort();
        if (type < 10) {
            protocol = stream.readUnsignedByte();
            stream.readUnsignedByte();
            port = stream.readUnsignedShort();
        } else {
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            stream.readUnsignedShort();
            protocol = event.getIdentifier().getProtocol();
            port = event.getIdentifier().getPort();
        }
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, event.getIdentifier().getDeviceIp());
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        long realKbps = stream.readUnsignedInt();
        long realPps = stream.readUnsignedInt();
        long normalKbps = stream.readUnsignedInt();
        long normalPps = stream.readUnsignedInt();
        event.setRealValue(realKbps > 0L ? realKbps : realPps);
        event.setNormalValue(normalKbps > 0L ? normalKbps : normalPps);
        event.setPpsOrKbps(realKbps > 0L || normalKbps > 0L ? 1 : 0);
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedShort();
        return state;
    }
}

