/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.unicom.CleanLogProcessThread;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.event.hcc.HccAttackDataProcess;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ExceptionEventRepositoryThread
extends EventHandler<ChangeEvent<AbnormalEvent>, ChangeEvent<AbnormalEvent>>
implements Runnable {
    private static final String REPOSITORY_NAME = "com.hs.atic.collector.entity.event.ExceptionEvent";
    private static final Repository REPOSITORY = RepositoryFactory.getInstance().getRepository("com.hs.atic.collector.entity.event.ExceptionEvent");
    private static final long FIVE_SECOND = 5000L;
    private static final int FIVE_TIMES = 5;
    private static AtomicBoolean needRepository = new AtomicBoolean(false);
    protected ReentrantLock lock = new ReentrantLock();
    List<AbnormalEvent> attacked = new ArrayList<AbnormalEvent>();
    private AlarmThread alarmThread = AlarmThread.getInstance();
    private Map<Type, ExceptionEvent> attacking = new HashMap<Type, ExceptionEvent>();
    private Map<Type, ExceptionEvent> attackStart = new HashMap<Type, ExceptionEvent>();

    public ExceptionEventRepositoryThread() {
        super.setLogger(LogManager.getInstance().getDBLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ChangeEvent<AbnormalEvent>> handelEvents(List<ChangeEvent<AbnormalEvent>> events) {
        if (!events.isEmpty()) {
            if (needRepository.get()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)"Thread.sleep InterruptedException error", (Throwable)e);
                }
            }
            ArrayList<ExceptionEvent> startAlertAlarmList = new ArrayList<ExceptionEvent>();
            ArrayList<ExceptionEvent> endAlertAlarmList = new ArrayList<ExceptionEvent>();
            ArrayList<ExceptionEvent> doingAlertAlarmList = new ArrayList<ExceptionEvent>();
            this.lock.lock();
            try {
                for (ChangeEvent<AbnormalEvent> each : events) {
                    ExceptionEvent source = (ExceptionEvent)each.getSource();
                    IpType ipType = new IpType(source.getType(), source.getIdentifier());
                    if (source.isNormal()) {
                        this.attacking.remove(ipType);
                        this.attackStart.remove(ipType);
                        this.attacked.add(source);
                        if (!source.isSendAlarm()) continue;
                        endAlertAlarmList.add(source);
                        continue;
                    }
                    if (!source.isHasInserted() && !this.attackStart.containsKey(ipType)) {
                        this.attacking.remove(ipType);
                        this.attackStart.put(ipType, source);
                    }
                    if (source.isHasInserted() && !this.attackStart.containsKey(ipType)) {
                        this.attacking.put(ipType, source);
                    }
                    if (!source.isSendAlarm()) {
                        startAlertAlarmList.add(source);
                        source.setSendAlarm(true);
                    } else if (73 == source.getAttackType().getTypeValue()) {
                        startAlertAlarmList.add(source);
                    }
                    if (startAlertAlarmList.contains(source) || endAlertAlarmList.contains(source)) continue;
                    doingAlertAlarmList.add(source);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (!startAlertAlarmList.isEmpty()) {
                this.alarmThread.addAbnormalAlarmStart(startAlertAlarmList);
                CleanLogProcessThread.getInstance().processAttackExactLog(startAlertAlarmList);
            }
            if (!endAlertAlarmList.isEmpty()) {
                this.alarmThread.addAbnormalAlarmEnd(endAlertAlarmList);
                CleanLogProcessThread.getInstance().processAttackExactLog(endAlertAlarmList);
            }
            if (!doingAlertAlarmList.isEmpty()) {
                this.alarmThread.refreshAbnormalAlarmDoing(doingAlertAlarmList);
                CleanLogProcessThread.getInstance().processAttackExactLog(doingAlertAlarmList);
            }
        }
        return new ArrayList<ChangeEvent<AbnormalEvent>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<AbnormalEvent> attackedTemp = null;
        ArrayList<AbnormalEvent> ulist = new ArrayList<AbnormalEvent>();
        ArrayList<AbnormalEvent> clist = new ArrayList<AbnormalEvent>();
        Map<Type, ExceptionEvent> attackingTemp = null;
        Map<Type, ExceptionEvent> attackStartTemp = null;
        int excuteTimes = 0;
        while (true) {
            needRepository.set(true);
            ++excuteTimes;
            this.lock.lock();
            try {
                attackedTemp = this.attacked;
                this.attacked = new ArrayList<AbnormalEvent>();
                attackStartTemp = this.attackStart;
                this.attackStart = new HashMap<Type, ExceptionEvent>();
                if (excuteTimes == 5) {
                    attackingTemp = this.attacking;
                    this.attacking = new HashMap<Type, ExceptionEvent>();
                    excuteTimes = 0;
                }
            }
            finally {
                this.lock.unlock();
            }
            needRepository.set(false);
            try {
                if (!attackedTemp.isEmpty()) {
                    for (AbnormalEvent e : attackedTemp) {
                        ExceptionEvent event = (ExceptionEvent)e;
                        if (event.isHasInserted()) {
                            ulist.add(e);
                            continue;
                        }
                        clist.add(e);
                    }
                }
                HccAttackDataProcess.getInstance().notifyAttackDatas(attackedTemp);
                if (!attackStartTemp.isEmpty()) {
                    for (ExceptionEvent event : attackStartTemp.values()) {
                        if (event.isHasInserted()) {
                            ulist.add(event);
                            continue;
                        }
                        clist.add(event);
                    }
                }
                if (null != attackingTemp && !attackingTemp.isEmpty()) {
                    for (ExceptionEvent event : attackingTemp.values()) {
                        if (event.isHasInserted()) {
                            ulist.add(event);
                            continue;
                        }
                        clist.add(event);
                    }
                    attackingTemp.clear();
                }
                if (!ulist.isEmpty()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("update abnormal events :" + ulist));
                    }
                    this.logger.info((Object)("start to update exception events, size=" + ulist.size()));
                    REPOSITORY.updateObjects(ulist);
                    ulist.clear();
                }
                if (!clist.isEmpty()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("create abnormal events :" + clist));
                    }
                    REPOSITORY.createObjects(clist);
                    clist.clear();
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"exception events into db error!  ", (Throwable)e);
                ulist.clear();
                clist.clear();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)"Thread.sleep InterruptedException error", (Throwable)e1);
                }
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Thread.sleep InterruptedException error", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

