/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.HttpBizFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FlowEventParser
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int CON = 3;
    private static final int APPLAYER = 2;
    private static final int BASIC = 0;
    private static final int EXPAND = 1;
    private static final int NORMAL = 0;
    private static final int FLOW = 0;
    private static final int TCP = 1;
    private static final int UDP = 2;
    private static final int HTTP = 3;
    private static final int USER_DEF = 0;
    private static final int HTTPS = 1;
    private static final int HTTP_GET = 2;
    private static final int HTTP_POST = 3;
    private static final int DNS_REQUEST = 4;
    private static final int DNS_REPLY = 5;
    private static final int SIP_INVITE = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 0) {
            FilterInputStream stream = null;
            try {
                DiscardFlowEvent discardFlowEvent = new DiscardFlowEvent(event.getIdentifier());
                InFlowEvent inFlowEvent = new InFlowEvent(event.getIdentifier());
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event, inFlowEvent, discardFlowEvent);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stream error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow, DiscardFlowEvent discard) throws IOException {
        int type = stream.readUnsignedByte();
        int state = stream.readUnsignedByte();
        stream.readUnsignedShort();
        switch (type) {
            case 0: {
                if (state == 0) {
                    this.readBasicFlowEvent(stream, inFlow);
                    suit.setInFlowEvent(inFlow);
                    break;
                }
                if (discard.getDeviceType() == 1) {
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    break;
                }
                this.readBasicFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 1: {
                if (state == 0) {
                    this.readTcpExpandFlowEvent(stream, inFlow);
                    suit.setInFlowEvent(inFlow);
                    break;
                }
                if (discard.getDeviceType() == 1) {
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    break;
                }
                this.readTcpExpandFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 2: {
                int protocol = stream.readUnsignedByte();
                int subType = stream.readUnsignedByte();
                int port = stream.readUnsignedShort();
                long inPps = stream.readUnsignedInt();
                long inKbps = stream.readUnsignedInt();
                if (subType == 0) {
                    long bizId = FoundIDUtil.getInstance().getBizId(suit.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(protocol), port, suit.getIdentifier().getDeviceIp());
                    switch (protocol) {
                        case 1: {
                            TcpBizFlowEvent tcpBizFlow = new TcpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = tcpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            tcpBizFlow.setIdentifer(identifer);
                            tcpBizFlow.setNeedSum(false);
                            if (state == 0) {
                                tcpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                tcpBizFlow.setDropFlow(true);
                            }
                            this.handleTcpApp(tcpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(tcpBizFlow);
                            break;
                        }
                        case 2: {
                            UdpBizFlowEvent udpBizFlow = new UdpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = udpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            udpBizFlow.setIdentifer(identifer);
                            udpBizFlow.setNeedSum(false);
                            if (state == 0) {
                                udpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                udpBizFlow.setDropFlow(true);
                            }
                            this.handleUdpApp(udpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(udpBizFlow);
                            break;
                        }
                        case 3: {
                            HttpBizFlowEvent httpBizFlow = new HttpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = httpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            httpBizFlow.setIdentifer(identifer);
                            httpBizFlow.setNeedSum(false);
                            if (state == 0) {
                                httpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                httpBizFlow.setDropFlow(true);
                            }
                            this.handleHttpApp(httpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(httpBizFlow);
                            break;
                        }
                    }
                    break;
                }
                if (state == 0) {
                    this.handleFixInApp(subType, inPps, inFlow);
                    suit.setInFlowEvent(inFlow);
                    break;
                }
                this.handleFixDropApp(subType, inPps, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 3: {
                this.readBasicConEvent(stream, inFlow);
                suit.setInFlowEvent(inFlow);
                break;
            }
            default: {
                throw new IOException("error flow type :" + type);
            }
        }
    }

    private void readBasicFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setTcpPps(stream.readUnsignedInt());
        flowEvent.setTcpKbps(stream.readUnsignedInt());
        flowEvent.setTcpFragPps(stream.readUnsignedInt());
        flowEvent.setTcpFragKbps(stream.readUnsignedInt());
        flowEvent.setUdpPps(stream.readUnsignedInt());
        flowEvent.setUdpKbps(stream.readUnsignedInt());
        flowEvent.setUdpFragPps(stream.readUnsignedInt());
        flowEvent.setUdpFragKbps(stream.readUnsignedInt());
        flowEvent.setIcmpPps(stream.readUnsignedInt());
        flowEvent.setIcmpKbps(stream.readUnsignedInt());
        flowEvent.setOtherPps(stream.readUnsignedInt());
        flowEvent.setOtherKbps(stream.readUnsignedInt());
        flowEvent.caculateTotal();
    }

    private void readBasicConEvent(UnsignedDataInputStream stream, InFlowEvent flowEvent) throws IOException {
        flowEvent.setTcpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setUdpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setIcmpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setOtherIncreaseCon(stream.readUnsignedInt());
        flowEvent.setTcpConcurCon(stream.readUnsignedInt());
        flowEvent.setUdpConcurCon(stream.readUnsignedInt());
        flowEvent.setIcmpConcurCon(stream.readUnsignedInt());
        flowEvent.setOtherConcurCon(stream.readUnsignedInt());
    }

    private void readTcpExpandFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setSynPps(stream.readUnsignedInt());
        flowEvent.setSynAckPps(stream.readUnsignedInt());
        flowEvent.setAckPps(stream.readUnsignedInt());
        flowEvent.setFinRstPps(stream.readUnsignedInt());
    }

    private void handleFixDropApp(int subType, long inPps, DiscardFlowEvent discard) {
        switch (subType) {
            case 1: {
                discard.setHttpsPps(inPps);
                break;
            }
            case 2: 
            case 3: {
                discard.setHttpPps(inPps);
                break;
            }
            case 4: {
                discard.setDnsRequestPps(inPps);
                break;
            }
            case 5: {
                discard.setDnsReplyPps(inPps);
                break;
            }
            case 6: {
                discard.setSipInvitePps(inPps);
                break;
            }
        }
    }

    private void handleFixInApp(int subType, long inPps, InFlowEvent inFlow) {
        switch (subType) {
            case 1: {
                inFlow.setHttpsPps(inPps);
                break;
            }
            case 2: 
            case 3: {
                inFlow.setHttpPps(inPps);
                break;
            }
            case 4: {
                inFlow.setDnsRequestPps(inPps);
                break;
            }
            case 5: {
                inFlow.setDnsReplyPps(inPps);
                break;
            }
            case 6: {
                inFlow.setSipInvitePps(inPps);
                break;
            }
        }
    }

    private void handleHttpApp(HttpBizFlowEvent httpBizFlow, long inPps, long inKbps) {
        httpBizFlow.setTotalKbps(inKbps);
        httpBizFlow.setTotalPps(inPps);
    }

    private void handleTcpApp(TcpBizFlowEvent tcpBizFlow, long inPps, long inKbps) {
        tcpBizFlow.setTotalKbps(inKbps);
        tcpBizFlow.setTotalPps(inPps);
    }

    private void handleUdpApp(UdpBizFlowEvent udpBizFlow, long inPps, long inKbps) {
        udpBizFlow.setTotalKbps(inKbps);
        udpBizFlow.setTotalPps(inPps);
    }
}

