/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.HttpBizFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FlowEventParserV2
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int CON = 3;
    private static final int APPLAYER = 2;
    private static final int BASIC = 0;
    private static final int EXPAND = 1;
    private static final int NORMAL = 0;
    private static final int FLOW = 0;
    private static final int TCP_DNS_BIZ = 8;
    private static final int UDP_DNS_BIZ = 9;
    private static final int TCP = 1;
    private static final int UDP = 2;
    private static final int HTTP = 3;
    private static final int USER_DEF = 0;
    private static final int HTTPS = 1;
    private static final int HTTP_GET = 2;
    private static final int HTTP_POST = 3;
    private static final int DNS_REQUEST = 4;
    private static final int DNS_REPLY = 5;
    private static final int SIP_INVITE = 6;
    private static final long ILLEGALBIZID = -1L;

    private void handleFixDropApp(int subType, long inPps, DiscardFlowEvent discard) {
        switch (subType) {
            case 1: {
                discard.setHttpsPps(inPps);
                break;
            }
            case 2: 
            case 3: {
                discard.setHttpPps(inPps);
                break;
            }
            case 4: {
                discard.setDnsRequestPps(inPps);
                break;
            }
            case 5: {
                discard.setDnsReplyPps(inPps);
                break;
            }
            case 6: {
                discard.setSipInvitePps(inPps);
                break;
            }
        }
    }

    private void handleFixInApp(int subType, long inPps, InFlowEvent inFlow) {
        switch (subType) {
            case 1: {
                inFlow.setHttpsPps(inPps);
                break;
            }
            case 2: 
            case 3: {
                inFlow.setHttpPps(inPps);
                break;
            }
            case 4: {
                inFlow.setDnsRequestPps(inPps);
                break;
            }
            case 5: {
                inFlow.setDnsReplyPps(inPps);
                break;
            }
            case 6: {
                inFlow.setSipInvitePps(inPps);
                break;
            }
        }
    }

    private void handleHttpApp(HttpBizFlowEvent httpBizFlow, long inPps, long inKbps) {
        httpBizFlow.setTotalKbps(inKbps);
        httpBizFlow.setTotalPps(inPps);
    }

    private void handleTcpApp(TcpBizFlowEvent tcpBizFlow, long inPps, long inKbps) {
        tcpBizFlow.setTotalKbps(inKbps);
        tcpBizFlow.setTotalPps(inPps);
    }

    private void handleUdpApp(UdpBizFlowEvent udpBizFlow, long inPps, long inKbps) {
        udpBizFlow.setTotalKbps(inKbps);
        udpBizFlow.setTotalPps(inPps);
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow, DiscardFlowEvent discard) throws IOException {
        int type = stream.readUnsignedByte();
        int state = stream.readUnsignedByte();
        int length = stream.readUnsignedShort();
        switch (type) {
            case 0: {
                if (length != 48) {
                    throw new IOException("flow baise format error ,length is " + length);
                }
                if (state == 0) {
                    this.readBasicFlowEvent(stream, inFlow);
                    inFlow.setDropFlow(false);
                    suit.setInFlowEvent(inFlow);
                    break;
                }
                if (discard.getDeviceType() == 1) {
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    break;
                }
                this.readBasicFlowEvent(stream, discard);
                discard.setDropFlow(true);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 1: {
                if (length != 16) {
                    throw new IOException("flow expand format error ,length is " + length);
                }
                if (state == 0) {
                    this.readTcpExpandFlowEvent(stream, inFlow);
                    suit.setInFlowEvent(inFlow);
                    break;
                }
                if (discard.getDeviceType() == 1) {
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    stream.readUnsignedInt();
                    break;
                }
                this.readTcpExpandFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 2: {
                if (length != 12) {
                    throw new IOException("flow app format error ,length is " + length);
                }
                int protocol = stream.readUnsignedByte();
                int subType = stream.readUnsignedByte();
                int port = stream.readUnsignedShort();
                long inPps = stream.readUnsignedInt();
                long inKbps = stream.readUnsignedInt();
                if (subType == 0) {
                    long bizId = this.getUserDefBizId(suit, EventUtil.getCustomProtocolStr(protocol), port);
                    switch (protocol) {
                        case 1: {
                            TcpBizFlowEvent tcpBizFlow = new TcpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = tcpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            tcpBizFlow.setIdentifer(identifer);
                            tcpBizFlow.setNeedSum(false);
                            if (state == 0) {
                                tcpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                tcpBizFlow.setDropFlow(true);
                            }
                            this.handleTcpApp(tcpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(tcpBizFlow);
                            break;
                        }
                        case 2: {
                            UdpBizFlowEvent udpBizFlow = new UdpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = udpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            udpBizFlow.setIdentifer(identifer);
                            udpBizFlow.setNeedSum(false);
                            if (state == 0) {
                                udpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                udpBizFlow.setDropFlow(true);
                            }
                            this.handleUdpApp(udpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(udpBizFlow);
                            break;
                        }
                        case 3: {
                            HttpBizFlowEvent httpBizFlow = new HttpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = httpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            httpBizFlow.setIdentifer(identifer);
                            httpBizFlow.setNeedSum(false);
                            if (state == 0) {
                                httpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                httpBizFlow.setDropFlow(true);
                            }
                            this.handleHttpApp(httpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(httpBizFlow);
                            break;
                        }
                    }
                    break;
                }
                if (state == 0) {
                    this.handleFixInApp(subType, inPps, inFlow);
                    suit.setInFlowEvent(inFlow);
                    break;
                }
                this.handleFixDropApp(subType, inPps, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 3: {
                if (length != 36) {
                    throw new IOException("flow con format error ,length is " + length);
                }
                this.readBasicConEvent(stream, inFlow, state);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 8: {
                TcpDnsBizFlowEvent tcpDnsBizFlow = new TcpDnsBizFlowEvent(suit.getIdentifier());
                if (state == 0) {
                    tcpDnsBizFlow.setDropFlow(false);
                } else {
                    if (tcpDnsBizFlow.getDeviceType() == 1) {
                        this.readTcpDnsBizEvent(stream, tcpDnsBizFlow);
                        break;
                    }
                    tcpDnsBizFlow.setDropFlow(true);
                }
                tcpDnsBizFlow.setNeedSum(false);
                this.readTcpDnsBizEvent(stream, tcpDnsBizFlow);
                suit.addServiceEvents(tcpDnsBizFlow);
                break;
            }
            case 9: {
                UdpDnsBizFlowEvent udpDnsBizFlow = new UdpDnsBizFlowEvent(suit.getIdentifier());
                ArrayList<UdpDnsUserDefTypeEvent> udpDnsTypeFlow = new ArrayList<UdpDnsUserDefTypeEvent>();
                if (state == 0) {
                    udpDnsBizFlow.setDropFlow(false);
                } else {
                    if (udpDnsBizFlow.getDeviceType() == 1) {
                        this.readUdpDnsBizEvent(stream, udpDnsBizFlow, udpDnsTypeFlow, suit, state);
                        break;
                    }
                    udpDnsBizFlow.setDropFlow(true);
                }
                udpDnsBizFlow.setNeedSum(false);
                this.readUdpDnsBizEvent(stream, udpDnsBizFlow, udpDnsTypeFlow, suit, state);
                suit.addServiceEvents(udpDnsBizFlow);
                suit.addDnsTypeEvents(udpDnsTypeFlow);
                break;
            }
            default: {
                throw new IOException("error flow type :" + type);
            }
        }
    }

    private long getUserDefBizId(IpSuitEvent suit, String protcolStr, int port) {
        long bizId = -1L;
        try {
            String deviceIp = suit.getIdentifier().getDeviceIp();
            bizId = FoundIDUtil.getInstance().getBizId(suit.getIdentifier().getZoneId(), protcolStr, port, deviceIp);
            LOGGER.info((Object)("deviceIp is: " + deviceIp + ";protocol is : " + this.getcleanedMessage(protcolStr) + ";port is : " + port + ";bizId is : " + bizId));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get biz id error", (Throwable)e);
        }
        return bizId;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 0) {
            FilterInputStream stream = null;
            try {
                DiscardFlowEvent discardFlowEvent = new DiscardFlowEvent(event.getIdentifier());
                InFlowEvent inFlowEvent = new InFlowEvent(event.getIdentifier());
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event, inFlowEvent, discardFlowEvent);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stream error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void readBasicConEvent(UnsignedDataInputStream stream, InFlowEvent flowEvent, int state) throws IOException {
        flowEvent.setTcpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setUdpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setIcmpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setOtherIncreaseCon(stream.readUnsignedInt());
        flowEvent.setTcpConcurCon(stream.readUnsignedInt());
        flowEvent.setUdpConcurCon(stream.readUnsignedInt());
        flowEvent.setIcmpConcurCon(stream.readUnsignedInt());
        flowEvent.setOtherConcurCon(stream.readUnsignedInt());
        int url = (int)stream.readUnsignedInt();
        if (state == 0) {
            flowEvent.setUrl(url);
        }
    }

    private void readBasicFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setTcpPps(stream.readUnsignedInt());
        flowEvent.setTcpKbps(stream.readUnsignedInt());
        flowEvent.setTcpFragPps(stream.readUnsignedInt());
        flowEvent.setTcpFragKbps(stream.readUnsignedInt());
        flowEvent.setUdpPps(stream.readUnsignedInt());
        flowEvent.setUdpKbps(stream.readUnsignedInt());
        flowEvent.setUdpFragPps(stream.readUnsignedInt());
        flowEvent.setUdpFragKbps(stream.readUnsignedInt());
        flowEvent.setIcmpPps(stream.readUnsignedInt());
        flowEvent.setIcmpKbps(stream.readUnsignedInt());
        flowEvent.setOtherPps(stream.readUnsignedInt());
        flowEvent.setOtherKbps(stream.readUnsignedInt());
        flowEvent.caculateTotal();
    }

    private void readTcpDnsBizEvent(UnsignedDataInputStream stream, TcpDnsBizFlowEvent tcpDnsBizFlow) throws IOException {
        tcpDnsBizFlow.setSynPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setSynAckPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setAckPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setFinRstPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setTotalPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setTotalKbps(stream.readUnsignedInt());
        tcpDnsBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setCurConPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setSpecialPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setSpecialKbps(stream.readUnsignedInt());
    }

    private void readTcpExpandFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setSynPps(stream.readUnsignedInt());
        flowEvent.setSynAckPps(stream.readUnsignedInt());
        flowEvent.setAckPps(stream.readUnsignedInt());
        flowEvent.setFinRstPps(stream.readUnsignedInt());
    }

    private void readUdpDnsBizEvent(UnsignedDataInputStream stream, UdpDnsBizFlowEvent udpDnsBizFlow, List<UdpDnsUserDefTypeEvent> typeList, IpSuitEvent suit, int state) throws IOException {
        udpDnsBizFlow.setTotalPps(stream.readUnsignedInt());
        udpDnsBizFlow.setTotalKbps(stream.readUnsignedInt());
        udpDnsBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        udpDnsBizFlow.setCurConPps(stream.readUnsignedInt());
        udpDnsBizFlow.setRequestPps(stream.readUnsignedInt());
        udpDnsBizFlow.setReplyPps(stream.readUnsignedInt());
        udpDnsBizFlow.setDisSendReplyPps(stream.readUnsignedInt());
        udpDnsBizFlow.setaRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setPtrRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setNsRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setMxRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setTxtRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setCnnameRequestPps(stream.readUnsignedInt());
        udpDnsBizFlow.setSoaRequestPps(stream.readUnsignedInt());
        udpDnsBizFlow.setAaaaRequstPps(stream.readUnsignedInt());
        UdpDnsUserDefTypeEvent dnsTypeEvent1 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent1.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent2 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent2.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent3 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent3.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent4 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent4.setNeedSum(false);
        if (state == 0) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent1.setDnsValue(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsValue(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsValue(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsValue(stream.readUnsignedInt());
        } else {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent1.setDnsDropValue(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsDropValue(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsDropValue(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsDropValue(stream.readUnsignedInt());
        }
        if (dnsTypeEvent1.isValid()) {
            typeList.add(dnsTypeEvent1);
        }
        if (dnsTypeEvent2.isValid()) {
            typeList.add(dnsTypeEvent2);
        }
        if (dnsTypeEvent3.isValid()) {
            typeList.add(dnsTypeEvent3);
        }
        if (dnsTypeEvent4.isValid()) {
            typeList.add(dnsTypeEvent4);
        }
        udpDnsBizFlow.setOtherRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setFragPps(stream.readUnsignedInt());
        udpDnsBizFlow.setLargePps(stream.readUnsignedInt());
        udpDnsBizFlow.setiLegalPps(stream.readUnsignedInt());
        udpDnsBizFlow.setTtlDeniedPps(stream.readUnsignedInt());
    }
}

