/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.HttpBizFlowEvent;
import com.hs.atic.collector.entity.event.HttpsBizFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.InterfaceFlowEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.SipBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.manager.mbean.FlowEventParserParamBean;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FlowEventParserV4
implements EventDataParser {
    private static final int BASIC = 0;
    private static final int EXPAND = 1;
    private static final int APPLAYER = 2;
    private static final int CON = 3;
    private static final int TCP_BIZ = 4;
    private static final int UDP_BIZ = 5;
    private static final int HTTP_BIZ = 6;
    private static final int HTTPS_BIZ = 7;
    private static final int TCP_DNS_BIZ = 8;
    private static final int UDP_DNS_BIZ = 9;
    private static final int SIP_BIZ = 10;
    private static final int INTERFACE = 11;
    private static final int OTHER_BIZ = 12;
    private static final int NORMAL = 0;
    private static final int DROP = 1;
    private static final int MAX_NORMAL = 2;
    private static final int MAX_DROP = 3;
    private static final int FLOW = 0;
    private static final int REBOUND_FLOW = 4;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int USER_DEF = 0;
    private static final int HTTPS = 1;
    private static final int HTTP_APP = 2;
    private static final int HTTP_POST = 3;
    private static final int DNS_REQUEST = 4;
    private static final int DNS_REPLY = 5;
    private static final int SIP_INVITE = 6;
    private static final int HTTP_GET = 8;
    private static final int TCP = 1;
    private static final int UDP = 2;
    private static final int HTTP = 3;
    private static final long ILLEGALBIZID = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 0) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                DiscardFlowEvent discard = new DiscardFlowEvent(event.getIdentifier());
                InFlowEvent inFlow = new InFlowEvent(event.getIdentifier());
                DiscardFlowEvent maxDiscard = new DiscardFlowEvent(event.getIdentifier());
                maxDiscard.setMaxEvent(true);
                InFlowEvent maxInFlow = new InFlowEvent(event.getIdentifier());
                maxInFlow.setMaxEvent(true);
                FlowEventParserParamBean paramBean = new FlowEventParserParamBean();
                paramBean.setStream((UnsignedDataInputStream)stream);
                paramBean.setSuit(event);
                paramBean.setInFlow(inFlow);
                paramBean.setDiscard(discard);
                paramBean.setMaxInFlow(maxInFlow);
                paramBean.setMaxDiscard(maxDiscard);
                for (int i = 0; i < number; ++i) {
                    this.parse(paramBean);
                }
                if (event.isFlowOverMax()) {
                    LOGGER.info((Object)("The event flow is bigger than " + CommonUtil.getAticFlowMaxNum() + ", the recive device data=" + CommonUtil.getByteArrayStr(data)));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stream error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void handleHttpApp(HttpBizFlowEvent httpBizFlow, long inPps, long inKbps) {
        httpBizFlow.setTotalKbps(inKbps);
        httpBizFlow.setTotalPps(inPps);
    }

    private void handleTcpApp(TcpBizFlowEvent tcpBizFlow, long inPps, long inKbps) {
        tcpBizFlow.setTotalKbps(inKbps);
        tcpBizFlow.setTotalPps(inPps);
    }

    private void handleUdpApp(UdpBizFlowEvent udpBizFlow, long inPps, long inKbps) {
        udpBizFlow.setTotalKbps(inKbps);
        udpBizFlow.setTotalPps(inPps);
    }

    private void parseReboundFlowEvent(int length, UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        if (length != 16) {
            throw new IOException("flow baise format error ,length is " + length);
        }
        discard.setTcpReboundPps(stream.readUnsignedInt());
        discard.setTcpReboundKbps(stream.readUnsignedInt());
        discard.setUdpReboundPps(stream.readUnsignedInt());
        discard.setUdpReboundKbps(stream.readUnsignedInt());
        discard.caculateTotal();
        suit.setDiscardFlowEvent(discard);
    }

    private void parseFlowEvent(int[] params, UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow, DiscardFlowEvent discard) throws IOException {
        int state = params[0];
        int length = params[1];
        if (length != 48) {
            throw new IOException("flow baise format error ,length is " + length);
        }
        switch (state) {
            case 0: {
                this.readBasicFlowEvent(stream, inFlow);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 2: {
                this.readBasicFlowEvent(stream, inFlow);
                suit.setMaxInFlowEvent(inFlow);
                break;
            }
            case 1: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[48]) == 48) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readBasicFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 3: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[48]) == 48) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readBasicFlowEvent(stream, discard);
                suit.setMaxDiscardFlowEvent(discard);
                break;
            }
            default: {
                if (stream.read(new byte[48]) == 48) break;
                LOGGER.error((Object)"stream read error");
            }
        }
    }

    private void parseReboundExpandEvent(int length, UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        if (length != 8) {
            throw new IOException("flow expand format error ,length is " + length);
        }
        discard.setSynReboundPps(stream.readUnsignedInt());
        discard.setSynAckReboundPps(stream.readUnsignedInt());
        suit.setDiscardFlowEvent(discard);
    }

    private void parseExpandEvent(int[] params, UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow, DiscardFlowEvent discard) throws IOException {
        int state = params[0];
        int length = params[1];
        if (length != 16) {
            throw new IOException("flow expand format error ,length is " + length);
        }
        switch (state) {
            case 0: {
                this.readTcpExpandFlowEvent(stream, inFlow);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 2: {
                this.readTcpExpandFlowEvent(stream, inFlow);
                suit.setMaxInFlowEvent(inFlow);
                break;
            }
            case 1: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[16]) == 16) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readTcpExpandFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 3: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[16]) == 16) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readTcpExpandFlowEvent(stream, discard);
                suit.setMaxDiscardFlowEvent(discard);
                break;
            }
            default: {
                if (stream.read(new byte[16]) == 16) break;
                LOGGER.error((Object)"stream read error");
            }
        }
    }

    private void parse(FlowEventParserParamBean paramBean) throws IOException {
        UnsignedDataInputStream stream = paramBean.getStream();
        IpSuitEvent suit = paramBean.getSuit();
        InFlowEvent inFlow = paramBean.getInFlow();
        DiscardFlowEvent discard = paramBean.getDiscard();
        InFlowEvent maxInFlow = paramBean.getMaxInFlow();
        DiscardFlowEvent maxDiscard = paramBean.getMaxDiscard();
        int type = stream.readUnsignedByte();
        int state = stream.readUnsignedByte();
        int length = stream.readUnsignedShort();
        block0 : switch (type) {
            case 0: {
                int[] params;
                if (state == 3 || state == 2) {
                    params = new int[]{state, length};
                    this.parseFlowEvent(params, stream, suit, maxInFlow, maxDiscard);
                }
                if (state == 4) {
                    this.parseReboundFlowEvent(length, stream, suit, discard);
                }
                if (state != 1 && state != 0) break;
                params = new int[]{state, length};
                this.parseFlowEvent(params, stream, suit, inFlow, discard);
                break;
            }
            case 1: {
                int[] params;
                if (state == 3 || state == 2) {
                    params = new int[]{state, length};
                    this.parseExpandEvent(params, stream, suit, maxInFlow, maxDiscard);
                }
                if (state == 4) {
                    this.parseReboundExpandEvent(length, stream, suit, discard);
                }
                if (state != 1 && state != 0) break;
                params = new int[]{state, length};
                this.parseExpandEvent(params, stream, suit, inFlow, discard);
                break;
            }
            case 2: {
                if (length != 12) {
                    throw new IOException("flow app format error ,length is " + length);
                }
                boolean isMaxEvent = state == 2 || state == 3;
                int protocol = stream.readUnsignedByte();
                int subType = stream.readUnsignedByte();
                int port = stream.readUnsignedShort();
                long inPps = stream.readUnsignedInt();
                long inKbps = stream.readUnsignedInt();
                if (subType == 0) {
                    long bizId = this.getUserDefBizId(suit, EventUtil.getCustomProtocolStr(protocol), port);
                    switch (protocol) {
                        case 1: {
                            TcpBizFlowEvent tcpBizFlow = new TcpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = tcpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            tcpBizFlow.setIdentifer(identifer);
                            tcpBizFlow.setNeedSum(false);
                            if (state == 0 || state == 2) {
                                tcpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                tcpBizFlow.setDropFlow(true);
                            }
                            tcpBizFlow.setMaxEvent(isMaxEvent);
                            this.handleTcpApp(tcpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(tcpBizFlow);
                            break;
                        }
                        case 2: {
                            UdpBizFlowEvent udpBizFlow = new UdpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = udpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            udpBizFlow.setIdentifer(identifer);
                            udpBizFlow.setNeedSum(false);
                            if (state == 0 || state == 2) {
                                udpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                udpBizFlow.setDropFlow(true);
                            }
                            udpBizFlow.setMaxEvent(isMaxEvent);
                            this.handleUdpApp(udpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(udpBizFlow);
                            break;
                        }
                        case 3: {
                            HttpBizFlowEvent httpBizFlow = new HttpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = httpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            httpBizFlow.setIdentifer(identifer);
                            httpBizFlow.setNeedSum(false);
                            if (state == 0 || state == 2) {
                                httpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                httpBizFlow.setDropFlow(true);
                            }
                            httpBizFlow.setMaxEvent(isMaxEvent);
                            this.handleHttpApp(httpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(httpBizFlow);
                            break;
                        }
                    }
                    break;
                }
                switch (state) {
                    case 0: {
                        this.handleFixApp(subType, inPps, inKbps, inFlow);
                        suit.setInFlowEvent(inFlow);
                        break block0;
                    }
                    case 2: {
                        this.handleFixApp(subType, inPps, inKbps, maxInFlow);
                        suit.setMaxInFlowEvent(maxInFlow);
                        break block0;
                    }
                    case 1: {
                        this.handleFixApp(subType, inPps, inKbps, discard);
                        suit.setDiscardFlowEvent(discard);
                        break block0;
                    }
                    case 3: {
                        this.handleFixApp(subType, inPps, inKbps, maxDiscard);
                        suit.setMaxDiscardFlowEvent(maxDiscard);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                if (length != 36) {
                    throw new IOException("flow con format error ,length is " + length);
                }
                if (inFlow.getIdentifier().isDesZone() || inFlow.getIdentifier().isIpLocation()) {
                    if (stream.skip(36L) == 36L) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                if (state == 2 || state == 3) {
                    this.readBasicConEvent(stream, maxInFlow, state);
                    suit.setMaxInFlowEvent(maxInFlow);
                    break;
                }
                this.readBasicConEvent(stream, inFlow, state);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 4: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 16L : 40L) == (long)(state == 4 ? 16 : 40)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                TcpBizFlowEvent tcpBizFlow = (TcpBizFlowEvent)suit.queryServiceEvent(TcpBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    tcpBizFlow.setSynReboundPps(stream.readUnsignedInt());
                    tcpBizFlow.setSynAckReboundPps(stream.readUnsignedInt());
                    tcpBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    tcpBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                    break;
                }
                this.readTcpBizEvent(stream, tcpBizFlow);
                break;
            }
            case 5: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 8L : 24L) == (long)(state == 4 ? 8 : 24)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                UdpBizFlowEvent udpBizFlow = (UdpBizFlowEvent)suit.queryServiceEvent(UdpBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    udpBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    udpBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                    break;
                }
                this.readUdpBizEvent(stream, udpBizFlow);
                break;
            }
            case 6: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 24L : 44L) == (long)(state == 4 ? 24 : 44)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                HttpBizFlowEvent httpBizFlow = (HttpBizFlowEvent)suit.queryServiceEvent(HttpBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    httpBizFlow.setSynReboundPps(stream.readUnsignedInt());
                    httpBizFlow.setSynAckReboundPps(stream.readUnsignedInt());
                    httpBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    httpBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                    httpBizFlow.setReboundGetPps(stream.readUnsignedInt());
                    httpBizFlow.setReboundPostPps(stream.readUnsignedInt());
                    break;
                }
                this.readHttpBizEvent(stream, httpBizFlow);
                break;
            }
            case 7: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 16L : 36L) == (long)(state == 4 ? 16 : 36)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                HttpsBizFlowEvent httpsBizFlow = (HttpsBizFlowEvent)suit.queryServiceEvent(HttpsBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    httpsBizFlow.setSynReboundPps(stream.readUnsignedInt());
                    httpsBizFlow.setSynAckReboundPps(stream.readUnsignedInt());
                    httpsBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    httpsBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                    break;
                }
                this.readHttpsBizEvent(stream, httpsBizFlow);
                break;
            }
            case 8: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 16L : 40L) == (long)(state == 4 ? 16 : 40)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                TcpDnsBizFlowEvent tcpDnsBizFlow = (TcpDnsBizFlowEvent)suit.queryServiceEvent(TcpDnsBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    tcpDnsBizFlow.setSynReboundPps(stream.readUnsignedInt());
                    tcpDnsBizFlow.setSynAckReboundPps(stream.readUnsignedInt());
                    tcpDnsBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    tcpDnsBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                } else {
                    this.readTcpDnsBizEvent(stream, tcpDnsBizFlow);
                }
                if (!tcpDnsBizFlow.getIdentifier().getIsDefaultBiz().booleanValue()) break;
                tcpDnsBizFlow.setNeedSum(false);
                break;
            }
            case 9: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 16L : 112L) == (long)(state == 4 ? 16 : 112)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                UdpDnsBizFlowEvent udpDnsBizFlow = (UdpDnsBizFlowEvent)suit.queryServiceEvent(UdpDnsBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    udpDnsBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    udpDnsBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                    udpDnsBizFlow.setDnsQueryReboundPps(stream.readUnsignedInt());
                    udpDnsBizFlow.setDnsReplyReboundPps(stream.readUnsignedInt());
                } else {
                    ArrayList<UdpDnsUserDefTypeEvent> udpDnsTypeFlow = new ArrayList<UdpDnsUserDefTypeEvent>();
                    this.readUdpDnsBizEvent(stream, udpDnsBizFlow, udpDnsTypeFlow, suit, state);
                    suit.addDnsTypeEvents(udpDnsTypeFlow);
                }
                if (!udpDnsBizFlow.getIdentifier().getIsDefaultBiz().booleanValue()) break;
                udpDnsBizFlow.setNeedSum(false);
                break;
            }
            case 10: {
                boolean isDropFlow;
                boolean isMaxEvent = state == 2 || state == 3;
                boolean bl = isDropFlow = state == 1 || state == 3 || state == 4;
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1) {
                    if (stream.skip(state == 4 ? 8L : 24L) == (long)(state == 4 ? 8 : 24)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                SipBizFlowEvent sipBizFlow = (SipBizFlowEvent)suit.queryServiceEvent(SipBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    sipBizFlow.setTotalReboundPps(stream.readUnsignedInt());
                    sipBizFlow.setTotalReboundKbps(stream.readUnsignedInt());
                    break;
                }
                this.readSipBizEvent(stream, sipBizFlow);
                break;
            }
            case 11: {
                InterfaceFlowEvent interfaceFlow = new InterfaceFlowEvent(suit.getIdentifier());
                this.readInterfaceEvent(stream, interfaceFlow);
                break;
            }
            case 12: {
                boolean isMaxEvent;
                OtherBizFlowEvent otherBizFlow = new OtherBizFlowEvent(suit.getIdentifier());
                boolean bl = isMaxEvent = state == 2 || state == 3;
                if (state == 0 || state == 2) {
                    otherBizFlow.setDropFlow(false);
                } else {
                    if (otherBizFlow.getDeviceType() == 1) {
                        if (stream.read(new byte[24]) == 24) break;
                        LOGGER.error((Object)"stream read error");
                        break;
                    }
                    otherBizFlow.setDropFlow(true);
                }
                otherBizFlow.setMaxEvent(isMaxEvent);
                this.readOtherBizEvent(stream, otherBizFlow);
                suit.addServiceEvents(otherBizFlow);
                break;
            }
            default: {
                throw new IOException("error flow type :" + type);
            }
        }
    }

    private void handleFixApp(int subType, long inPps, long inKbps, FlowEvent flowEvent) {
        switch (subType) {
            case 1: {
                flowEvent.setHttpsPps(inPps);
                flowEvent.setHttpsKbps(inKbps);
                break;
            }
            case 2: 
            case 3: {
                flowEvent.setHttpPps(inPps);
                flowEvent.setHttpKbps(inKbps);
                break;
            }
            case 4: {
                flowEvent.setDnsRequestPps(inPps);
                flowEvent.setDnsRequestKbps(inKbps);
                break;
            }
            case 5: {
                flowEvent.setDnsReplyPps(inPps);
                flowEvent.setDnsReplyKbps(inKbps);
                break;
            }
            case 6: {
                flowEvent.setSipInvitePps(inPps);
                flowEvent.setSipInviteKbps(inKbps);
                break;
            }
            case 8: {
                flowEvent.setHttpGetPps(inPps);
                break;
            }
        }
    }

    private long getUserDefBizId(IpSuitEvent suit, String protcolStr, int port) {
        long bizId = -1L;
        try {
            String deviceIp = suit.getIdentifier().getDeviceIp();
            bizId = FoundIDUtil.getInstance().getBizId(suit.getIdentifier().getZoneId(), protcolStr, port, deviceIp);
            LOGGER.info((Object)("deviceIp is: " + deviceIp + ";protocol is : " + this.getcleanedMessage(protcolStr) + ";port is : " + port + ";bizId is : " + bizId));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get biz id error", (Throwable)e);
        }
        return bizId;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void readUdpBizEvent(UnsignedDataInputStream stream, UdpBizFlowEvent udpBizFlow) throws IOException {
        udpBizFlow.setTotalPps(stream.readUnsignedInt());
        udpBizFlow.setTotalKbps(stream.readUnsignedInt());
        udpBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        udpBizFlow.setCurConPps(stream.readUnsignedInt());
        udpBizFlow.setSpecialPps(stream.readUnsignedInt());
        udpBizFlow.setSpecialKbps(stream.readUnsignedInt());
    }

    private void readOtherBizEvent(UnsignedDataInputStream stream, OtherBizFlowEvent otherBizFlow) throws IOException {
        otherBizFlow.setTotalPps(stream.readUnsignedInt());
        otherBizFlow.setTotalKbps(stream.readUnsignedInt());
    }

    private void readInterfaceEvent(UnsignedDataInputStream stream, InterfaceFlowEvent interfaceFlow) throws IOException {
        interfaceFlow.setSynPps(stream.readUnsignedInt());
        interfaceFlow.setSynAckPps(stream.readUnsignedInt());
        interfaceFlow.setAckPps(stream.readUnsignedInt());
        interfaceFlow.setFinRstPps(stream.readUnsignedInt());
        interfaceFlow.setTcpPps(stream.readUnsignedInt());
        interfaceFlow.setTcpKbps(stream.readUnsignedInt());
        interfaceFlow.setGetPps(stream.readUnsignedInt());
        interfaceFlow.setPostPps(stream.readUnsignedInt());
        interfaceFlow.setRequestPps(stream.readUnsignedInt());
        interfaceFlow.setReplyPps(stream.readUnsignedInt());
        interfaceFlow.setUdpPps(stream.readUnsignedInt());
        interfaceFlow.setUdpKbps(stream.readUnsignedInt());
        interfaceFlow.setIcmpPps(stream.readUnsignedInt());
        interfaceFlow.setIcmpKbps(stream.readUnsignedInt());
        interfaceFlow.setOtherPps(stream.readUnsignedInt());
        interfaceFlow.setOtherKbps(stream.readUnsignedInt());
        interfaceFlow.setIpv6Pps(stream.readUnsignedInt());
        interfaceFlow.setIpv6Kbps(stream.readUnsignedInt());
    }

    private void readSipBizEvent(UnsignedDataInputStream stream, SipBizFlowEvent sipBizFlow) throws IOException {
        sipBizFlow.setTotalPps(stream.readUnsignedInt());
        sipBizFlow.setTotalKbps(stream.readUnsignedInt());
        sipBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        sipBizFlow.setCurConPps(stream.readUnsignedInt());
        sipBizFlow.setInvitePps(stream.readUnsignedInt());
        sipBizFlow.setReplyPps(stream.readUnsignedInt());
    }

    private void readUdpDnsBizEvent(UnsignedDataInputStream stream, UdpDnsBizFlowEvent udpDnsBizFlow, List<UdpDnsUserDefTypeEvent> typeList, IpSuitEvent suit, int state) throws IOException {
        udpDnsBizFlow.setTotalPps(stream.readUnsignedInt());
        udpDnsBizFlow.setTotalKbps(stream.readUnsignedInt());
        udpDnsBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        udpDnsBizFlow.setCurConPps(stream.readUnsignedInt());
        udpDnsBizFlow.setRequestPps(stream.readUnsignedInt());
        udpDnsBizFlow.setReplyPps(stream.readUnsignedInt());
        udpDnsBizFlow.setDisSendReplyPps(stream.readUnsignedInt());
        udpDnsBizFlow.setaRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setPtrRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setNsRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setMxRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setTxtRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setCnnameRequestPps(stream.readUnsignedInt());
        udpDnsBizFlow.setSoaRequestPps(stream.readUnsignedInt());
        udpDnsBizFlow.setAaaaRequstPps(stream.readUnsignedInt());
        UdpDnsUserDefTypeEvent dnsTypeEvent1 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent1.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent2 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent2.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent3 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent3.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent4 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent4.setNeedSum(false);
        if (state == 0) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent1.setDnsValue(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsValue(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsValue(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsValue(stream.readUnsignedInt());
        } else if (state == 2) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent1.setDnsMaxValue(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsMaxValue(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsMaxValue(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsMaxValue(stream.readUnsignedInt());
        } else if (state == 3) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent1.setDnsDropMaxValue(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsDropMaxValue(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsDropMaxValue(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsDropMaxValue(stream.readUnsignedInt());
        } else {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent1.setDnsDropValue(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent2.setDnsDropValue(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent3.setDnsDropValue(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedInt());
            dnsTypeEvent4.setDnsDropValue(stream.readUnsignedInt());
        }
        if (dnsTypeEvent1.isValid()) {
            typeList.add(dnsTypeEvent1);
        }
        if (dnsTypeEvent2.isValid()) {
            typeList.add(dnsTypeEvent2);
        }
        if (dnsTypeEvent3.isValid()) {
            typeList.add(dnsTypeEvent3);
        }
        if (dnsTypeEvent4.isValid()) {
            typeList.add(dnsTypeEvent4);
        }
        udpDnsBizFlow.setOtherRequsetPps(stream.readUnsignedInt());
        udpDnsBizFlow.setFragPps(stream.readUnsignedInt());
        udpDnsBizFlow.setLargePps(stream.readUnsignedInt());
        udpDnsBizFlow.setiLegalPps(stream.readUnsignedInt());
        udpDnsBizFlow.setTtlDeniedPps(stream.readUnsignedInt());
    }

    private void readTcpDnsBizEvent(UnsignedDataInputStream stream, TcpDnsBizFlowEvent tcpDnsBizFlow) throws IOException {
        tcpDnsBizFlow.setSynPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setSynAckPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setAckPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setFinRstPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setTotalPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setTotalKbps(stream.readUnsignedInt());
        tcpDnsBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setCurConPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setSpecialPps(stream.readUnsignedInt());
        tcpDnsBizFlow.setSpecialKbps(stream.readUnsignedInt());
    }

    private void readHttpsBizEvent(UnsignedDataInputStream stream, HttpsBizFlowEvent httpsBizFlow) throws IOException {
        httpsBizFlow.setSynPps(stream.readUnsignedInt());
        httpsBizFlow.setSynAckPps(stream.readUnsignedInt());
        httpsBizFlow.setAckPps(stream.readUnsignedInt());
        httpsBizFlow.setFinRstPps(stream.readUnsignedInt());
        httpsBizFlow.setTotalPps(stream.readUnsignedInt());
        httpsBizFlow.setTotalKbps(stream.readUnsignedInt());
        httpsBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        httpsBizFlow.setCurConPps(stream.readUnsignedInt());
        httpsBizFlow.setHelloPps(stream.readUnsignedInt());
    }

    private void readHttpBizEvent(UnsignedDataInputStream stream, HttpBizFlowEvent httpBizFlow) throws IOException {
        httpBizFlow.setSynPps(stream.readUnsignedInt());
        httpBizFlow.setSynAckPps(stream.readUnsignedInt());
        httpBizFlow.setAckPps(stream.readUnsignedInt());
        httpBizFlow.setFinRstPps(stream.readUnsignedInt());
        httpBizFlow.setTotalPps(stream.readUnsignedInt());
        httpBizFlow.setTotalKbps(stream.readUnsignedInt());
        httpBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        httpBizFlow.setCurConPps(stream.readUnsignedInt());
        httpBizFlow.setGetPps(stream.readUnsignedInt());
        httpBizFlow.setPostPps(stream.readUnsignedInt());
        httpBizFlow.setHostPps(stream.readUnsignedInt());
    }

    private void readTcpBizEvent(UnsignedDataInputStream stream, TcpBizFlowEvent tcpBizFlow) throws IOException {
        tcpBizFlow.setSynPps(stream.readUnsignedInt());
        tcpBizFlow.setSynAckPps(stream.readUnsignedInt());
        tcpBizFlow.setAckPps(stream.readUnsignedInt());
        tcpBizFlow.setFinRstPps(stream.readUnsignedInt());
        tcpBizFlow.setTotalPps(stream.readUnsignedInt());
        tcpBizFlow.setTotalKbps(stream.readUnsignedInt());
        tcpBizFlow.setIncreaseConPps(stream.readUnsignedInt());
        tcpBizFlow.setCurConPps(stream.readUnsignedInt());
        tcpBizFlow.setSpecialPps(stream.readUnsignedInt());
        tcpBizFlow.setSpecialKbps(stream.readUnsignedInt());
    }

    private void readBasicFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setTcpPps(stream.readUnsignedInt());
        flowEvent.setTcpKbps(stream.readUnsignedInt());
        flowEvent.setTcpFragPps(stream.readUnsignedInt());
        flowEvent.setTcpFragKbps(stream.readUnsignedInt());
        flowEvent.setUdpPps(stream.readUnsignedInt());
        flowEvent.setUdpKbps(stream.readUnsignedInt());
        flowEvent.setUdpFragPps(stream.readUnsignedInt());
        flowEvent.setUdpFragKbps(stream.readUnsignedInt());
        flowEvent.setIcmpPps(stream.readUnsignedInt());
        flowEvent.setIcmpKbps(stream.readUnsignedInt());
        flowEvent.setOtherPps(stream.readUnsignedInt());
        flowEvent.setOtherKbps(stream.readUnsignedInt());
        flowEvent.caculateTotal();
    }

    private void readBasicConEvent(UnsignedDataInputStream stream, InFlowEvent flowEvent, int state) throws IOException {
        flowEvent.setTcpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setUdpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setIcmpIncreaseCon(stream.readUnsignedInt());
        flowEvent.setOtherIncreaseCon(stream.readUnsignedInt());
        flowEvent.setTcpConcurCon(stream.readUnsignedInt());
        flowEvent.setUdpConcurCon(stream.readUnsignedInt());
        flowEvent.setIcmpConcurCon(stream.readUnsignedInt());
        flowEvent.setOtherConcurCon(stream.readUnsignedInt());
        int url = (int)stream.readUnsignedInt();
        if (state == 0 || state == 2) {
            flowEvent.setUrl(url);
        }
    }

    private void readTcpExpandFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setSynPps(stream.readUnsignedInt());
        flowEvent.setSynAckPps(stream.readUnsignedInt());
        flowEvent.setAckPps(stream.readUnsignedInt());
        flowEvent.setFinRstPps(stream.readUnsignedInt());
    }
}

