/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.HttpBizFlowEvent;
import com.hs.atic.collector.entity.event.HttpsBizFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.InterfaceFlowEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.SipBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.manager.mbean.FlowEventParserParamBean;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FlowEventParserV7
implements EventDataParser {
    private static final int TCP = 1;
    private static final int UDP = 2;
    private static final int HTTP = 3;
    private static final int BASIC = 0;
    private static final int EXPAND = 1;
    private static final int APPLAYER = 2;
    private static final int CON = 3;
    private static final int TCP_BIZ = 4;
    private static final int UDP_BIZ = 5;
    private static final int HTTP_BIZ = 6;
    private static final int HTTPS_BIZ = 7;
    private static final int TCP_DNS_BIZ = 8;
    private static final int UDP_DNS_BIZ = 9;
    private static final int SIP_BIZ = 10;
    private static final int INTERFACE = 11;
    private static final int OTHER_BIZ = 12;
    private static final int DEVICE_BIZ = 14;
    private static final int BASELINE_BIZ = 15;
    private static final int FLOW = 0;
    private static final int NORMAL = 0;
    private static final int DROP = 1;
    private static final int MAX_NORMAL = 2;
    private static final int MAX_DROP = 3;
    private static final int REBOUND_FLOW = 4;
    private static final int MAX_FORWARD = 5;
    private static final int MAX_REBOUND = 6;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int USER_DEF = 0;
    private static final int HTTPS = 1;
    private static final int HTTP_APP = 2;
    private static final int HTTP_POST = 3;
    private static final int DNS_REQUEST = 4;
    private static final int DNS_REPLY = 5;
    private static final int SIP = 6;
    private static final int HTTP_GET = 8;
    private static final int SIP_INVITE = 9;
    private static final long ILLEGALBIZID = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 0) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                DiscardFlowEvent discard = new DiscardFlowEvent(event.getIdentifier());
                InFlowEvent inFlow = new InFlowEvent(event.getIdentifier());
                DiscardFlowEvent maxDiscard = new DiscardFlowEvent(event.getIdentifier());
                maxDiscard.setMaxEvent(true);
                InFlowEvent maxInFlow = new InFlowEvent(event.getIdentifier());
                maxInFlow.setMaxEvent(true);
                ForwardFlowEvent maxForwardFlow = new ForwardFlowEvent(event.getIdentifier());
                maxForwardFlow.setMaxEvent(true);
                FlowEventParserParamBean paramBean = new FlowEventParserParamBean();
                paramBean.setStream((UnsignedDataInputStream)stream);
                paramBean.setSuit(event);
                paramBean.setInFlow(inFlow);
                paramBean.setDiscard(discard);
                paramBean.setMaxInFlow(maxInFlow);
                paramBean.setMaxDiscard(maxDiscard);
                paramBean.setMaxForwardFlow(maxForwardFlow);
                for (int i = 0; i < number; ++i) {
                    this.parse(paramBean);
                }
                if (event.isFlowOverMax()) {
                    LOGGER.info((Object)("The event flow is bigger than " + CommonUtil.getAticFlowMaxNum() + ", the recive device data=" + CommonUtil.getByteArrayStr(data)));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void handleHttpApp(HttpBizFlowEvent httpBizFlow, long inPps, long inKbps) {
        httpBizFlow.setTotalKbps(inKbps);
        httpBizFlow.setTotalPps(inPps);
    }

    private void handleTcpApp(TcpBizFlowEvent tcpBizFlow, long inPps, long inKbps) {
        tcpBizFlow.setTotalKbps(inKbps);
        tcpBizFlow.setTotalPps(inPps);
    }

    private void handleUdpApp(UdpBizFlowEvent udpBizFlow, long inPps, long inKbps) {
        udpBizFlow.setTotalKbps(inKbps);
        udpBizFlow.setTotalPps(inPps);
    }

    private void parseReboundFlowEvent(int length, UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        if (length != 32) {
            throw new IOException("flow baise format error ,length is " + length);
        }
        discard.setTcpReboundPps(stream.readUnsignedLong());
        discard.setTcpReboundKbps(stream.readUnsignedLong());
        discard.setUdpReboundPps(stream.readUnsignedLong());
        discard.setUdpReboundKbps(stream.readUnsignedLong());
        discard.caculateReboundTotal();
        suit.setDiscardFlowEvent(discard);
    }

    private void parseFlowEvent(int[] params, UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow, DiscardFlowEvent discard) throws IOException {
        int state = params[0];
        int length = params[1];
        if (length != 112) {
            LOGGER.error((Object)("parse flow baise format error ,length is " + length));
            throw new IOException("flow baise format error ,length is " + length);
        }
        switch (state) {
            case 0: {
                this.readBasicFlowEvent(stream, inFlow);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 2: {
                this.readBasicFlowEvent(stream, inFlow);
                suit.setMaxInFlowEvent(inFlow);
                break;
            }
            case 1: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[96]) == 96) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readBasicFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 3: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[96]) == 96) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readBasicFlowEvent(stream, discard);
                suit.setMaxDiscardFlowEvent(discard);
                break;
            }
            default: {
                if (stream.read(new byte[96]) == 96) break;
                LOGGER.error((Object)"stream read error");
            }
        }
    }

    private void parseReboundExpandEvent(int length, UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        if (length != 16) {
            throw new IOException("flow expand format error ,length is " + length);
        }
        discard.setSynReboundPps(stream.readUnsignedLong());
        discard.setSynAckReboundPps(stream.readUnsignedLong());
        suit.setDiscardFlowEvent(discard);
    }

    private void parseExpandEvent(int[] params, UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow, DiscardFlowEvent discard) throws IOException {
        int state = params[0];
        int length = params[1];
        if (length != 32) {
            throw new IOException("flow expand format error ,length is " + length);
        }
        switch (state) {
            case 0: {
                this.readTcpExpandFlowEvent(stream, inFlow);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 2: {
                this.readTcpExpandFlowEvent(stream, inFlow);
                suit.setMaxInFlowEvent(inFlow);
                break;
            }
            case 1: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[32]) == 32) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readTcpExpandFlowEvent(stream, discard);
                suit.setDiscardFlowEvent(discard);
                break;
            }
            case 3: {
                if (discard.getDeviceType() == 1) {
                    if (stream.read(new byte[32]) == 32) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                this.readTcpExpandFlowEvent(stream, discard);
                suit.setMaxDiscardFlowEvent(discard);
                break;
            }
            default: {
                if (stream.read(new byte[32]) == 32) break;
                LOGGER.error((Object)"stream read error");
            }
        }
    }

    private void parse(FlowEventParserParamBean paramBean) throws IOException {
        UnsignedDataInputStream stream = paramBean.getStream();
        IpSuitEvent suit = paramBean.getSuit();
        InFlowEvent inFlow = paramBean.getInFlow();
        DiscardFlowEvent discard = paramBean.getDiscard();
        InFlowEvent maxInFlow = paramBean.getMaxInFlow();
        DiscardFlowEvent maxDiscard = paramBean.getMaxDiscard();
        ForwardFlowEvent maxForwardFlow = paramBean.getMaxForwardFlow();
        int type = stream.readUnsignedByte();
        int state = stream.readUnsignedByte();
        int length = stream.readUnsignedShort();
        boolean isMaxEvent = state == 2 || state == 3;
        boolean isDropFlow = state == 1 || state == 3 || state == 4;
        block0 : switch (type) {
            case 0: {
                int[] params;
                if (state == 3 || state == 2) {
                    params = new int[]{state, length};
                    this.parseFlowEvent(params, stream, suit, maxInFlow, maxDiscard);
                }
                if (state == 4) {
                    this.parseReboundFlowEvent(length, stream, suit, discard);
                }
                if (state == 1 || state == 0) {
                    params = new int[]{state, length};
                    this.parseFlowEvent(params, stream, suit, inFlow, discard);
                }
                if (5 != state) break;
                this.readBasicFlowEvent(stream, maxForwardFlow);
                suit.setMaxForwardFlowEvent(maxForwardFlow);
                break;
            }
            case 1: {
                int[] params;
                if (state == 3 || state == 2) {
                    params = new int[]{state, length};
                    this.parseExpandEvent(params, stream, suit, maxInFlow, maxDiscard);
                }
                if (state == 4) {
                    this.parseReboundExpandEvent(length, stream, suit, discard);
                }
                if (state == 1 || state == 0) {
                    params = new int[]{state, length};
                    this.parseExpandEvent(params, stream, suit, inFlow, discard);
                }
                if (5 != state) break;
                this.readTcpExpandFlowEvent(stream, maxForwardFlow);
                suit.setMaxForwardFlowEvent(maxForwardFlow);
                break;
            }
            case 2: {
                if (length != 24) {
                    throw new IOException("flow app format error ,length is " + length);
                }
                int protocol = stream.readUnsignedByte();
                int subType = stream.readUnsignedByte();
                int port = stream.readUnsignedShort();
                stream.readUnsignedInt();
                long inPps = stream.readUnsignedLong();
                long inKbps = stream.readUnsignedLong();
                if (subType == 0) {
                    long bizId = this.getUserDefBizId(suit, EventUtil.getCustomProtocolStr(protocol), port);
                    switch (protocol) {
                        case 1: {
                            TcpBizFlowEvent tcpBizFlow = new TcpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = tcpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            tcpBizFlow.setIdentifer(identifer);
                            tcpBizFlow.setNeedSum(false);
                            if (state == 0 || state == 2) {
                                tcpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                tcpBizFlow.setDropFlow(true);
                            }
                            tcpBizFlow.setMaxEvent(isMaxEvent);
                            this.handleTcpApp(tcpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(tcpBizFlow);
                            break;
                        }
                        case 2: {
                            UdpBizFlowEvent udpBizFlow = new UdpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = udpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            udpBizFlow.setIdentifer(identifer);
                            udpBizFlow.setNeedSum(false);
                            if (state == 0 || state == 2) {
                                udpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                udpBizFlow.setDropFlow(true);
                            }
                            udpBizFlow.setMaxEvent(isMaxEvent);
                            this.handleUdpApp(udpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(udpBizFlow);
                            break;
                        }
                        case 3: {
                            HttpBizFlowEvent httpBizFlow = new HttpBizFlowEvent(suit.getIdentifier());
                            EventIdentifier identifer = httpBizFlow.getIdentifierCopy();
                            identifer.setBizId(bizId);
                            httpBizFlow.setIdentifer(identifer);
                            httpBizFlow.setNeedSum(false);
                            if (state == 0 || state == 2) {
                                httpBizFlow.setDropFlow(false);
                            } else {
                                if (identifer.getDeviceType() == 1) break;
                                httpBizFlow.setDropFlow(true);
                            }
                            httpBizFlow.setMaxEvent(isMaxEvent);
                            this.handleHttpApp(httpBizFlow, inPps, inKbps);
                            suit.addServiceEvents(httpBizFlow);
                            break;
                        }
                    }
                    break;
                }
                switch (state) {
                    case 0: {
                        this.handleFixApp(subType, inPps, inKbps, inFlow);
                        suit.setInFlowEvent(inFlow);
                        break block0;
                    }
                    case 2: {
                        this.handleFixApp(subType, inPps, inKbps, maxInFlow);
                        suit.setMaxInFlowEvent(maxInFlow);
                        break block0;
                    }
                    case 1: {
                        this.handleFixApp(subType, inPps, inKbps, discard);
                        suit.setDiscardFlowEvent(discard);
                        break block0;
                    }
                    case 3: {
                        this.handleFixApp(subType, inPps, inKbps, maxDiscard);
                        suit.setMaxDiscardFlowEvent(maxDiscard);
                        break block0;
                    }
                    case 5: {
                        this.handleFixApp(subType, inPps, inKbps, maxForwardFlow);
                        suit.setMaxForwardFlowEvent(maxForwardFlow);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                if (length != 72) {
                    throw new IOException("flow con format error ,length is " + length);
                }
                if (inFlow.getIdentifier().isDesZone() || inFlow.getIdentifier().isIpLocation() || isDropFlow) {
                    if (stream.skip(72L) == 72L) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                if (state == 5) {
                    this.readBasicConEvent(stream, maxForwardFlow, state);
                    suit.setMaxForwardFlowEvent(maxForwardFlow);
                    break;
                }
                if (state == 2) {
                    this.readBasicConEvent(stream, maxInFlow, state);
                    suit.setMaxInFlowEvent(maxInFlow);
                    break;
                }
                this.readBasicConEvent(stream, inFlow, state);
                suit.setInFlowEvent(inFlow);
                break;
            }
            case 4: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 32L : 80L) == (long)(state == 4 ? 32 : 80)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                TcpBizFlowEvent tcpBizFlow = (TcpBizFlowEvent)suit.queryServiceEvent(TcpBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    tcpBizFlow.setSynReboundPps(stream.readUnsignedLong());
                    tcpBizFlow.setSynAckReboundPps(stream.readUnsignedLong());
                    tcpBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    tcpBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                    break;
                }
                this.readTcpBizEvent(stream, tcpBizFlow);
                break;
            }
            case 5: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 16L : 48L) == (long)(state == 4 ? 16 : 48)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                UdpBizFlowEvent udpBizFlow = (UdpBizFlowEvent)suit.queryServiceEvent(UdpBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    udpBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    udpBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                    break;
                }
                this.readUdpBizEvent(stream, udpBizFlow);
                break;
            }
            case 6: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 48L : 88L) == (long)(state == 4 ? 48 : 88)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                HttpBizFlowEvent httpBizFlow = (HttpBizFlowEvent)suit.queryServiceEvent(HttpBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    httpBizFlow.setSynReboundPps(stream.readUnsignedLong());
                    httpBizFlow.setSynAckReboundPps(stream.readUnsignedLong());
                    httpBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    httpBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                    httpBizFlow.setReboundGetPps(stream.readUnsignedLong());
                    httpBizFlow.setReboundPostPps(stream.readUnsignedLong());
                    break;
                }
                this.readHttpBizEvent(stream, httpBizFlow);
                break;
            }
            case 7: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 32L : 72L) == (long)(state == 4 ? 32 : 72)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                HttpsBizFlowEvent httpsBizFlow = (HttpsBizFlowEvent)suit.queryServiceEvent(HttpsBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    httpsBizFlow.setSynReboundPps(stream.readUnsignedLong());
                    httpsBizFlow.setSynAckReboundPps(stream.readUnsignedLong());
                    httpsBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    httpsBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                    break;
                }
                this.readHttpsBizEvent(stream, httpsBizFlow);
                break;
            }
            case 8: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 32L : 80L) == (long)(state == 4 ? 32 : 80)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                TcpDnsBizFlowEvent tcpDnsBizFlow = (TcpDnsBizFlowEvent)suit.queryServiceEvent(TcpDnsBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    tcpDnsBizFlow.setSynReboundPps(stream.readUnsignedLong());
                    tcpDnsBizFlow.setSynAckReboundPps(stream.readUnsignedLong());
                    tcpDnsBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    tcpDnsBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                } else {
                    this.readTcpDnsBizEvent(stream, tcpDnsBizFlow);
                }
                if (!tcpDnsBizFlow.getIdentifier().getIsDefaultBiz().booleanValue()) break;
                tcpDnsBizFlow.setNeedSum(false);
                break;
            }
            case 9: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 32L : 224L) == (long)(state == 4 ? 32 : 224)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                UdpDnsBizFlowEvent udpDnsBizFlow = (UdpDnsBizFlowEvent)suit.queryServiceEvent(UdpDnsBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    udpDnsBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    udpDnsBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                    udpDnsBizFlow.setDnsQueryReboundPps(stream.readUnsignedLong());
                    udpDnsBizFlow.setDnsReplyReboundPps(stream.readUnsignedLong());
                } else {
                    ArrayList<UdpDnsUserDefTypeEvent> udpDnsTypeFlow = new ArrayList<UdpDnsUserDefTypeEvent>();
                    this.readUdpDnsBizEvent(stream, udpDnsBizFlow, udpDnsTypeFlow, suit, state);
                    suit.addDnsTypeEvents(udpDnsTypeFlow);
                }
                if (!udpDnsBizFlow.getIdentifier().getIsDefaultBiz().booleanValue()) break;
                udpDnsBizFlow.setNeedSum(false);
                break;
            }
            case 10: {
                if (isDropFlow && suit.getIdentifier().getDeviceType() == 1 || 5 == state) {
                    if (stream.skip(state == 4 ? 16L : 48L) == (long)(state == 4 ? 16 : 48)) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                SipBizFlowEvent sipBizFlow = (SipBizFlowEvent)suit.queryServiceEvent(SipBizFlowEvent.class, isDropFlow, isMaxEvent, suit.getIdentifier().getBizId());
                if (state == 4) {
                    sipBizFlow.setTotalReboundPps(stream.readUnsignedLong());
                    sipBizFlow.setTotalReboundKbps(stream.readUnsignedLong());
                    break;
                }
                this.readSipBizEvent(stream, sipBizFlow);
                break;
            }
            case 11: {
                InterfaceFlowEvent interfaceFlow = new InterfaceFlowEvent(suit.getIdentifier());
                this.readInterfaceEvent(stream, interfaceFlow);
                break;
            }
            case 12: {
                OtherBizFlowEvent otherBizFlow = new OtherBizFlowEvent(suit.getIdentifier());
                if (state == 0 || state == 2) {
                    otherBizFlow.setDropFlow(false);
                } else {
                    if (otherBizFlow.getDeviceType() == 1 || 5 == state) {
                        if (stream.read(new byte[24]) == 24) break;
                        LOGGER.error((Object)"stream read error");
                        break;
                    }
                    otherBizFlow.setDropFlow(true);
                }
                otherBizFlow.setMaxEvent(isMaxEvent);
                this.readOtherBizEvent(stream, otherBizFlow);
                suit.addServiceEvents(otherBizFlow);
                break;
            }
            case 14: {
                if (length == 96) {
                    if (state == 0) {
                        this.readDevInFlowBizEvent(stream, suit, inFlow);
                        break;
                    }
                    if (state == 1) {
                        this.readDevDropFlowBizEvent(stream, suit, discard);
                        break;
                    }
                    if (state == 2) {
                        this.readDevMaxInFlowBizEvent(stream, suit, maxInFlow);
                        break;
                    }
                    if (state == 3) {
                        this.readDevMaxDropFlowBizEvent(stream, suit, maxDiscard);
                        break;
                    }
                    if (state == 4) {
                        this.readDevReboundFlowBizEvent(stream, suit, discard);
                        break;
                    }
                    if (state == 5) {
                        this.readDevMaxForwardFlowBizEvent(stream, suit, maxForwardFlow);
                        break;
                    }
                    if (state == 6) {
                        this.readDevMaxReboundFlowBizEvent(stream, suit, maxDiscard);
                        break;
                    }
                    if (stream.skip(96L) == 96L) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                throw new IOException("flow con format error ,length is " + length);
            }
            case 15: {
                if (length == 80) {
                    if (state == 2) {
                        this.readBaselineMaxInFlowBizEvent(stream, suit, maxInFlow);
                        break;
                    }
                    if (state == 5) {
                        this.readBaselineMaxForwardFlowBizEvent(stream, suit, maxForwardFlow);
                        break;
                    }
                    if (state == 0) {
                        this.readBaselineInFlowBizEvent(stream, suit, inFlow);
                        break;
                    }
                    if (stream.skip(80L) == 80L) break;
                    LOGGER.error((Object)"stream read error");
                    break;
                }
                throw new IOException("flow con format error ,length is " + length);
            }
            default: {
                throw new IOException("error flow type :" + type);
            }
        }
    }

    private void handleFixApp(int subType, long inPps, long inKbps, FlowEvent flowEvent) {
        switch (subType) {
            case 1: {
                flowEvent.setHttpsPps(inPps);
                flowEvent.setHttpsKbps(inKbps);
                break;
            }
            case 2: 
            case 3: {
                flowEvent.setHttpPps(inPps);
                flowEvent.setHttpKbps(inKbps);
                break;
            }
            case 4: {
                flowEvent.setDnsRequestPps(inPps);
                flowEvent.setDnsRequestKbps(inKbps);
                break;
            }
            case 5: {
                flowEvent.setDnsReplyPps(inPps);
                flowEvent.setDnsReplyKbps(inKbps);
                break;
            }
            case 6: {
                flowEvent.setSipInvitePps(inPps);
                flowEvent.setSipInviteKbps(inKbps);
                break;
            }
            case 8: {
                flowEvent.setHttpGetPps(inPps);
                break;
            }
            case 9: {
                flowEvent.setSipInviteQps(inPps);
                break;
            }
        }
    }

    private long getUserDefBizId(IpSuitEvent suit, String protcolStr, int port) {
        long bizId = -1L;
        try {
            String deviceIp = suit.getIdentifier().getDeviceIp();
            bizId = FoundIDUtil.getInstance().getBizId(suit.getIdentifier().getZoneId(), protcolStr, port, deviceIp);
            LOGGER.info((Object)("deviceIp is: " + deviceIp + ";protocol is : " + this.getcleanedMessage(protcolStr) + ";port is : " + port + ";bizId is : " + bizId));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get biz id error", (Throwable)e);
        }
        return bizId;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void readUdpBizEvent(UnsignedDataInputStream stream, UdpBizFlowEvent udpBizFlow) throws IOException {
        udpBizFlow.setTotalPps(stream.readUnsignedLong());
        udpBizFlow.setTotalKbps(stream.readUnsignedLong());
        udpBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        udpBizFlow.setCurConPps(stream.readUnsignedLong());
        udpBizFlow.setSpecialPps(stream.readUnsignedLong());
        udpBizFlow.setSpecialKbps(stream.readUnsignedLong());
    }

    private void readOtherBizEvent(UnsignedDataInputStream stream, OtherBizFlowEvent otherBizFlow) throws IOException {
        otherBizFlow.setTotalPps(stream.readUnsignedLong());
        otherBizFlow.setTotalKbps(stream.readUnsignedLong());
    }

    private void readDevInFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow) throws IOException {
        inFlow.setAllPps(stream.readUnsignedLong());
        inFlow.setAllKbps(stream.readUnsignedLong());
        inFlow.setTcpPps(stream.readUnsignedLong());
        inFlow.setTcpKbps(stream.readUnsignedLong());
        inFlow.setUdpPps(stream.readUnsignedLong());
        inFlow.setUdpKbps(stream.readUnsignedLong());
        inFlow.setIcmpPps(stream.readUnsignedLong());
        inFlow.setIcmpKbps(stream.readUnsignedLong());
        inFlow.setOtherPps(stream.readUnsignedLong());
        inFlow.setOtherKbps(stream.readUnsignedLong());
        inFlow.setTcpIncreaseCon(stream.readUnsignedLong());
        inFlow.setTcpConcurCon(stream.readUnsignedLong());
        suit.setInFlowEvent(inFlow);
    }

    private void readDevMaxInFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow) throws IOException {
        inFlow.setAllPps(stream.readUnsignedLong());
        inFlow.setAllKbps(stream.readUnsignedLong());
        inFlow.setTcpPps(stream.readUnsignedLong());
        inFlow.setTcpKbps(stream.readUnsignedLong());
        inFlow.setUdpPps(stream.readUnsignedLong());
        inFlow.setUdpKbps(stream.readUnsignedLong());
        inFlow.setIcmpPps(stream.readUnsignedLong());
        inFlow.setIcmpKbps(stream.readUnsignedLong());
        inFlow.setOtherPps(stream.readUnsignedLong());
        inFlow.setOtherKbps(stream.readUnsignedLong());
        inFlow.setTcpIncreaseCon(stream.readUnsignedLong());
        inFlow.setTcpConcurCon(stream.readUnsignedLong());
        suit.setMaxInFlowEvent(inFlow);
    }

    private void readDevMaxForwardFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, ForwardFlowEvent forwardFlow) throws IOException {
        forwardFlow.setAllPps(stream.readUnsignedLong());
        forwardFlow.setAllKbps(stream.readUnsignedLong());
        forwardFlow.setTcpPps(stream.readUnsignedLong());
        forwardFlow.setTcpKbps(stream.readUnsignedLong());
        forwardFlow.setUdpPps(stream.readUnsignedLong());
        forwardFlow.setUdpKbps(stream.readUnsignedLong());
        forwardFlow.setIcmpPps(stream.readUnsignedLong());
        forwardFlow.setIcmpKbps(stream.readUnsignedLong());
        forwardFlow.setOtherPps(stream.readUnsignedLong());
        forwardFlow.setOtherKbps(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setMaxForwardFlowEvent(forwardFlow);
    }

    private void readDevDropFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        discard.setAllPps(stream.readUnsignedLong());
        discard.setAllKbps(stream.readUnsignedLong());
        discard.setTcpPps(stream.readUnsignedLong());
        discard.setTcpKbps(stream.readUnsignedLong());
        discard.setUdpPps(stream.readUnsignedLong());
        discard.setUdpKbps(stream.readUnsignedLong());
        discard.setIcmpPps(stream.readUnsignedLong());
        discard.setIcmpKbps(stream.readUnsignedLong());
        discard.setOtherPps(stream.readUnsignedLong());
        discard.setOtherKbps(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setDiscardFlowEvent(discard);
    }

    private void readDevMaxDropFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        discard.setAllPps(stream.readUnsignedLong());
        discard.setAllKbps(stream.readUnsignedLong());
        discard.setTcpPps(stream.readUnsignedLong());
        discard.setTcpKbps(stream.readUnsignedLong());
        discard.setUdpPps(stream.readUnsignedLong());
        discard.setUdpKbps(stream.readUnsignedLong());
        discard.setIcmpPps(stream.readUnsignedLong());
        discard.setIcmpKbps(stream.readUnsignedLong());
        discard.setOtherPps(stream.readUnsignedLong());
        discard.setOtherKbps(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setMaxDiscardFlowEvent(discard);
    }

    private void readDevReboundFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        discard.setAllReboundPps(stream.readUnsignedLong());
        discard.setAllReboundKbps(stream.readUnsignedLong());
        discard.setTcpReboundPps(stream.readUnsignedLong());
        discard.setTcpReboundKbps(stream.readUnsignedLong());
        discard.setUdpReboundPps(stream.readUnsignedLong());
        discard.setUdpReboundKbps(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setDiscardFlowEvent(discard);
    }

    private void readDevMaxReboundFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, DiscardFlowEvent discard) throws IOException {
        discard.setAllReboundPps(stream.readUnsignedLong());
        discard.setAllReboundKbps(stream.readUnsignedLong());
        discard.setTcpReboundPps(stream.readUnsignedLong());
        discard.setTcpReboundKbps(stream.readUnsignedLong());
        discard.setUdpReboundPps(stream.readUnsignedLong());
        discard.setUdpReboundKbps(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setMaxDiscardFlowEvent(discard);
    }

    private void readBaselineMaxInFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent maxInFlow) throws IOException {
        maxInFlow.setTcpSrcIncreaseCon(stream.readUnsignedLong());
        maxInFlow.setTcpSrcConcurCon(stream.readUnsignedLong());
        maxInFlow.setTcpRatio(stream.readUnsignedLong());
        maxInFlow.setTcpL500Ratio(stream.readUnsignedLong());
        maxInFlow.setSynPktNum(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setMaxInFlowEvent(maxInFlow);
    }

    private void readBaselineMaxForwardFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, ForwardFlowEvent maxForwardFlow) throws IOException {
        maxForwardFlow.setTcpSrcIncreaseCon(stream.readUnsignedLong());
        maxForwardFlow.setTcpSrcConcurCon(stream.readUnsignedLong());
        maxForwardFlow.setTcpRatio(stream.readUnsignedLong());
        maxForwardFlow.setTcpL500Ratio(stream.readUnsignedLong());
        maxForwardFlow.setSynPktNum(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setMaxForwardFlowEvent(maxForwardFlow);
    }

    private void readBaselineInFlowBizEvent(UnsignedDataInputStream stream, IpSuitEvent suit, InFlowEvent inFlow) throws IOException {
        inFlow.setTcpSrcIncreaseCon(stream.readUnsignedLong());
        inFlow.setTcpSrcConcurCon(stream.readUnsignedLong());
        inFlow.setTcpRatio(stream.readUnsignedLong());
        inFlow.setTcpL500Ratio(stream.readUnsignedLong());
        inFlow.setSynPktNum(stream.readUnsignedLong());
        inFlow.setSrcAckKbps(stream.readUnsignedLong());
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        stream.readUnsignedLong();
        suit.setInFlowEvent(inFlow);
    }

    private void readInterfaceEvent(UnsignedDataInputStream stream, InterfaceFlowEvent interfaceFlow) throws IOException {
        interfaceFlow.setSynPps(stream.readUnsignedInt());
        interfaceFlow.setSynAckPps(stream.readUnsignedInt());
        interfaceFlow.setAckPps(stream.readUnsignedInt());
        interfaceFlow.setFinRstPps(stream.readUnsignedInt());
        interfaceFlow.setTcpPps(stream.readUnsignedInt());
        interfaceFlow.setTcpKbps(stream.readUnsignedInt());
        interfaceFlow.setGetPps(stream.readUnsignedInt());
        interfaceFlow.setPostPps(stream.readUnsignedInt());
        interfaceFlow.setRequestPps(stream.readUnsignedInt());
        interfaceFlow.setReplyPps(stream.readUnsignedInt());
        interfaceFlow.setUdpPps(stream.readUnsignedInt());
        interfaceFlow.setUdpKbps(stream.readUnsignedInt());
        interfaceFlow.setIcmpPps(stream.readUnsignedInt());
        interfaceFlow.setIcmpKbps(stream.readUnsignedInt());
        interfaceFlow.setOtherPps(stream.readUnsignedInt());
        interfaceFlow.setOtherKbps(stream.readUnsignedInt());
        interfaceFlow.setIpv6Pps(stream.readUnsignedInt());
        interfaceFlow.setIpv6Kbps(stream.readUnsignedInt());
    }

    private void readSipBizEvent(UnsignedDataInputStream stream, SipBizFlowEvent sipBizFlow) throws IOException {
        sipBizFlow.setTotalPps(stream.readUnsignedLong());
        sipBizFlow.setTotalKbps(stream.readUnsignedLong());
        sipBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        sipBizFlow.setCurConPps(stream.readUnsignedLong());
        sipBizFlow.setInvitePps(stream.readUnsignedLong());
        sipBizFlow.setReplyPps(stream.readUnsignedLong());
    }

    private void readUdpDnsBizEvent(UnsignedDataInputStream stream, UdpDnsBizFlowEvent udpDnsBizFlow, List<UdpDnsUserDefTypeEvent> typeList, IpSuitEvent suit, int state) throws IOException {
        udpDnsBizFlow.setTotalPps(stream.readUnsignedLong());
        udpDnsBizFlow.setTotalKbps(stream.readUnsignedLong());
        udpDnsBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        udpDnsBizFlow.setCurConPps(stream.readUnsignedLong());
        udpDnsBizFlow.setRequestPps(stream.readUnsignedLong());
        udpDnsBizFlow.setReplyPps(stream.readUnsignedLong());
        udpDnsBizFlow.setDisSendReplyPps(stream.readUnsignedLong());
        udpDnsBizFlow.setaRequsetPps(stream.readUnsignedLong());
        udpDnsBizFlow.setPtrRequsetPps(stream.readUnsignedLong());
        udpDnsBizFlow.setNsRequsetPps(stream.readUnsignedLong());
        udpDnsBizFlow.setMxRequsetPps(stream.readUnsignedLong());
        udpDnsBizFlow.setTxtRequsetPps(stream.readUnsignedLong());
        udpDnsBizFlow.setCnnameRequestPps(stream.readUnsignedLong());
        udpDnsBizFlow.setSoaRequestPps(stream.readUnsignedLong());
        udpDnsBizFlow.setAaaaRequstPps(stream.readUnsignedLong());
        UdpDnsUserDefTypeEvent dnsTypeEvent1 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent1.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent2 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent2.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent3 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent3.setNeedSum(false);
        UdpDnsUserDefTypeEvent dnsTypeEvent4 = new UdpDnsUserDefTypeEvent(suit.getIdentifier());
        dnsTypeEvent4.setNeedSum(false);
        if (state == 0) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent1.setDnsValue(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsValue(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsValue(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsValue(stream.readUnsignedLong());
        } else if (state == 2) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent1.setDnsMaxValue(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsMaxValue(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsMaxValue(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsMaxValue(stream.readUnsignedLong());
        } else if (state == 3) {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent1.setDnsDropMaxValue(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsDropMaxValue(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsDropMaxValue(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsDropMaxValue(stream.readUnsignedLong());
        } else {
            dnsTypeEvent1.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent1.setDnsDropValue(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent2.setDnsDropValue(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent3.setDnsDropValue(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsCode(stream.readUnsignedLong());
            dnsTypeEvent4.setDnsDropValue(stream.readUnsignedLong());
        }
        if (dnsTypeEvent1.isValid()) {
            typeList.add(dnsTypeEvent1);
        }
        if (dnsTypeEvent2.isValid()) {
            typeList.add(dnsTypeEvent2);
        }
        if (dnsTypeEvent3.isValid()) {
            typeList.add(dnsTypeEvent3);
        }
        if (dnsTypeEvent4.isValid()) {
            typeList.add(dnsTypeEvent4);
        }
        udpDnsBizFlow.setOtherRequsetPps(stream.readUnsignedLong());
        udpDnsBizFlow.setFragPps(stream.readUnsignedLong());
        udpDnsBizFlow.setLargePps(stream.readUnsignedLong());
        udpDnsBizFlow.setiLegalPps(stream.readUnsignedLong());
        udpDnsBizFlow.setTtlDeniedPps(stream.readUnsignedLong());
    }

    private void readTcpDnsBizEvent(UnsignedDataInputStream stream, TcpDnsBizFlowEvent tcpDnsBizFlow) throws IOException {
        tcpDnsBizFlow.setSynPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setSynAckPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setAckPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setFinRstPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setTotalPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setTotalKbps(stream.readUnsignedLong());
        tcpDnsBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setCurConPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setSpecialPps(stream.readUnsignedLong());
        tcpDnsBizFlow.setSpecialKbps(stream.readUnsignedLong());
    }

    private void readHttpsBizEvent(UnsignedDataInputStream stream, HttpsBizFlowEvent httpsBizFlow) throws IOException {
        httpsBizFlow.setSynPps(stream.readUnsignedLong());
        httpsBizFlow.setSynAckPps(stream.readUnsignedLong());
        httpsBizFlow.setAckPps(stream.readUnsignedLong());
        httpsBizFlow.setFinRstPps(stream.readUnsignedLong());
        httpsBizFlow.setTotalPps(stream.readUnsignedLong());
        httpsBizFlow.setTotalKbps(stream.readUnsignedLong());
        httpsBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        httpsBizFlow.setCurConPps(stream.readUnsignedLong());
        httpsBizFlow.setHelloPps(stream.readUnsignedLong());
    }

    private void readHttpBizEvent(UnsignedDataInputStream stream, HttpBizFlowEvent httpBizFlow) throws IOException {
        httpBizFlow.setSynPps(stream.readUnsignedLong());
        httpBizFlow.setSynAckPps(stream.readUnsignedLong());
        httpBizFlow.setAckPps(stream.readUnsignedLong());
        httpBizFlow.setFinRstPps(stream.readUnsignedLong());
        httpBizFlow.setTotalPps(stream.readUnsignedLong());
        httpBizFlow.setTotalKbps(stream.readUnsignedLong());
        httpBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        httpBizFlow.setCurConPps(stream.readUnsignedLong());
        httpBizFlow.setGetPps(stream.readUnsignedLong());
        httpBizFlow.setPostPps(stream.readUnsignedLong());
        httpBizFlow.setHostPps(stream.readUnsignedLong());
    }

    private void readTcpBizEvent(UnsignedDataInputStream stream, TcpBizFlowEvent tcpBizFlow) throws IOException {
        tcpBizFlow.setSynPps(stream.readUnsignedLong());
        tcpBizFlow.setSynAckPps(stream.readUnsignedLong());
        tcpBizFlow.setAckPps(stream.readUnsignedLong());
        tcpBizFlow.setFinRstPps(stream.readUnsignedLong());
        tcpBizFlow.setTotalPps(stream.readUnsignedLong());
        tcpBizFlow.setTotalKbps(stream.readUnsignedLong());
        tcpBizFlow.setIncreaseConPps(stream.readUnsignedLong());
        tcpBizFlow.setCurConPps(stream.readUnsignedLong());
        tcpBizFlow.setSpecialPps(stream.readUnsignedLong());
        tcpBizFlow.setSpecialKbps(stream.readUnsignedLong());
    }

    private void readBasicFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setTcpPps(stream.readUnsignedLong());
        flowEvent.setTcpKbps(stream.readUnsignedLong());
        flowEvent.setTcpFragPps(stream.readUnsignedLong());
        flowEvent.setTcpFragKbps(stream.readUnsignedLong());
        flowEvent.setUdpPps(stream.readUnsignedLong());
        flowEvent.setUdpKbps(stream.readUnsignedLong());
        flowEvent.setUdpFragPps(stream.readUnsignedLong());
        flowEvent.setUdpFragKbps(stream.readUnsignedLong());
        flowEvent.setIcmpPps(stream.readUnsignedLong());
        flowEvent.setIcmpKbps(stream.readUnsignedLong());
        flowEvent.setOtherPps(stream.readUnsignedLong());
        flowEvent.setOtherKbps(stream.readUnsignedLong());
        flowEvent.setAllPps(stream.readUnsignedLong());
        flowEvent.setAllKbps(stream.readUnsignedLong());
    }

    private void readBasicConEvent(UnsignedDataInputStream stream, InFlowEvent flowEvent, int state) throws IOException {
        flowEvent.setTcpIncreaseCon(stream.readUnsignedLong());
        flowEvent.setUdpIncreaseCon(stream.readUnsignedLong());
        flowEvent.setIcmpIncreaseCon(stream.readUnsignedLong());
        flowEvent.setOtherIncreaseCon(stream.readUnsignedLong());
        flowEvent.setTcpConcurCon(stream.readUnsignedLong());
        flowEvent.setUdpConcurCon(stream.readUnsignedLong());
        flowEvent.setIcmpConcurCon(stream.readUnsignedLong());
        flowEvent.setOtherConcurCon(stream.readUnsignedLong());
        long url = stream.readUnsignedLong();
        if (state == 0 || state == 2) {
            flowEvent.setUrl(url);
        }
    }

    private void readBasicConEvent(UnsignedDataInputStream stream, ForwardFlowEvent maxForwardFlow, int state) throws IOException {
        maxForwardFlow.setTcpIncreaseCon(stream.readUnsignedLong());
        maxForwardFlow.setUdpIncreaseCon(stream.readUnsignedLong());
        maxForwardFlow.setIcmpIncreaseCon(stream.readUnsignedLong());
        maxForwardFlow.setOtherIncreaseCon(stream.readUnsignedLong());
        maxForwardFlow.setTcpConcurCon(stream.readUnsignedLong());
        maxForwardFlow.setUdpConcurCon(stream.readUnsignedLong());
        maxForwardFlow.setIcmpConcurCon(stream.readUnsignedLong());
        maxForwardFlow.setOtherConcurCon(stream.readUnsignedLong());
        long url = stream.readUnsignedLong();
        maxForwardFlow.setUrl(url);
    }

    private void readTcpExpandFlowEvent(UnsignedDataInputStream stream, FlowEvent flowEvent) throws IOException {
        flowEvent.setSynPps(stream.readUnsignedLong());
        flowEvent.setSynAckPps(stream.readUnsignedLong());
        flowEvent.setAckPps(stream.readUnsignedLong());
        flowEvent.setFinRstPps(stream.readUnsignedLong());
    }
}

