/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.db.DefaultBizMappingRepository;
import com.hs.atic.collector.db.DefaultZoneMappingRepository;
import com.hs.atic.collector.db.UserDefBizMappingRepository;
import com.hs.atic.collector.db.daemon.RefeshDefBizIdThread;
import com.hs.atic.collector.db.daemon.RefeshUserDefBizIdThread;
import com.hs.atic.collector.db.daemon.RefeshZoneIdThread;
import com.hs.atic.collector.entity.BizInfoEntity;
import com.hs.atic.collector.entity.DefaultBizMappingEntity;
import com.hs.atic.collector.util.FilterNameUtil;
import com.hs.atic.collector.util.FoundDefaultIdService;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class FoundIDUtil {
    private static FoundIDUtil instance = new FoundIDUtil();
    private static final long RMI_DIFF = 15000L;
    private static final long INTERVAL = 1800000L;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final long DEFAULT_BIZ_ID = 0L;
    private static final int DEFAULT_ZONE_ID = 1;
    private Map<String, Long> devZoneCache = new HashMap<String, Long>();
    private Map<DefaultBizMappingEntity, Long> devBizCache = new HashMap<DefaultBizMappingEntity, Long>();
    private Map<BizInfoEntity, Long> bizInfoCache = new HashMap<BizInfoEntity, Long>();
    private DefaultZoneMappingRepository zoneMapping = new DefaultZoneMappingRepository();
    private DefaultBizMappingRepository bizMapping = new DefaultBizMappingRepository();
    private UserDefBizMappingRepository userDefMapping = new UserDefBizMappingRepository();
    private final FoundDefaultIdService queryService = new FoundDefaultIdService();
    private Set<String> notFoundDevice = Collections.synchronizedSet(new HashSet());
    private Set<DefaultBizMappingEntity> notFoundZone = new HashSet<DefaultBizMappingEntity>();
    private Set<BizInfoEntity> notFoundUserDefBiz = new HashSet<BizInfoEntity>();
    private long foundDefaultZoneLastTime = 0L;
    private long foudDefaultBizLastTime = 0L;
    private long foudUserDefineBizLastTime = 0L;

    private FoundIDUtil() {
        this.devZoneCache.putAll(this.zoneMapping.initCache());
        this.devBizCache.putAll(this.bizMapping.initCache());
        this.bizInfoCache.putAll(this.userDefMapping.initCache());
    }

    public static synchronized FoundIDUtil getInstance() {
        if (null == instance) {
            instance = new FoundIDUtil();
        }
        return instance;
    }

    public void initQuery() {
        this.refeshDefaultZoneData(this.queryService.queryDefaultZone());
        this.refeshDefaultBizData(this.queryService.queryDefaultBiz());
        this.refreshUserDefBizData(this.queryService.queryUserDefBiz());
        FilterNameUtil.getInstance().initAllFilgerNames();
    }

    private void queryAllDefaultZoneId(String devIp) {
        if (!this.notFoundDevice.contains(devIp) || System.currentTimeMillis() - this.foundDefaultZoneLastTime > 1800000L) {
            this.notFoundDevice.add(devIp);
            this.refeshDefaultZoneData(this.queryService.queryDefaultZone());
        }
    }

    public void refeshDefaultZoneTable(Map<String, Long> allDefZoneIds) {
        try {
            RefeshZoneIdThread refeshZoneId = new RefeshZoneIdThread(allDefZoneIds);
            Thread refeshZoneIdThread = new Thread((Runnable)refeshZoneId, "RefeshZoneIdThread");
            refeshZoneIdThread.start();
        }
        catch (Exception e) {
            LOGGER.error((Object)"RefeshZoneIdThread start failed ! Program exit !", (Throwable)e);
        }
    }

    public synchronized void refeshDefaultZoneData(Map<String, Long> allDefZoneIds) {
        if (null != allDefZoneIds) {
            this.devZoneCache.clear();
            this.devZoneCache.putAll(allDefZoneIds);
            if (System.currentTimeMillis() - this.foundDefaultZoneLastTime > 1800000L) {
                this.refeshDefaultZoneTable(allDefZoneIds);
            }
            this.notFoundDevice.removeAll(allDefZoneIds.keySet());
            this.foundDefaultZoneLastTime = System.currentTimeMillis();
        } else {
            this.foundDefaultZoneLastTime = System.currentTimeMillis() - 1800000L + 15000L;
            LOGGER.error((Object)"get allDefZoneIds is null !");
        }
    }

    public synchronized long getDefaultZoneIdByDevIp(String devIp) {
        if (!this.devZoneCache.containsKey(devIp)) {
            this.queryAllDefaultZoneId(devIp);
        }
        if (this.devZoneCache.containsKey(devIp)) {
            return this.devZoneCache.get(devIp);
        }
        LOGGER.info((Object)("not found the default zoneId of device Ip : " + devIp));
        return 1L;
    }

    public void refeshDefaultBizTable(Map<DefaultBizMappingEntity, Long> allDefBizIds) {
        try {
            RefeshDefBizIdThread refeshDefBizId = new RefeshDefBizIdThread(allDefBizIds);
            Thread refeshDefBizIdThread = new Thread((Runnable)refeshDefBizId, "RefeshDefBizIdThread");
            refeshDefBizIdThread.start();
        }
        catch (Exception e) {
            LOGGER.error((Object)"RefeshDefBizIdThread start failed ! Program exit !", (Throwable)e);
        }
    }

    public synchronized void refeshDefaultBizData(Map<DefaultBizMappingEntity, Long> allDefBizIds) {
        if (null != allDefBizIds) {
            this.devBizCache.clear();
            this.devBizCache.putAll(allDefBizIds);
            if (System.currentTimeMillis() - this.foudDefaultBizLastTime > 1800000L) {
                this.refeshDefaultBizTable(allDefBizIds);
            }
            this.notFoundZone.removeAll(allDefBizIds.keySet());
            this.foudDefaultBizLastTime = System.currentTimeMillis();
        } else {
            this.foudDefaultBizLastTime = System.currentTimeMillis() - 1800000L + 15000L;
            LOGGER.error((Object)"get allDefBizIds is null !");
        }
    }

    private void queryAllBizIDByDevIP(DefaultBizMappingEntity entity) {
        if (!this.notFoundZone.contains(entity) || System.currentTimeMillis() - this.foudDefaultBizLastTime > 1800000L) {
            this.notFoundZone.add(entity);
            this.refeshDefaultBizData(this.queryService.queryDefaultBiz());
        }
    }

    public synchronized long getBizIDByDevIP(DefaultBizMappingEntity entity) {
        if (!this.devBizCache.containsKey(entity)) {
            this.queryAllBizIDByDevIP(entity);
        }
        if (this.devBizCache.containsKey(entity)) {
            return this.devBizCache.get(entity);
        }
        LOGGER.info((Object)("not found put device Ip : " + entity));
        return 0L;
    }

    private void queryAllUserDefBizID(BizInfoEntity entity) {
        if (!this.notFoundUserDefBiz.contains(entity) || System.currentTimeMillis() - this.foudUserDefineBizLastTime > 1800000L) {
            this.notFoundUserDefBiz.add(entity);
            this.refreshUserDefBizData(this.queryService.queryUserDefBiz());
        }
    }

    public void refreshUserDefBizTable(Map<BizInfoEntity, Long> bizLis) {
        try {
            RefeshUserDefBizIdThread refeshUserDefBizId = new RefeshUserDefBizIdThread(bizLis);
            Thread refeshUserDefBizIdThread = new Thread((Runnable)refeshUserDefBizId, "RefeshUserDefBizIdThread");
            refeshUserDefBizIdThread.start();
        }
        catch (Exception e) {
            LOGGER.error((Object)"refeshUserDefBizIdThread start failed ! Program exit !", (Throwable)e);
        }
    }

    public synchronized void refreshUserDefBizData(Map<BizInfoEntity, Long> bizList) {
        if (null != bizList) {
            this.bizInfoCache.clear();
            this.bizInfoCache.putAll(bizList);
            if (System.currentTimeMillis() - this.foudUserDefineBizLastTime > 1800000L) {
                this.refreshUserDefBizTable(bizList);
            }
            this.notFoundUserDefBiz.retainAll(bizList.keySet());
            this.foudUserDefineBizLastTime = System.currentTimeMillis();
        } else {
            this.foudUserDefineBizLastTime = System.currentTimeMillis() - 1800000L + 15000L;
            LOGGER.error((Object)"get userbizList is null !");
        }
    }

    public synchronized long getBizId(long zoneId, String protocolStr, int port, String deviceIp) {
        BizInfoEntity entity = new BizInfoEntity(zoneId, protocolStr, port, deviceIp);
        if (!this.bizInfoCache.containsKey(entity)) {
            this.queryAllUserDefBizID(entity);
        }
        if (this.bizInfoCache.containsKey(entity)) {
            return this.bizInfoCache.get(entity);
        }
        LOGGER.info((Object)("not found put device Ip : " + entity));
        return 0L;
    }

    public synchronized List<Long> getAllDefaultZoneIds() {
        if (!this.devZoneCache.isEmpty()) {
            ArrayList<Long> listIds = new ArrayList<Long>();
            for (Map.Entry<String, Long> cache : this.devZoneCache.entrySet()) {
                listIds.add(cache.getValue());
            }
            return listIds;
        }
        return new ArrayList<Long>();
    }

    public boolean isDefaultZone(Long id) {
        List<Long> listIds = this.getAllDefaultZoneIds();
        return listIds.contains(id);
    }
}

