/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HourAverageBizIpFlowHandler<E extends Event>
extends EventHandler<E, E> {
    private static final int COUNT = 12;
    private long previousTime;
    private Map<Type, E> cache = new HashMap<Type, E>();

    public HourAverageBizIpFlowHandler() {
        super.setLogger(LogManager.getInstance().getHourTaskLog());
        this.initStartTime();
    }

    public synchronized void doHourTask() {
        ArrayList<E> sums = new ArrayList<E>();
        sums.addAll(this.cache.values());
        this.cache.clear();
        MBeanResourceFactory.FLOW_MESSAGE_1HOUR.cleanBizFlow();
        this.refreshSumEvents(sums);
        EventUtil.createEvents(sums);
        this.notifyFollowHandlers(sums);
    }

    public void initStartTime() {
        this.refreshTime();
    }

    @Override
    protected List<E> debugEvents(List<E> events) {
        ArrayList<Event> debugResult = new ArrayList<Event>();
        for (Event e : events) {
            if (e instanceof UdpDnsUserDefTypeEvent || e instanceof FlowEvent || e.isIsMaxEvent() || !e.isInboundEvent()) continue;
            debugResult.add(e);
        }
        return debugResult;
    }

    private Map<Type, List<E>> groupEvents(List<E> events) {
        HashMap<Type, List<E>> map = new HashMap<Type, List<E>>();
        for (Event e : events) {
            IpType type = new IpType(e.getType(), e.getIdentifier());
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(e);
            map.put(type, array);
        }
        return map;
    }

    @Override
    protected synchronized List<E> handelEvents(List<E> events) {
        if (!events.isEmpty()) {
            try {
                this.sumEvents(events);
            }
            catch (OutOfMemoryError error) {
                this.logger.error((Object)"out of memory ,then I clear the hour cache data", (Throwable)error);
            }
        }
        if (System.currentTimeMillis() - this.getPreviousTime() >= 3600000L) {
            this.doHourTask();
            this.refreshTime();
        }
        return new ArrayList();
    }

    private void mergeEvent(List<E> sameTypeEvents, Type type) {
        if (this.cache.containsKey(type)) {
            Event e = (Event)this.cache.get(type);
            e.merge(sameTypeEvents);
        } else {
            Event first = (Event)sameTypeEvents.get(0);
            Event e = first.getCopyEvent();
            EventIdentifier head = e.getIdentifierCopy();
            head.setZoneIpType();
            e.setIdentifer(head);
            e.merge(sameTypeEvents);
            this.cache.put(type, e);
            MBeanResourceFactory.FLOW_MESSAGE_1HOUR.addIpNum(e);
        }
    }

    protected void refreshSumEvents(List<E> sums) {
        for (Event e : sums) {
            e.setLogTime(this.getPreviousTime());
            e.average(12);
            e.setHourEvent(true);
            e.setMaxEvent(false);
        }
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.setPreviousTime(calendar.getTimeInMillis());
    }

    public void sumEvents(List<E> events) {
        Map<Type, List<E>> groups = this.groupEvents(events);
        for (Map.Entry<Type, List<E>> entry : groups.entrySet()) {
            List<E> sameTypeEvents = entry.getValue();
            Type type = entry.getKey();
            if (sameTypeEvents.isEmpty()) continue;
            this.mergeEvent(sameTypeEvents, type);
        }
    }

    public long getPreviousTime() {
        return this.previousTime;
    }

    public void setPreviousTime(long previousTime) {
        this.previousTime = previousTime;
    }
}

