/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HourDnsTypeEventIpHandler<E extends Event>
extends EventHandler<E, E> {
    private static final int COUNT = 12;
    private Map<Type, UdpDnsUserDefTypeEvent> cache = new HashMap<Type, UdpDnsUserDefTypeEvent>();
    private long previousTime;

    public HourDnsTypeEventIpHandler() {
        this.initStartTime();
    }

    @Override
    public List<E> handelEvents(List<E> events) {
        ArrayList<UdpDnsUserDefTypeEvent> dnsTypeList = new ArrayList<UdpDnsUserDefTypeEvent>();
        for (Event e : events) {
            if (!(e instanceof UdpDnsUserDefTypeEvent) || !e.isInboundEvent()) continue;
            dnsTypeList.add((UdpDnsUserDefTypeEvent)e);
        }
        if (!dnsTypeList.isEmpty()) {
            try {
                this.sumEvents(dnsTypeList);
            }
            catch (OutOfMemoryError error) {
                this.cache.clear();
            }
        }
        if (System.currentTimeMillis() - this.previousTime >= 3600000L) {
            this.doHourTask();
            this.refreshTime();
        }
        return new ArrayList();
    }

    public synchronized void doHourTask() {
        ArrayList<UdpDnsUserDefTypeEvent> sums = new ArrayList<UdpDnsUserDefTypeEvent>();
        sums.addAll(this.cache.values());
        this.cache.clear();
        MBeanResourceFactory.FLOW_MESSAGE_1HOUR.clearUdpDnsUserDefTypeEventFlow();
        this.refreshSumEvents(sums);
        EventUtil.createEvents(sums);
    }

    private Map<Type, List<UdpDnsUserDefTypeEvent>> groupEvents(List<UdpDnsUserDefTypeEvent> events) {
        HashMap<Type, List<UdpDnsUserDefTypeEvent>> map = new HashMap<Type, List<UdpDnsUserDefTypeEvent>>();
        for (UdpDnsUserDefTypeEvent e : events) {
            IpType type = new IpType(e.getType(), e.getIdentifier());
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<UdpDnsUserDefTypeEvent> array = new ArrayList<UdpDnsUserDefTypeEvent>();
            array.add(e);
            map.put(type, array);
        }
        return map;
    }

    public void initStartTime() {
        this.refreshTime();
    }

    protected void refreshSumEvents(List<UdpDnsUserDefTypeEvent> sums) {
        for (UdpDnsUserDefTypeEvent t : sums) {
            t.setLogTime(this.previousTime);
            t.setHourEvent(true);
            t.average(12);
        }
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.previousTime = calendar.getTimeInMillis();
    }

    private void sumEvents(List<UdpDnsUserDefTypeEvent> events) {
        Map<Type, List<UdpDnsUserDefTypeEvent>> groups = this.groupEvents(events);
        for (Map.Entry<Type, List<UdpDnsUserDefTypeEvent>> entry : groups.entrySet()) {
            List<UdpDnsUserDefTypeEvent> sameTypeEvents = entry.getValue();
            Type type = entry.getKey();
            if (sameTypeEvents.isEmpty()) continue;
            UdpDnsUserDefTypeEvent first = sameTypeEvents.get(0);
            if (this.cache.containsKey(type)) {
                UdpDnsUserDefTypeEvent old = this.cache.get(type);
                old.sumElement(sameTypeEvents);
                continue;
            }
            UdpDnsUserDefTypeEvent event = first.getCopyEvent();
            EventIdentifier identifier = event.getIdentifierCopy();
            if (!identifier.isZoneEvent()) {
                identifier.setZoneIpType();
            }
            event.setIdentifer(identifier);
            event.sumElement(sameTypeEvents);
            MBeanResourceFactory.FLOW_MESSAGE_1HOUR.addIpNum(event);
            this.cache.put(type, event);
        }
    }

    public Map<Type, UdpDnsUserDefTypeEvent> getCache() {
        return this.cache;
    }

    public long getPreviousTime() {
        return this.previousTime;
    }
}

