/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.FilterType;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.SlotType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HourMaxAllFlowHandler<E extends Event>
extends EventHandler<E, E> {
    private long previousTime;
    private Map<Type, E> cache = new HashMap<Type, E>();

    public HourMaxAllFlowHandler() {
        this.initStartTime();
    }

    public synchronized void doHourTask() {
        ArrayList<E> sums = new ArrayList<E>();
        sums.addAll(this.cache.values());
        this.cache.clear();
        this.refreshSumEvents(sums);
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)(" sum event size is " + sums.size() + " content is " + LogManager.NEXT_LINE));
        }
        EventUtil.createEvents(sums);
    }

    public void initStartTime() {
        this.refreshTime();
    }

    @Override
    protected List<E> debugEvents(List<E> events) {
        ArrayList<Event> debugResult = new ArrayList<Event>();
        for (Event e : events) {
            if (!e.isIsMaxEvent()) continue;
            debugResult.add(e);
        }
        return debugResult;
    }

    private Map<Type, List<E>> groupEvents(List<E> events) {
        HashMap<Type, List<E>> map = new HashMap<Type, List<E>>();
        for (Event event : events) {
            FilterType type = null;
            if (event.isZoneIp()) {
                type = new IpType(event.getIdentifier(), event.getType(), true);
            } else if (event.isZoneEvent()) {
                type = new ZoneType(event);
            } else if (event.isBizEvent()) {
                type = new BizType(event);
            } else if (event.isDeviceEvent()) {
                type = new DeviceType(event);
            } else if (event.isSlotEvent()) {
                type = new SlotType(event);
            }
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            map.put(type, array);
        }
        return map;
    }

    @Override
    protected synchronized List<E> handelEvents(List<E> events) {
        if (!events.isEmpty()) {
            try {
                this.sumEvents(events);
            }
            catch (OutOfMemoryError error) {
                this.logger.error((Object)"out of memory ,then I clear the hour cache data", (Throwable)error);
            }
        }
        if (System.currentTimeMillis() - this.getPreviousTime() >= 3600000L) {
            this.doHourTask();
            this.refreshTime();
        }
        return new ArrayList();
    }

    protected void refreshSumEvents(List<E> sums) {
        for (Event e : sums) {
            e.setLogTime(this.getPreviousTime());
            e.setHourEvent(true);
            e.setMaxEvent(true);
        }
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.setPreviousTime(calendar.getTimeInMillis());
    }

    public void sumEvents(List<E> events) {
        Map<Type, List<E>> groups = this.groupEvents(events);
        this.processEachGroup(groups);
    }

    private void processEachGroup(Map<Type, List<E>> groups) {
        for (Map.Entry<Type, List<E>> entry : groups.entrySet()) {
            List<E> sameTypeEvents = entry.getValue();
            Type type = entry.getKey();
            if (sameTypeEvents.isEmpty()) continue;
            this.maxEvent(sameTypeEvents, type);
        }
    }

    private void maxEvent(List<E> sameTypeEvents, Type type) {
        if (this.cache.containsKey(type)) {
            Event e = (Event)this.cache.get(type);
            for (Event each : sameTypeEvents) {
                e.max(each);
            }
        } else {
            Event first = (Event)sameTypeEvents.get(0);
            Event e = first.getCopyEvent();
            EventIdentifier head = e.getIdentifierCopy();
            if (first.isZoneIp()) {
                head.setZoneIpType();
            } else if (first.isZoneEvent()) {
                head.setZoneType();
            } else if (first.isBizEvent()) {
                head.setBizType();
            } else if (first.isDeviceEvent()) {
                head.setDeviceType();
            } else if (first.isSlotEvent()) {
                head.setSlotType();
            }
            e.setIdentifer(head);
            for (Event each : sameTypeEvents) {
                e.max(each);
            }
            this.cache.put(type, e);
        }
    }

    public long getPreviousTime() {
        return this.previousTime;
    }

    public void setPreviousTime(long previousTime) {
        this.previousTime = previousTime;
    }
}

