/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process.IntelligentDefense;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.IntelligentDefense.IntelligentDefenseRuleManage;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IntelligentDefenseEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.StreamMonitorAlarmInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IntelligentDefenseThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getAttackLog();
    private static final IntelligentDefenseThread INSTANCE = new IntelligentDefenseThread();
    private final ReentrantLock evnetMapLock = new ReentrantLock();
    private boolean start = false;
    private int checkEventNum = 3;
    private int logInterval = 128000;
    private Map<IpInfoKey, List<IntelligentDefenseEvent>> eventMap = new HashMap<IpInfoKey, List<IntelligentDefenseEvent>>();
    private Map<IpInfoKey, Set<Integer>> attackInfoMap = new HashMap<IpInfoKey, Set<Integer>>();
    private Map<IpInfoKey, Map<String, Integer>> blackInfoMap = new HashMap<IpInfoKey, Map<String, Integer>>();
    private Set<IpInfoKey> waitCheckList = new HashSet<IpInfoKey>();

    private IntelligentDefenseThread() {
        this.setName("IntelligentDefenseThread");
        this.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
    }

    public static IntelligentDefenseThread getInstance() {
        return INSTANCE;
    }

    public synchronized void addIpAttackInfo(ExceptionEvent event, IpInfoKey ipInfoKey) {
        if (event.getDropKbits() >= 0L || event.getDropPkgs() >= 0L) {
            Set<Integer> attacks = this.attackInfoMap.get(ipInfoKey);
            if (null == attacks) {
                attacks = new HashSet<Integer>();
                this.attackInfoMap.put(ipInfoKey, attacks);
            }
            attacks.add(event.getAttackType().getTypeValue());
        }
    }

    public synchronized void removeIpAttackInfo(IpInfoKey ipInfoKey, int attackType) {
        Set<Integer> attacks = this.attackInfoMap.get(ipInfoKey);
        if (attacks != null) {
            attacks.remove(attackType);
            if (attacks.isEmpty()) {
                this.attackInfoMap.remove(ipInfoKey);
            }
        }
    }

    public synchronized void addIpBlackInfo(ZoneBlackListEvent event) {
        IpInfoKey ipInfoKey = new IpInfoKey(event.getIdentifier());
        Map<String, Integer> balckIpTypes = this.blackInfoMap.get(ipInfoKey);
        if (null == balckIpTypes) {
            balckIpTypes = new HashMap<String, Integer>();
            this.blackInfoMap.put(ipInfoKey, balckIpTypes);
        }
        balckIpTypes.put(event.getBlackIp(), event.getBlackListType());
    }

    public synchronized void removeIpBlackInfo(ZoneBlackListEvent event) {
        IpInfoKey ipInfoKey = new IpInfoKey(event.getIdentifier());
        Map<String, Integer> balckIpTypes = this.blackInfoMap.get(ipInfoKey);
        if (balckIpTypes != null) {
            balckIpTypes.remove(event.getBlackIp(), event.getBlackListType());
            if (balckIpTypes.isEmpty()) {
                this.blackInfoMap.remove(ipInfoKey);
            }
        }
    }

    public void addIntelligentDefenseEvent(List<Event> flowList) {
        if (null == flowList || flowList.isEmpty()) {
            return;
        }
        HashMap<IpInfoKey, Event> inMap = new HashMap<IpInfoKey, Event>();
        HashMap<IpInfoKey, Event> dropMap = new HashMap<IpInfoKey, Event>();
        IpInfoKey ipTye = null;
        for (Event event : flowList) {
            ipTye = new IpInfoKey(event.getIdentifier());
            if (!IntelligentDefenseRuleManage.getInstance().isCheckZoneId(event.getZoneId()) || !event.isZoneIp() || StringUtils.isEmpty((String)event.getZoneIp()) || event.isIsMaxEvent() || !(event instanceof InFlowEvent) && !(event instanceof DiscardFlowEvent)) continue;
            if (event.isIsDropFlow()) {
                dropMap.put(ipTye, event);
                continue;
            }
            inMap.put(ipTye, event);
        }
        this.countIntelligentDefenseEvent(inMap, dropMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countIntelligentDefenseEvent(Map<IpInfoKey, Event> inMap, Map<IpInfoKey, Event> dropMap) {
        IpInfoKey ipTye = null;
        for (Map.Entry<IpInfoKey, Event> inEntry : inMap.entrySet()) {
            Map<String, Integer> blackIpTypes;
            IntelligentDefenseEvent intelligentDefenseEvent = null;
            ipTye = inEntry.getKey();
            Event inFlow = inEntry.getValue();
            Event dropFlow = dropMap.get(ipTye);
            intelligentDefenseEvent = null == dropFlow ? new IntelligentDefenseEvent((InFlowEvent)inFlow) : new IntelligentDefenseEvent((InFlowEvent)inFlow, (DiscardFlowEvent)dropFlow);
            Set<Integer> attacks = this.attackInfoMap.get(ipTye);
            if (null != attacks) {
                intelligentDefenseEvent.setAttackTypeSet(attacks);
            }
            if (null != (blackIpTypes = this.blackInfoMap.get(ipTye))) {
                HashSet<Integer> typeSet = new HashSet<Integer>();
                typeSet.addAll(blackIpTypes.values());
                intelligentDefenseEvent.setBlackTypeSet(typeSet);
            }
            this.evnetMapLock.lock();
            try {
                long lastLogTime;
                List<IntelligentDefenseEvent> eventList = this.eventMap.get(ipTye);
                if (null == eventList) {
                    eventList = new ArrayList<IntelligentDefenseEvent>();
                    eventList.add(intelligentDefenseEvent);
                    this.eventMap.put(ipTye, eventList);
                    continue;
                }
                long currTime = inFlow.getLogTime();
                if (currTime - (lastLogTime = eventList.get(eventList.size() - 1).getLogTime()) > (long)this.logInterval) {
                    eventList.clear();
                }
                if (eventList.size() >= this.checkEventNum) {
                    eventList.remove(0);
                }
                eventList.add(intelligentDefenseEvent);
                if (eventList.size() < this.checkEventNum) continue;
                this.waitCheckList.add(ipTye);
            }
            finally {
                this.evnetMapLock.unlock();
            }
        }
    }

    @Override
    public void run() {
        LOGGER.info((Object)"IntelligentDefenseThread start");
        this.initConfig();
        long lastTime = System.currentTimeMillis();
        while (true) {
            try {
                while (true) {
                    long currTime;
                    if ((currTime = System.currentTimeMillis()) - lastTime >= (long)this.logInterval) {
                        this.doEvnetTimeOutCheck(currTime);
                        lastTime = currTime;
                    }
                    if (IntelligentDefenseRuleManage.getInstance().isHaveRules()) {
                        if (this.waitCheckList.isEmpty()) {
                            this.sleepTime(100);
                            continue;
                        }
                        Set<IpInfoKey> tempWaitCheckList = this.waitCheckList;
                        this.waitCheckList = new HashSet<IpInfoKey>();
                        ArrayList<StreamMonitorAlarmInfo> allAlarmInfoList = new ArrayList<StreamMonitorAlarmInfo>();
                        List<IntelligentDefenseEvent> eventList = null;
                        List<StreamMonitorAlarmInfo> alarmInfoList = null;
                        for (IpInfoKey ipInfoKey : tempWaitCheckList) {
                            eventList = this.eventMap.get(ipInfoKey);
                            if (null == eventList) continue;
                            alarmInfoList = IntelligentDefenseRuleManage.applyRules(eventList);
                            StringBuffer eventBuffer = new StringBuffer();
                            for (IntelligentDefenseEvent event : eventList) {
                                eventBuffer.append("[").append(event.toString()).append("]");
                            }
                            if (alarmInfoList != null && !alarmInfoList.isEmpty()) {
                                allAlarmInfoList.addAll(alarmInfoList);
                                StringBuffer alarmBuffer = new StringBuffer();
                                for (StreamMonitorAlarmInfo alarm : alarmInfoList) {
                                    alarmBuffer.append("[").append(alarm.toString()).append("]");
                                }
                                LOGGER.info((Object)("match alarm:" + alarmBuffer.toString()));
                                LOGGER.info((Object)("and flowEvents=" + eventBuffer.toString()));
                                continue;
                            }
                            LOGGER.info((Object)("not match alarm, the flowEvents=" + eventBuffer.toString()));
                        }
                        AlarmThread.getInstance().addStreamMonitorAlarm(allAlarmInfoList);
                        continue;
                    }
                    this.sleepTime(60000);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"run is error:", (Throwable)e);
                this.sleepTime(60000);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEvnetTimeOutCheck(long currTime) {
        this.evnetMapLock.lock();
        try {
            Iterator<Map.Entry<IpInfoKey, List<IntelligentDefenseEvent>>> it = this.eventMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IpInfoKey, List<IntelligentDefenseEvent>> entry = it.next();
                List<IntelligentDefenseEvent> eventList = entry.getValue();
                long lastLogTime = eventList.get(eventList.size() - 1).getLogTime();
                if (currTime - lastLogTime <= (long)this.logInterval) continue;
                eventList.clear();
                it.remove();
            }
        }
        finally {
            this.evnetMapLock.unlock();
        }
    }

    private void initConfig() {
        try {
            this.checkEventNum = Integer.parseInt(EventUtil.getEventConfigProperty("checkEventNum"));
            LOGGER.info((Object)("read config: checkEventNum= " + this.checkEventNum));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is checkEventNum");
        }
        try {
            this.logInterval = Integer.parseInt(EventUtil.getEventConfigProperty("deviceLogReportCycle"));
            this.logInterval = this.logInterval * 1000 * 2;
            LOGGER.info((Object)("read config: logInterval=" + this.logInterval));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is checkEventNum");
        }
        String synPpsKey = "0.synPps";
        String synPpsValue = EventUtil.getEventConfigProperty(synPpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(synPpsKey, synPpsValue);
        String ackPpsKey = "0.ackPps";
        String ackPpsValue = EventUtil.getEventConfigProperty(ackPpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(ackPpsKey, ackPpsValue);
        String tcpIncreaseConKey = "0.tcpIncreaseCon";
        String tcpIncreaseConValue = EventUtil.getEventConfigProperty(tcpIncreaseConKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(tcpIncreaseConKey, tcpIncreaseConValue);
        String tcpConcurConKey = "0.tcpConcurCon";
        String tcpConcurConValue = EventUtil.getEventConfigProperty(tcpConcurConKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(tcpConcurConKey, tcpConcurConValue);
        String httpQpsKey = "0.httpQps";
        String httpQpsValue = EventUtil.getEventConfigProperty(httpQpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(httpQpsKey, httpQpsValue);
        String udpKbpsKey = "0.udpKbps";
        String udpKbpsValue = EventUtil.getEventConfigProperty(udpKbpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(udpKbpsKey, udpKbpsValue);
        String dnsRequestPpsKey = "0.dnsRequestPps";
        String dnsRequestPpsValue = EventUtil.getEventConfigProperty(dnsRequestPpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(dnsRequestPpsKey, dnsRequestPpsValue);
        synPpsKey = "1.synPps";
        synPpsValue = EventUtil.getEventConfigProperty(synPpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(synPpsKey, synPpsValue);
        ackPpsKey = "1.ackPps";
        ackPpsValue = EventUtil.getEventConfigProperty(ackPpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(ackPpsKey, ackPpsValue);
        tcpIncreaseConKey = "1.tcpIncreaseCon";
        tcpIncreaseConValue = EventUtil.getEventConfigProperty(tcpIncreaseConKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(tcpIncreaseConKey, tcpIncreaseConValue);
        tcpConcurConKey = "1.tcpConcurCon";
        tcpConcurConValue = EventUtil.getEventConfigProperty(tcpConcurConKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(tcpConcurConKey, tcpConcurConValue);
        httpQpsKey = "1.httpQps";
        httpQpsValue = EventUtil.getEventConfigProperty(httpQpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(httpQpsKey, httpQpsValue);
        udpKbpsKey = "1.udpKbps";
        udpKbpsValue = EventUtil.getEventConfigProperty(udpKbpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(udpKbpsKey, udpKbpsValue);
        dnsRequestPpsKey = "1.dnsRequestPps";
        dnsRequestPpsValue = EventUtil.getEventConfigProperty(dnsRequestPpsKey);
        IntelligentDefenseRuleManage.getMeasureThreshold().put(dnsRequestPpsKey, dnsRequestPpsValue);
    }

    private void sleepTime(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"InterruptedException error", (Throwable)e);
        }
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

