/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IpAttackLifeHandler
extends EventHandler<ChangeEvent<ExceptionEvent>, ChangeEvent<IpAttackEvent>> {
    private Map<Type, IpAttackEvent> ipAttackRecords = new HashMap<Type, IpAttackEvent>();

    public IpAttackLifeHandler() {
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    @Override
    public List<ChangeEvent<IpAttackEvent>> handelEvents(List<ChangeEvent<ExceptionEvent>> events) {
        if (!events.isEmpty()) {
            ArrayList<ExceptionEvent> changedExceptionEvents = new ArrayList<ExceptionEvent>();
            for (ChangeEvent<ExceptionEvent> each : events) {
                changedExceptionEvents.add(each.getChange());
            }
            Map<Type, List<ExceptionEvent>> groups = EventUtil.groupEventsByZoneIpIgnoreType(changedExceptionEvents);
            return this.updateIpAttackCache(groups);
        }
        return new ArrayList<ChangeEvent<IpAttackEvent>>();
    }

    public void setIpAttackRecords(Map<Type, IpAttackEvent> ipAttackRecords) {
        this.ipAttackRecords = ipAttackRecords;
    }

    public Map<Type, IpAttackEvent> getIpAttackRecords() {
        return this.ipAttackRecords;
    }

    private List<ChangeEvent<IpAttackEvent>> updateIpAttackCache(Map<Type, List<ExceptionEvent>> events) {
        ArrayList<ChangeEvent<IpAttackEvent>> changedEvents = new ArrayList<ChangeEvent<IpAttackEvent>>();
        this.logger.info((Object)(" before update ipAttacke events ,size is " + this.ipAttackRecords.size()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" before update ipAttack  events :cache is " + LogManager.NEXT_LINE + this.ipAttackRecords));
        }
        for (Map.Entry<Type, List<ExceptionEvent>> entry : events.entrySet()) {
            Type key = entry.getKey();
            List<ExceptionEvent> values = entry.getValue();
            IpAttackEvent ipAttackEvent = this.getIpAttackEventByType(key, values.get(0).getIdentifierCopy());
            Event change = ipAttackEvent.sumElement((List)values);
            ChangeEvent<Event> changedEvent = new ChangeEvent<Event>(ipAttackEvent, change);
            if (ipAttackEvent.isNormal()) {
                this.ipAttackRecords.remove(key);
            }
            changedEvents.add(changedEvent);
        }
        this.logger.info((Object)(" after update ,ipAttack events size is " + this.ipAttackRecords.size()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" after update ipAttack  events :cache is " + LogManager.NEXT_LINE + this.ipAttackRecords));
        }
        return changedEvents;
    }

    private IpAttackEvent getIpAttackEventByType(Type key, EventIdentifier identifier) {
        if (this.ipAttackRecords.containsKey(key)) {
            return this.ipAttackRecords.get(key);
        }
        IpAttackEvent event = new IpAttackEvent(identifier);
        this.ipAttackRecords.put(key, event);
        return event;
    }
}

