/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpLocationType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IpLocationTotalFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.ZoneTotalFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IpLocation5minSumHandler<T extends Event>
extends EventHandler<T, T> {
    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event t : events) {
            if (!t.getIdentifier().isIpLocation() || t.isIsMaxEvent() || !t.isInboundEvent()) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        Map<Type, List<T>> devGroup = this.dividByType(events);
        List<T> devList = this.processIpLocationGroup(devGroup);
        EventUtil.createEvents(devList);
        return devList;
    }

    private List<T> processIpLocationGroup(Map<Type, List<T>> devGroup) {
        ArrayList<IpLocationTotalFlowEvent> totalEventList = new ArrayList<IpLocationTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : devGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            Event first = (Event)eventList.get(0);
            EventIdentifier header = first.getIdentifierCopy();
            header.setIpLocationType();
            IpLocationTotalFlowEvent ipLocationTotal = null;
            ipLocationTotal = first.isIsDropFlow() ? new IpLocationTotalFlowEvent(header, true) : new IpLocationTotalFlowEvent(header, false);
            ipLocationTotal.setMaxEvent(first.isIsMaxEvent());
            for (Event each : eventList) {
                if (each instanceof InFlowEvent) {
                    ipLocationTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    ipLocationTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                if (each instanceof TcpBizFlowEvent) {
                    ipLocationTotal.mergeTcpBizFlowEvent((TcpBizFlowEvent)each);
                }
                if (each instanceof UdpBizFlowEvent) {
                    ipLocationTotal.mergeUdpBizFlowEvent((UdpBizFlowEvent)each);
                }
                if (each instanceof OtherBizFlowEvent) {
                    ipLocationTotal.mergeOtherBizFlowEvent((OtherBizFlowEvent)each);
                }
                if (!(each instanceof ZoneTotalFlowEvent)) continue;
                ipLocationTotal.mergeZoneTotalFlowEvent((ZoneTotalFlowEvent)each);
            }
            totalEventList.add(ipLocationTotal);
        }
        return totalEventList;
    }

    private Map<Type, List<T>> dividByType(List<T> events) {
        HashMap<Type, List<T>> map = new HashMap<Type, List<T>>();
        for (Event e : events) {
            EventIdentifier header = e.getIdentifier();
            IpLocationType type = new IpLocationType(header, e.isIsDropFlow());
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<Event> thisType = new ArrayList<Event>();
            thisType.add(e);
            map.put(type, thisType);
        }
        return map;
    }
}

