/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.entity.event.AbnormalIpCache;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class IpStateHandler
extends EventHandler<ChangeEvent<IpAttackEvent>, IpAttackEvent> {
    private AbnormalIpCache abnormalIpCache = AbnormalIpCache.getInstance();

    public IpStateHandler() {
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    @Override
    protected List<IpAttackEvent> handelEvents(List<ChangeEvent<IpAttackEvent>> events) {
        HashSet<String> abnormal = new HashSet<String>();
        HashSet<String> normal = new HashSet<String>();
        for (ChangeEvent<IpAttackEvent> change : events) {
            IpAttackEvent each = change.getSource();
            if (!each.isNormal()) {
                abnormal.add(each.getZoneIp());
                continue;
            }
            normal.add(each.getZoneIp());
        }
        if (!abnormal.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" those ip are abnormal ip" + abnormal));
        }
        this.abnormalIpCache.addAbnormalIpList(abnormal);
        this.abnormalIpCache.addNormalIpList(normal);
        return new ArrayList<IpAttackEvent>();
    }
}

