/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.ZoneStateData;
import com.hs.atic.collector.conn.ConnectionRmiThread;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.ZoneAttackEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ZoneConfService;
import com.hs.atic.rmi.ZoneState;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class NotifyZoneHandler
extends EventHandler<ChangeEvent<ZoneAttackEvent>, ZoneAttackEvent> {
    private static List<ZoneStateData> zoneStatus = new ArrayList<ZoneStateData>();
    private static NotifyZoneHandler handler = new NotifyZoneHandler();
    private NotifyThread thread = new NotifyThread();

    private NotifyZoneHandler() {
        this.thread.setName("notify zone thread");
        this.thread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        this.thread.start();
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    public static NotifyZoneHandler getInstance() {
        return handler;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoneState> getAllZoneStatus() {
        ArrayList<ZoneState> results = new ArrayList<ZoneState>();
        if (!zoneStatus.isEmpty()) {
            List<ZoneStateData> list = zoneStatus;
            synchronized (list) {
                for (ZoneStateData each : zoneStatus) {
                    results.add(each.getZoneState());
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZoneStatus(ZoneState state) {
        if (!zoneStatus.isEmpty()) {
            List<ZoneStateData> list = zoneStatus;
            synchronized (list) {
                for (ZoneStateData each : zoneStatus) {
                    ZoneState zoneState = each.getZoneState();
                    if (!zoneState.equals(state)) continue;
                    return zoneState.getState();
                }
            }
        }
        return 1;
    }

    public void init(List<ZoneAttackEvent> zoneEvents) {
        for (ZoneAttackEvent each : zoneEvents) {
            this.proceedStateChange(each);
        }
    }

    @Override
    protected List<ZoneAttackEvent> handelEvents(List<ChangeEvent<ZoneAttackEvent>> events) {
        if (!events.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("get events:" + events));
            }
            for (ChangeEvent<ZoneAttackEvent> event : events) {
                ZoneAttackEvent attackEvent = event.getSource();
                if (!attackEvent.isIsStateChanged()) continue;
                this.proceedStateChange(attackEvent);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("zone state on " + (event.isFromCleanDevice() ? "Clean Device " : "Detect Device ") + event.getDeviceIp() + " changed ,Id is " + attackEvent.getZoneId() + " state is :" + AbnormalEvent.getStateDescription(attackEvent.getCurrentState())));
            }
        }
        return new ArrayList<ZoneAttackEvent>();
    }

    public void notifyInitZoneStateStatus(List<ZoneState> list) {
        this.thread.addInitZoneStateStatus(list);
    }

    private void proceedStateChange(ZoneAttackEvent event) {
        int currentState = 0;
        int partState = event.getCurrentState() + 1;
        long zoneId = event.getZoneId();
        String deviceIp = event.getDeviceIp();
        ZoneStateData data = new ZoneStateData(zoneId);
        data.setDeviceIp(deviceIp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" current zone state is :" + zoneStatus + " current stat is " + currentState));
        }
        if (zoneStatus.contains(data)) {
            for (ZoneStateData each : zoneStatus) {
                if (!each.equals(data) || !each.addStateData(event.getIdentifierCopy(), partState)) continue;
                currentState = each.getCurrentState();
                this.thread.refreshNotifyMap(each.getZoneState());
            }
        } else {
            data.addStateData(event.getIdentifierCopy(), partState);
            zoneStatus.add(data);
            currentState = data.getCurrentState();
            this.thread.refreshNotifyMap(data.getZoneState());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" current zone state is fu:" + zoneStatus + " current stat is " + currentState));
        }
        if (currentState == 1) {
            zoneStatus.remove(data);
        }
    }

    private static class NotifyThread
    extends Thread {
        private static final Logger SYSLOGGER = LogManager.getInstance().getSystemLog();
        private static final String SERVICE_NAME = "ZoneConfService";
        private static final long SLEEP_TIME = 10000L;
        private static final String COLLECTORIP = System.getProperty("java.rmi.server.hostname");
        private List<ZoneState> states = new ArrayList<ZoneState>();
        private ZoneConfService listener;

        private NotifyThread() {
        }

        public synchronized void refreshNotifyMap(ZoneState state) {
            if (this.states.contains(state)) {
                this.states.remove(state);
            }
            this.states.add(state);
            if (SYSLOGGER.isDebugEnabled()) {
                SYSLOGGER.debug((Object)("  states is fu :" + this.states + " current stat is " + state));
            }
        }

        @Override
        public void run() {
            while (true) {
                if (null == this.listener && ConnectionRmiThread.getInstance().getRmiConnection().booleanValue()) {
                    this.listener = (ZoneConfService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
                }
                try {
                    if (this.listener != null) {
                        this.notifyZoneState();
                    } else {
                        Thread.sleep(10000L);
                    }
                }
                catch (Exception e) {
                    SYSLOGGER.error((Object)"when notify zone state ,error happend", (Throwable)e);
                    this.listener = null;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    SYSLOGGER.error((Object)"when sleep ,interrupted by unknow reason", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private synchronized void notifyZoneState() throws RemoteException {
            if (this.states.isEmpty()) {
                return;
            }
            Iterator<ZoneState> itor = this.states.iterator();
            while (itor.hasNext()) {
                ZoneState state = itor.next();
                this.listener.notifyZoneStateChanged(state, COLLECTORIP);
                itor.remove();
                SYSLOGGER.info((Object)("notify zone  ,zone state is " + state + ";collectorIp:" + COLLECTORIP));
            }
        }

        public void addInitZoneStateStatus(List<ZoneState> list) {
            if (this.states.isEmpty()) {
                this.states.addAll(list);
                return;
            }
            for (ZoneState initState : list) {
                if (this.states.contains(initState)) continue;
                this.states.add(initState);
            }
        }
    }
}

