/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PacketsDispatchConsumer
extends Consumer<TimeDatagramPacket> {
    private Buffer<TimeDatagramPacket> dispatchBuffer;
    private ConcurrentLinkedQueue<TimeDatagramPacket> packetQueue;

    public Buffer<TimeDatagramPacket> getDispatchBuffer() {
        return this.dispatchBuffer;
    }

    public void setDispatchBuffer(Buffer<TimeDatagramPacket> dispatchBuffer) {
        this.dispatchBuffer = dispatchBuffer;
    }

    @Override
    protected void proceedPacket(List<TimeDatagramPacket> packets) {
        if (null != this.packetQueue) {
            for (TimeDatagramPacket packet : packets) {
                this.packetQueue.offer(packet);
            }
        } else if (null != this.dispatchBuffer) {
            this.dispatchBuffer.addPacketList(packets);
        }
    }

    @Override
    public ConcurrentLinkedQueue<TimeDatagramPacket> getPacketQueue() {
        return this.packetQueue;
    }

    @Override
    public void setPacketQueue(ConcurrentLinkedQueue<TimeDatagramPacket> packetQueue) {
        this.packetQueue = packetQueue;
    }
}

