/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.SrcTopnEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SrcTopnEventParserV4
implements EventDataParser {
    private static final int SRC_TOPN = 8;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suit, int type, int number) throws IOException {
        if (type == 8) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, suit);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"when close stram error", (Throwable)e);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit) throws IOException {
        SrcTopnEvent srcTopnEvent = new SrcTopnEvent(suit.getIdentifier());
        this.readDnsSrcTopnEvent(stream, srcTopnEvent);
        if (IpTransformer.checkIpInvaild(srcTopnEvent.getSrcIp())) {
            suit.addDnsSrcTopnEvent(srcTopnEvent);
        } else {
            LOGGER.info((Object)("I drop a DnsSrcTopnEvent .src ip is 0. " + srcTopnEvent));
        }
    }

    private void readDnsSrcTopnEvent(UnsignedDataInputStream stream, SrcTopnEvent srcTopnEvent) throws IOException {
        stream.readUnsignedShort();
        stream.readUnsignedShort();
        srcTopnEvent.setRequestPps(stream.readUnsignedInt());
        srcTopnEvent.setRequestKbps(stream.readUnsignedInt());
        stream.readUnsignedShort();
        srcTopnEvent.setTopnType(stream.readUnsignedByte());
        int ucSrcIpType = stream.readUnsignedByte();
        byte[] address = new byte[16];
        if (stream.read(address) != 16) {
            LOGGER.error((Object)"stream read error");
        }
        srcTopnEvent.setSrcIp(IpTransformer.byte2String(address, ucSrcIpType));
    }
}

