/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.DesZoneEvent;
import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.FilterType;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.entity.event.BizTotalFlowEvent;
import com.hs.atic.collector.entity.event.DevTotalFlowEvent;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IpTotalFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.ZoneTotalFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SumAllFlowHandler<T extends Event>
extends EventHandler<T, T> {
    private static final int IP = 1;
    private static final int ZONE = 2;
    private static final int DEVICE = 3;
    private static final int BIZ = 4;

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event t : events) {
            if (t.getIdentifier().isIpLocation()) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event t : events) {
            if (t.getIdentifier().isDesZone()) continue;
            list.add(t);
        }
        ArrayList<Object> allList = new ArrayList<Object>();
        allList.addAll(this.sumByIp(list));
        allList.addAll(this.sumByBiz(list));
        List<T> zoneList = this.sumByZone(events);
        allList.addAll(zoneList);
        allList.addAll(this.sumByDevice(events));
        return allList;
    }

    private List<T> sumByIp(List<T> events) {
        Map<Type, List<T>> ipGroup = this.dividByType(events, 1);
        List<T> ipList = this.processIpGroup(ipGroup);
        EventUtil.createEvents(ipList);
        return ipList;
    }

    private List<T> processIpGroup(Map<Type, List<T>> ipGroup) {
        ArrayList<IpTotalFlowEvent> totalEventList = new ArrayList<IpTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : ipGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            Event first = (Event)eventList.get(0);
            EventIdentifier header = first.getIdentifierCopy();
            header.setZoneIpType();
            IpTotalFlowEvent ipTotal = null;
            ipTotal = first.isIsDropFlow() ? new IpTotalFlowEvent(header, true, false) : (first.isIsForwardFlow() ? new IpTotalFlowEvent(header, false, true) : new IpTotalFlowEvent(header, false, false));
            ipTotal.setMaxEvent(first.isIsMaxEvent());
            for (Event each : eventList) {
                if (each instanceof InFlowEvent) {
                    ipTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof ForwardFlowEvent) {
                    ipTotal.mergeForwardFlowEvent((ForwardFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    ipTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                if (each instanceof TcpBizFlowEvent) {
                    ipTotal.mergeTcpBizFlowEvent((TcpBizFlowEvent)each);
                }
                if (each instanceof UdpBizFlowEvent) {
                    ipTotal.mergeUdpBizFlowEvent((UdpBizFlowEvent)each);
                }
                if (!(each instanceof OtherBizFlowEvent)) continue;
                ipTotal.mergeOtherBizFlowEvent((OtherBizFlowEvent)each);
            }
            IpTotalFlowEvent ipTotal2 = ipTotal;
            totalEventList.add(ipTotal2);
        }
        return totalEventList;
    }

    private List<T> processZoneGroupWithDesZone(Map<Type, List<T>> zoneGroup) {
        ArrayList totalEventList = new ArrayList();
        HashMap<ZoneType, DesZoneEvent<ZoneTotalFlowEvent>> groups = new HashMap<ZoneType, DesZoneEvent<ZoneTotalFlowEvent>>();
        for (Map.Entry<Type, List<T>> entry : zoneGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            Event first = (Event)eventList.get(0);
            EventIdentifier header = first.getIdentifierCopy();
            header.setZoneType();
            ZoneTotalFlowEvent zoneTotal = null;
            zoneTotal = first.isIsDropFlow() ? new ZoneTotalFlowEvent(header, true, false) : (first.isIsForwardFlow() ? new ZoneTotalFlowEvent(header, false, true) : new ZoneTotalFlowEvent(header, false, false));
            zoneTotal.setMaxEvent(first.isIsMaxEvent());
            for (Event each : eventList) {
                if (each instanceof InFlowEvent) {
                    zoneTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof ForwardFlowEvent) {
                    zoneTotal.mergeForwardFlowEvent((ForwardFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    zoneTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                if (each instanceof TcpBizFlowEvent) {
                    zoneTotal.mergeTcpBizFlowEvent((TcpBizFlowEvent)each);
                }
                if (each instanceof UdpBizFlowEvent) {
                    zoneTotal.mergeUdpBizFlowEvent((UdpBizFlowEvent)each);
                }
                if (!(each instanceof OtherBizFlowEvent)) continue;
                zoneTotal.mergeOtherBizFlowEvent((OtherBizFlowEvent)each);
            }
            ZoneType type = new ZoneType(header, zoneTotal.isIsDropFlow(), zoneTotal.isIsMaxEvent(), zoneTotal.isIsForwardFlow());
            if (groups.containsKey(type)) {
                ((DesZoneEvent)groups.get(type)).add(zoneTotal);
                continue;
            }
            groups.put(type, new DesZoneEvent<ZoneTotalFlowEvent>(zoneTotal));
        }
        for (Map.Entry<Type, List<Object>> entry : groups.entrySet()) {
            totalEventList.add(((DesZoneEvent)((Object)entry.getValue())).rpDesZone());
        }
        return totalEventList;
    }

    private List<T> sumByBiz(List<T> events) {
        Map<Type, List<T>> bizGroup = this.dividByType(events, 4);
        List<T> bizList = this.processBizGroup(bizGroup);
        EventUtil.createEvents(bizList);
        return bizList;
    }

    private List<T> processBizGroup(Map<Type, List<T>> bizGroup) {
        ArrayList<BizTotalFlowEvent> totalEventList = new ArrayList<BizTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : bizGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            Event first = (Event)eventList.get(0);
            EventIdentifier header = first.getIdentifierCopy();
            header.setBizType();
            BizTotalFlowEvent bizTotal = null;
            if (first.isIsDropFlow()) {
                bizTotal = new BizTotalFlowEvent(header, true);
            } else {
                bizTotal = new BizTotalFlowEvent(header, false);
                if (first.isIsForwardFlow()) {
                    bizTotal.setForwardFlow(true);
                }
            }
            bizTotal.setMaxEvent(first.isIsMaxEvent());
            for (Event each : eventList) {
                if (each instanceof InFlowEvent) {
                    bizTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof ForwardFlowEvent) {
                    bizTotal.mergeForwardFlowEvent((ForwardFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    bizTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                if (each instanceof TcpBizFlowEvent) {
                    bizTotal.mergeTcpBizFlowEvent((TcpBizFlowEvent)each);
                }
                if (each instanceof UdpBizFlowEvent) {
                    bizTotal.mergeUdpBizFlowEvent((UdpBizFlowEvent)each);
                }
                if (!(each instanceof OtherBizFlowEvent)) continue;
                bizTotal.mergeOtherBizFlowEvent((OtherBizFlowEvent)each);
            }
            totalEventList.add(bizTotal);
        }
        return totalEventList;
    }

    private List<T> sumByZone(List<T> events) {
        Map<Type, List<T>> zoneGroup = this.dividByType(events, 2);
        List<T> zoneList = this.processZoneGroupWithDesZone(zoneGroup);
        EventUtil.createEvents(zoneList);
        return zoneList;
    }

    private List<T> sumByDevice(List<T> events) {
        Map<Type, List<T>> devGroup = this.dividByType(events, 3);
        List<T> devList = this.processDevGroup(devGroup);
        EventUtil.createEvents(devList);
        return devList;
    }

    private List<T> processDevGroup(Map<Type, List<T>> devGroup) {
        ArrayList<DevTotalFlowEvent> totalEventList = new ArrayList<DevTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : devGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            Event first = (Event)eventList.get(0);
            EventIdentifier header = first.getIdentifierCopy();
            header.setDeviceType();
            DevTotalFlowEvent devTotal = null;
            devTotal = first.isIsDropFlow() ? new DevTotalFlowEvent(header, true, false) : (first.isIsForwardFlow() ? new DevTotalFlowEvent(header, false, true) : new DevTotalFlowEvent(header, false, false));
            devTotal.setMaxEvent(first.isIsMaxEvent());
            for (Event each : eventList) {
                if (each instanceof InFlowEvent) {
                    devTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof ForwardFlowEvent) {
                    devTotal.mergeForwardFlowEvent((ForwardFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    devTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                if (each instanceof TcpBizFlowEvent) {
                    devTotal.mergeTcpBizFlowEvent((TcpBizFlowEvent)each);
                }
                if (each instanceof UdpBizFlowEvent) {
                    devTotal.mergeUdpBizFlowEvent((UdpBizFlowEvent)each);
                }
                if (each instanceof OtherBizFlowEvent) {
                    devTotal.mergeOtherBizFlowEvent((OtherBizFlowEvent)each);
                }
                if (!(each instanceof ZoneTotalFlowEvent)) continue;
                devTotal.mergeZoneTotalFlowEvent((ZoneTotalFlowEvent)each);
            }
            totalEventList.add(devTotal);
        }
        return totalEventList;
    }

    private Map<Type, List<T>> dividByType(List<T> events, int typeFlag) {
        HashMap<Type, List<T>> map = new HashMap<Type, List<T>>();
        for (Event e : events) {
            if (!e.isNeedSum()) continue;
            EventIdentifier header = e.getIdentifier();
            FilterType type = null;
            switch (typeFlag) {
                case 1: {
                    if (!e.isZoneIp()) break;
                    type = new IpType(header, e.isIsDropFlow(), e.isIsMaxEvent(), e.isIsForwardFlow());
                    break;
                }
                case 2: {
                    if (!e.isZoneEvent()) break;
                    type = new ZoneType(header, e.isIsDropFlow(), e.isIsMaxEvent(), e.isIsForwardFlow());
                    break;
                }
                case 4: {
                    if (!e.isZoneIp() || !e.isInboundEvent()) break;
                    type = new BizType(header, e.isIsDropFlow(), e.isIsMaxEvent(), e.isIsForwardFlow());
                    break;
                }
                case 3: {
                    if (!e.isDeviceEvent() && (!e.isZoneEvent() || !"NFA".equals(e.getDeviceTypeName()))) break;
                    type = new DeviceType(header, e.isIsDropFlow(), e.isIsMaxEvent(), e.isIsForwardFlow());
                    break;
                }
            }
            if (type == null) continue;
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<Event> thisType = new ArrayList<Event>();
            thisType.add(e);
            map.put(type, thisType);
        }
        return map;
    }
}

