/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.FilterType;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.entity.event.DevTotalFlowEvent;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IpTotalFlowEvent;
import com.hs.atic.collector.entity.event.ZoneTotalFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SumMinFlowHandler<T extends Event>
extends EventHandler<T, T> {
    private static final int IP = 1;
    private static final int ZONE = 2;
    private static final int DEVICE = 3;
    private boolean isMinSumIpFlowSave = false;
    private boolean isMinSumZoneFlowSave = false;
    private boolean isMinSumDevFlowSave = false;

    public SumMinFlowHandler() {
        try {
            this.isMinSumIpFlowSave = Boolean.valueOf(EventUtil.getEventConfigProperty("isMinSumIpFlowSave"));
        }
        catch (Exception e) {
            this.logger.error((Object)"read config error content error,key is isMinSumIpFlowSave");
        }
        try {
            this.isMinSumZoneFlowSave = Boolean.valueOf(EventUtil.getEventConfigProperty("isMinSumZoneFlowSave"));
        }
        catch (Exception e) {
            this.logger.error((Object)"read config error content error,key is isMinSumZoneFlowSave");
        }
        try {
            this.isMinSumDevFlowSave = Boolean.valueOf(EventUtil.getEventConfigProperty("isMinSumDevFlowSave"));
        }
        catch (Exception e) {
            this.logger.error((Object)"read config error content error,key is isMinSumDevFlowSave");
        }
    }

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event t : events) {
            if (t.getIdentifier().isIpLocation() || t.getIdentifier().isDesZone() || t.isIsForwardFlow()) continue;
            result.add(t);
        }
        if (!events.isEmpty()) {
            this.logger.info((Object)("SumMinFlowHandler debugEvents after, result.size=" + result.size()));
        }
        return result;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        ArrayList<T> allList = new ArrayList<T>();
        if (null != events && !events.isEmpty()) {
            allList.addAll(this.sumByIp(events));
            allList.addAll(this.sumByZone(events));
            allList.addAll(this.sumByDevice(events));
        }
        return allList;
    }

    private Collection<? extends T> sumByIp(List<T> events) {
        Map<Type, List<T>> ipGroup = this.dividByType(events, 1);
        List<T> ipList = this.processIpGroup(ipGroup);
        if (this.isMinSumIpFlowSave) {
            EventUtil.createEvents(ipList);
        }
        return ipList;
    }

    private List<T> processIpGroup(Map<Type, List<T>> ipGroup) {
        ArrayList<IpTotalFlowEvent> totalList = new ArrayList<IpTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : ipGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            for (Event each : eventList) {
                EventIdentifier identifer = each.getIdentifierCopy();
                identifer.setZoneIpType();
                IpTotalFlowEvent ipTotal = null;
                ipTotal = each.isIsDropFlow() ? new IpTotalFlowEvent(identifer, true, false) : new IpTotalFlowEvent(identifer, false, false);
                ipTotal.setMinSumEvent(true);
                ipTotal.setMaxEvent(each.isIsMaxEvent());
                if (each instanceof InFlowEvent) {
                    ipTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    ipTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                totalList.add(ipTotal);
            }
        }
        return totalList;
    }

    private Collection<? extends T> sumByZone(List<T> events) {
        Map<Type, List<T>> zoneGroup = this.dividByType(events, 2);
        List<T> zoneList = this.processZoneGroup(zoneGroup);
        if (this.isMinSumZoneFlowSave) {
            EventUtil.createEvents(zoneList);
        }
        return zoneList;
    }

    private List<T> processZoneGroup(Map<Type, List<T>> zoneGroup) {
        ArrayList<ZoneTotalFlowEvent> totalList = new ArrayList<ZoneTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : zoneGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            for (Event each : eventList) {
                EventIdentifier identifer = each.getIdentifierCopy();
                identifer.setZoneType();
                ZoneTotalFlowEvent zoneTotal = null;
                zoneTotal = each.isIsDropFlow() ? new ZoneTotalFlowEvent(identifer, true, false) : new ZoneTotalFlowEvent(identifer, false, false);
                zoneTotal.setMinSumEvent(true);
                zoneTotal.setMaxEvent(each.isIsMaxEvent());
                if (each instanceof InFlowEvent) {
                    zoneTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    zoneTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                totalList.add(zoneTotal);
            }
        }
        return totalList;
    }

    private Collection<? extends T> sumByDevice(List<T> events) {
        Map<Type, List<T>> deviceGroup = this.dividByType(events, 3);
        List<T> deviceList = this.processDeviceGroup(deviceGroup);
        if (this.isMinSumDevFlowSave) {
            EventUtil.createEvents(deviceList);
        }
        return deviceList;
    }

    private List<T> processDeviceGroup(Map<Type, List<T>> deviceGroup) {
        ArrayList<DevTotalFlowEvent> totalList = new ArrayList<DevTotalFlowEvent>();
        for (Map.Entry<Type, List<T>> entry : deviceGroup.entrySet()) {
            List<T> eventList = entry.getValue();
            for (Event each : eventList) {
                EventIdentifier identifer = each.getIdentifierCopy();
                identifer.setDeviceType();
                DevTotalFlowEvent devTotal = null;
                devTotal = each.isIsDropFlow() ? new DevTotalFlowEvent(identifer, true, false) : new DevTotalFlowEvent(identifer, false, false);
                devTotal.setMinSumEvent(true);
                devTotal.setMaxEvent(each.isIsMaxEvent());
                if (each instanceof InFlowEvent) {
                    devTotal.mergeInFlowEvent((InFlowEvent)each);
                }
                if (each instanceof DiscardFlowEvent) {
                    devTotal.mergeDiscardFlowEvent((DiscardFlowEvent)each);
                }
                totalList.add(devTotal);
            }
        }
        return totalList;
    }

    private Map<Type, List<T>> dividByType(List<T> events, int typeFlag) {
        HashMap<Type, List<T>> map = new HashMap<Type, List<T>>();
        for (Event e : events) {
            if (!e.isNeedSum()) continue;
            EventIdentifier header = e.getIdentifier();
            FilterType type = null;
            switch (typeFlag) {
                case 1: {
                    if (!e.isZoneIp()) break;
                    type = new IpType(header, false, false, false);
                    break;
                }
                case 2: {
                    if (!e.isZoneEvent()) break;
                    type = new ZoneType(header, false, false, false);
                    break;
                }
                case 3: {
                    if (!e.isDeviceEvent() && (!e.isZoneEvent() || !"NFA".equals(e.getDeviceTypeName()))) break;
                    type = new DeviceType(header, false, false, false);
                    break;
                }
            }
            if (type != null) {
                if (map.containsKey(type)) {
                    ((List)map.get(type)).add(e);
                    continue;
                }
                ArrayList<Event> thisType = new ArrayList<Event>();
                thisType.add(e);
                map.put(type, thisType);
                continue;
            }
            this.logger.debug((Object)("no get type of typeFlag=" + typeFlag + ", event=" + e.toString()));
        }
        return map;
    }
}

