/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.entity.event.ZoneAttackEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneAttackLifeHandler
extends EventHandler<ChangeEvent<IpAttackEvent>, ChangeEvent<ZoneAttackEvent>> {
    private Map<Type, ZoneAttackEvent> zoneAttackRecords = new HashMap<Type, ZoneAttackEvent>();

    public ZoneAttackLifeHandler() {
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    public Map<Type, ZoneAttackEvent> getZoneAttackRecords() {
        return this.zoneAttackRecords;
    }

    public void init(List<ZoneAttackEvent> events) {
        for (ZoneAttackEvent event : events) {
            ZoneType type = new ZoneType(event.getIdentifier());
            this.zoneAttackRecords.put(type, event);
        }
        this.logger.info((Object)("init ok, cache data are " + this.zoneAttackRecords));
    }

    public void setZoneAttackRecords(Map<Type, ZoneAttackEvent> zoneAttackRecords) {
        this.zoneAttackRecords = zoneAttackRecords;
    }

    public List<ChangeEvent<ZoneAttackEvent>> updateZoneAttackCache(Map<Type, List<IpAttackEvent>> eventsAfterMergeByZone) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" before update zoneAttack  events :cache is  " + LogManager.NEXT_LINE + this.zoneAttackRecords));
        }
        this.logger.info((Object)(" before update zoneAttack events ,size is " + this.zoneAttackRecords.size()));
        ArrayList<ChangeEvent<ZoneAttackEvent>> changedEvents = new ArrayList<ChangeEvent<ZoneAttackEvent>>();
        for (Map.Entry<Type, List<IpAttackEvent>> entry : eventsAfterMergeByZone.entrySet()) {
            Type type = entry.getKey();
            List<IpAttackEvent> values = entry.getValue();
            ZoneAttackEvent zone = this.getIpAttackEventByType(type, values.get(0).getIdentifierCopy());
            Event changeEvent = zone.sumElement((List)values);
            ChangeEvent<Event> changed = new ChangeEvent<Event>(zone, changeEvent);
            if (zone.isNormal()) {
                this.zoneAttackRecords.remove(type);
            }
            changedEvents.add(changed);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" after update zoneAttack  events :cache is  " + LogManager.NEXT_LINE + this.zoneAttackRecords));
        }
        this.logger.info((Object)(" after update zoneAttack events ,size is " + this.zoneAttackRecords.size()));
        return changedEvents;
    }

    @Override
    protected List<ChangeEvent<ZoneAttackEvent>> handelEvents(List<ChangeEvent<IpAttackEvent>> events) {
        if (!events.isEmpty()) {
            ArrayList<IpAttackEvent> ipattacks = new ArrayList<IpAttackEvent>();
            for (ChangeEvent<IpAttackEvent> each : events) {
                ipattacks.add(each.getChange());
            }
            Map<Type, List<IpAttackEvent>> groups = EventUtil.groupEventsByZone(ipattacks, false);
            return this.updateZoneAttackCache(groups);
        }
        return new ArrayList<ChangeEvent<ZoneAttackEvent>>();
    }

    private ZoneAttackEvent getIpAttackEventByType(Type key, EventIdentifier identifier) {
        if (this.zoneAttackRecords.containsKey(key)) {
            return this.zoneAttackRecords.get(key);
        }
        ZoneAttackEvent event = new ZoneAttackEvent(identifier);
        this.zoneAttackRecords.put(key, event);
        return event;
    }
}

